static char *RCSid = "$Header: scan.c,v 1.5 88/04/01 04:40:54 muir Locked $";

/*
 * $Log:	scan.c,v $
 * Revision 1.5  88/04/01  04:40:54  muir
 * rcsid now at top
 * 
 */

/*
 * scan.c
 *
 * scan buffer, chop it into sub strings
 *
 * Dave Pare, 1986
 */

#ifdef hpux
#define index strchr
#define bzero(a,b) memset(a,0,b)
#endif

#include <stdio.h>
#ifdef hpux
#include <memory.h>
#endif


char	*argp[50];
static	int maxargs = 50;
char	dpbuf[1024];

#define	TRUE	1
#define FALSE	0

int
scan(line, argpp, fsp)
	register char *line;
	char	***argpp;
	char	*fsp;
{
	extern	char *malloc();
	register char c;
	register int args = 0;
	register int i;
	char	fs[20];
	char	*dp;
	int	inword = FALSE,
		inquote = FALSE,
		k;

	dp = dpbuf;
	*argpp = NULL;
	i = strlen(line);
	if (i == 0)
		return 0;
	/*
	 * we're just guessing at the size of the
	 * data and pointer arrays.  Sure hope this
	 * turns out to be enough!
	 */
	/*
	 * initialize the arg pointers to NULL
	 */
	bzero(argp, maxargs);
	bzero(dp, sizeof(dp));
	/*
	 * if there is no fs, put in the default
	 */
	if (fsp == NULL || fsp[0] == NULL)
		strcpy(fs," \t\n");
	else
		strcpy(fs, fsp);
	args = -1;
	/*
	 * main loop starts here
	 */
	while ((c = *line++) && args < maxargs) { 
		if (c == '"') {
			if (inquote) {
				/* terminate the arg */
				inquote = FALSE;
				inword = FALSE;
				dp++;
				*dp = NULL;
			} else {
				/* add a new arg */
				args++;
				inquote = TRUE;
				inword = TRUE;
				argp[args] = dp+1;
			}
			continue;
		}
		k = index(fs, c);
		if (k) {
			if (inquote) {
				/* ignore fs as we are inside quotes */
				dp++;
				*dp = c;
			} else if (inword) {
				/* terminate an arg */
				dp++;
				*dp = NULL;
				inword = FALSE;
			}
		} else if (!inword) {
			/* add new arg to list */
			dp++;
			args++;
			*dp = c;
			argp[args] = dp;
			inword = TRUE;
		} else {
			dp++;
			*dp = c;
		}
	}
	if (args < 0)
		return 0;
	else {
		dp++;
		*dp = NULL;
	}
	*argpp = argp;
	return ++args;
}
