static char *RCSid = "$Header: /usr6/postgres/muir/empire/client/RCS/main.c,v 1.15 89/02/27 23:13:44 muir Exp $";

/*
 * main.c
 *
 * front end to empire
 *
 * Dave Pare, 1986
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <pwd.h>
#include <signal.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/file.h>
#ifdef OLDSOCKETS
#include <sys/ioctl.h>
#endif OLDSOCKETS
#include <setjmp.h>
#include <errno.h>
#include <sgtty.h>
#include "defs.h"
#include "sailio.h"
#ifdef hpux
#include <memory.h>
#define rindex strrchr
#define index strchr
#define bcopy(a,b,c) memcpy(b,a,c)
#define bzero(a,b) memset(a,0,b)
#endif

#define	C_MODE_NAME	"Command"
#define E_MODE_NAME	"Execute"

char	lastbuf[1024];
int	lastcode;
char	commandmode[60] = C_MODE_NAME;
extern char	*getpass ();
char *readline ();
int	pipeout = 0;
int	(*pipsig)();
FILE	*redir_fp = 0;
FILE	*auxout_fp = 0;

main(ac, av)
	int	ac;
	char	*av[];
{
	extern	char *getenv();
	extern	char *recvserver();
	extern	char *gets();
	extern	int intr();
#ifdef KILLSERVER
	extern	int dgs;
	extern	int killcode;
#else
	extern	int oob();
#endif
	extern	int timeout();
	extern	FILE *redir();
	extern	int errno;
	extern	char empirehost[];
	extern	char client_version[];
	extern	SAIL *iop;
	extern	short emp_port;
	extern	jmp_buf env;
	struct	servent *sp;
	struct	hostent *hp;
	struct	sockaddr_in sin;
	struct	passwd *pwd;
	char	buf[1024];
	char	country[255];
	char	password[255];
	char	*p;
	char	*auxout_fname = NULL;
	int	code;
	int	btu;
	int	time;
	int	s;
	short	port;
	int	prompt;
	int	ep;
	char    *argv[128];
	int	argc;

	/*
	 *  copy the argv and clear it (so nothing shows up in a ps)
	 */
	{
	    extern char *malloc();
	    extern char *strcpy();
	    short i;
	    register char *ptr;

	    for (i = argc = 0; i < ac; ++i) {
		ptr = av[i];
		if (strcmp(ptr, "-2") == 0) {
		    if (i + 1 >= ac) {
			fprintf(stderr, "-2: Missing filename!\n");
			exit(1);
		    }
		    auxout_fname = strcpy(malloc(strlen(av[i+1])+1), av[i+1]);
		    ++i;	/* skip the file name */
		    continue;
		}
		argv[argc++] = strcpy(malloc(strlen(av[i])+1), ptr);
		while (*ptr)
		    *ptr++ = ' ';
	    }
	}
	if (auxout_fname) {
		auxout_fp = fopen(auxout_fname, "a");
		if (auxout_fp == NULL) {
			fprintf(stderr, "Unable to open %s for append\n",
				auxout_fname
			);
			exit(1);
		}
	}
	

	pwd = getpwuid(getuid());
	if (pwd == NULL) {
		fprintf(stderr, "You don't exist.  Go away\n");
		exit(1);
	}
	getsose();
	if (p = getenv("EMPIREPORT")) {
		ep = atoi(p);
		port = htons(ep);
	} else {
		sp = getservbyname("empire", "tcp");
		if (sp == NULL) {
			port = htons(emp_port);
		} else
			port = sp->s_port;
	}
	p = getenv("EMPIREHOST");
	if (p == 0)
		p = empirehost;
	if (isdigit(*p)) {
		sin.sin_addr.s_addr = inet_addr(p);
	} else {
		hp = gethostbyname(p);
		if (hp == NULL) {
			fprintf(stderr, "Cannot find empire host %s\n", p);
			exit(1);
		}
		bcopy(hp->h_addr, (char *)&sin.sin_addr, sizeof(sin.sin_addr));
	}
	s = socket(AF_INET, SOCK_STREAM, 0);
	if (s < 0) {
		perror("socket");
		exit(1);
	}
	sin.sin_port = port;
	sin.sin_family = AF_INET;
	if (connect(s, &sin, sizeof(sin)) < 0) {
		perror("connect to host");
		exit(1);
	}
#ifdef KILLSERVER
	dgs = socket(AF_INET, SOCK_DGRAM, 0);
	if (dgs < 0) {
		perror("datagram socket");
		exit(1);
	}
	if (connect(dgs, &sin, sizeof(sin)) < 0) {
		perror("connect to host, dgram");
		exit(1);
	}
#endif
#ifndef hpux
	fcntl(s, F_SETOWN, getpid());
#endif
#ifdef OLDSOCKETS
	/* undocumented means to get old 4.2 sockets to receive SIGURG
	   and SIGIO signals */
	{
		int pid = -getpid();
		if (ioctl(s, SIOCSPGRP, (char *) &pid) < 0) {
			perror("ioctl for pgrp");
			exit(1);
		}
	}
#endif OLDSOCKETS
#ifndef KILLSERVER
	signal(SIGURG, oob);
#endif
	iop = sopen(s);
	(void) recvserver(&code, buf);
	if (code != C_INIT) {
		fprintf(stderr, "Server problems: %d %s\n", code, buf);
		exit(1);
	}
	(void) sendserver(USER, pwd->pw_name);
	(void) recvserver(&code, buf);
	if (code != C_CMDOK) {
		(void) fprintf(stderr, "bad reply: %d %s\n", code, buf);
		exit(1);
	}
	if (argc >= 2) {
		(void) strcpy(country, argv[1]);
		(void) bzero(argv[1], strlen(country));
	} else {
		(void) printf("Country name? ");
		*country = 0;
		if (gets(country) == 0 || *country == 0)
			exit(1);
	}
	(void) sendserver(COUN, country);
	(void) recvserver(&code, buf);
	if (code != C_CMDOK) {
		(void) fprintf(stderr, "%s: %s\n", *argv, buf);
		exit(1);
	}
	if (argc == 3) {
		(void) strcpy(password, argv[2]);
		(void) bzero(argv[2], strlen(argv[2]));
		password[8] = '\0';
	} else {
		p = getpass("Your name? ");
		if (p == NULL || *p == '\0')
			(void) exit(1);
		(void) strcpy (password, p);
		(void) bzero (p, strlen(p));
	}
	(void) printf("\n");
	(void) sendserver(PASS, password);
	/*
	 * for core-dumps...
	 */
	(void) bzero(password, sizeof(password));
	signal(SIGALRM, timeout);
	(void) recvserver(&code, buf);
	if (code != C_CMDOK) {
		(void) fprintf(stderr, "%s: %s\n", *argv, buf);
		(void) exit(1);
	}
	(void) sendserver(PLAY, (char *)0);
	(void) printf("\n\t-=O=-\n");
	(void) recvserver(&code, buf);
	if (code == C_INIT) {
		if (strcmp(client_version, buf)) {
			printf("Empire client out of date; get new version!\n");
			printf("   this version: %s\n", client_version);
			printf("current version: %s\n", buf);
		}
	} else {
		printf("not version number: %s\n", buf);
		exit(1);
	}
#ifdef KILLSERVER
	(void) recvserver(&code, buf);
	if (code == C_KILLCODE) {
		killcode = atoi(buf);
	} else {
		printf("version trouble!\n");
	}
#endif
	prompt = 0;
	lastcode = 0;
	(void) signal(SIGINT, intr);
	if (code = setjmp(env)) {
		if (code == C_SIGHOLD) {
			/*
			 * we don't care about seeing a repeat
			 * of old data
			 */
			if (lastcode == C_DATA) {
				code = 0;
			} else {
				/*
				 * but we want to redisplay prompt
				 * (and re-enter prompt gets)
				 */
				strcpy(buf, lastbuf);
				code = lastcode;
			}
		} else
			code = 0;
		if (redir_fp) {
			fflush(redir_fp);
			if (pipeout) {
				pclose (redir_fp);
				(void) signal (SIGPIPE, pipsig);
			}
			else 	fclose(redir_fp);
			redir_fp = 0;
		}
	}
	redir_fp = 0;
	if (code == 0)
		recvserver(&code, buf);
	do {
		lastcode = code;
		strcpy(lastbuf, buf);
		if (code == C_PROMPT) {
			prompt++;
			continue;
		}
		if (code == C_DATA) {
			if (redir_fp != 0)
				(void) fprintf(redir_fp, "%s\n", buf);
			else
				(void) puts(buf);
			if (auxout_fp)
			    (void) fprintf(auxout_fp, "%s\n", buf);
			continue;
		}
		if (code == C_NOECHO) {
			/*
			 * noecho implies a no-echo read.  fake it here
			 */
			_noecho(fileno(stdin));
			code = C_FLUSH;
		}
		if (prompt) {
			/*
			 * this is the main empire prompt.
			 * You know, " [%d:%d] Command : "
			 */
			if (auxout_fp)
				fflush(auxout_fp);
			if (redir_fp != 0) {
				fflush(redir_fp);
				if (pipeout) {
					pclose(redir_fp);
					(void) signal (SIGPIPE, pipsig);
				}
				else	fclose(redir_fp);
				redir_fp = 0;
			}
			if (sscanf(buf, "%d %d", &btu, &time) != 2) {
				if (*buf != 0 && *buf != '\n')
					(void) fprintf(stderr,
						"prompt error: %s\n", buf);
				continue;
			}
			(void) sprintf(buf, "\n[%d:%d] %s : ", btu, time,
				       commandmode);
		}
		if (code == C_FLUSH) {
			if (*buf != 0) {
				(void) printf("%s", buf);
				if (auxout_fp)
					(void) fprintf(auxout_fp, "%s", buf);
			}
			(void) fflush(stdout);
			if (auxout_fp)
				(void) fflush(auxout_fp);
			if (prompt)
				alarm(5*60);
			p = readline(buf, sizeof(buf), prompt);
			if (auxout_fp)
				(void) fprintf(auxout_fp, "%s\n", buf);
			if (prompt)
				alarm(0);
			if (errno == EINTR) {
				errno = 0;
				(void) perror("gets");
				continue;
			}
			if (p == 0) {
				(void) sendserver(CTLD, (char *)0);
				(void) clearerr(stdin);
			} else {
				if (prompt)
					redir_fp = redir(buf);
				(void) sendserver(CMD, buf);
			}
			*lastbuf = 0;
			code = 0;
			prompt = 0;
			_echo(0);
			continue;
		}
		if (code == C_EXIT) {
			(void) printf("%s\n", buf);
			if (auxout_fp)
				fprintf(auxout_fp, "%s\n", buf);
			break;
		}
	} while (recvserver(&code, buf) != NULL);
	(void) sclose(iop);
#ifdef KILLSERVER
	sprintf(buf,"e%d",killcode);
	write(dgs,buf,strlen(buf));
	close(dgs);
#endif
}

static	int _isecho = 1;

_noecho(fd)
	int	fd;
{
	struct	sgttyb sgbuf;

	_isecho = 0;
	(void) ioctl(fd, TIOCGETP, &sgbuf);
	sgbuf.sg_flags &= ~ECHO;
	(void) ioctl(fd, TIOCSETP, &sgbuf);
}

_echo(fd)
	int	fd;
{
	struct	sgttyb sgbuf;

	if (_isecho)
		return;
	(void) ioctl(fd, TIOCGETP, &sgbuf);
	sgbuf.sg_flags |= ECHO;
	(void) ioctl(0, TIOCSETP, &sgbuf);
	_isecho++;
}

static FILE	*fpinput = stdin;

/* 
 * read a line from the current input (file or stdin) - stacking
 * the file read over the standard input.
 */
char	*readline (buffer, size, prompt)
char	buffer[];
int	size, prompt;
{
	char	*p;
	extern char	*index ();
	int	n;
	char	**argv;

	p = fgets (buffer, size, fpinput);
	if (p == NULL && fpinput != stdin) { /* EOF && reading from file */
		(void) fclose (fpinput);
		fpinput = stdin;
		(void) strcpy (commandmode, C_MODE_NAME);
		(void) strcpy (buffer, "");
		return buffer;
	}
	else if (p == NULL)	/* EOF & ! reading from file */
		return NULL;

	if(p = index(buffer, '\n'))
		*p = '\0';	/* zap the lf */

	if (!prompt)	/* not a real prompt -> shouldn't be an exec! */
		return buffer;
	/* go looking for an exec string */
	for(p = buffer; *p && isspace(*p); p++)
		continue;

	/* nope? - get out quick and on with the game */
	if (strncmp (p, "exec", 4) != 0)
		return buffer;

	if (fpinput != stdin) {	/* check for exec within exec */
		printf ("Recursive exec's are not allowed!\n");
		(void) strcpy(buffer, "");
		return buffer;
	}
	n = scan(buffer, &argv, " \t");
	if ( n != 2) {
		printf ("Usage: exec filename\n");
		(void) strcpy(buffer, "");
		return buffer;
	}
	if ((fpinput = fopen(argv[1], "r")) == NULL) {
		printf ("Can't read file %s\n", argv[1]);
		fpinput = stdin;
	}
	else	(void) strcpy (commandmode, E_MODE_NAME);
	(void) strcpy(buffer, "");
	return buffer;
}
