static char *RCSid = "$Header: handle.c,v 1.3 88/04/01 04:39:50 muir Locked $";

/*
 * $Log:	handle.c,v $
 * Revision 1.3  88/04/01  04:39:50  muir
 * rcsid now at top
 * 
 */

/*
 * handle.c
 *
 * interrupt handler
 *
 * Dave Pare, 1986
 * and David Muir Sharnoff, 1987
 */

#include <sys/types.h>
#include <signal.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <setjmp.h>
#include <stdio.h>
#include "sailio.h"
#include "defs.h"

#ifndef KILLSERVER
static	char c;
#endif

#ifdef KILLSERVER
static	char	codenum[30];
extern int	dgs;

static 
sendit()
{
}
#endif
	

/* ARGSUSED */
intr(sig)
	int	sig;
{
	extern	char *recvserver();
	extern	SAIL *iop;
	extern	jmp_buf env;
	extern	int errno;
	char	buf[1024];
	int	code;

#ifdef	KILLSERVER
	int	rv;
	extern int	killcode;

	sprintf(codenum,"s%d",killcode);

	for (;;) {
		write(dgs,codenum,strlen(codenum));
		signal(SIGALRM,sendit);
		alarm(1);
		rv = recv(dgs,buf,40,0);
		if (rv > 0) {
			buf[rv] = '\0';
			if (strncmp(codenum,buf,40) == 0)
				break;
			printf("got wrong data back: %s\n",buf);
		}
		printf("\nresending ^C to server\n");
	}
	alarm(0);
	signal(SIGALRM,SIG_IGN);

	iop->o_ptr = iop->o_base;
	iop->o_cnt = 0;

#else	KILLSERVER
	c = sig;
	iop->o_ptr = iop->o_base;
	iop->o_cnt = 0;
	(void) send(iop->fd, &c, sizeof(c), MSG_OOB);
	send(iop->fd, "\01", sizeof("\01"), 0);
#endif	KILLSERVER
	/*
	 * throw away everything until we get to the interrupt.
	 */
	while (recvserver(&code, buf) && code != C_ABORT) {
		/* printf("throwing away: %s",buf); */
	}
	recvserver(&code, buf);
	if (code == C_SIGREL) {
		longjmp(env, C_SIGREL);
	}
	recvserver(&code, buf);
	printf("%s\n", buf);
	fflush(stdout);
	(void) longjmp(env, C_SIGHOLD);
}

#ifndef KILLSERVER
/*
 * out of band message from other side:
 * read what server has to say by longjmping out
 * current state.
 */
/* ARGSUSED */
oob(sig)
	int	sig;
{
	int	atmark;
	char	junk[2048];
	int	n;
	char	mark;

	/*
	 * throw away pending i/o, read up to the OOB mark,
	 * and then read the oob message.  Right now it doesn't
	 * mean anything...
	 */
	iop->i_ptr = iop->i_base;
	iop->o_ptr = iop->o_base;
	iop->i_cnt = 0;
	iop->o_cnt = 0;
	for (;;) {
		ioctl(0, SIOCATMARK, &atmark);
		if (atmark)
			break;
		n = read(0, junk, sizeof(junk));
		if (n <= 0)
			break;
	}
	recv(iop->fd, &mark, sizeof(mark), MSG_OOB);
	/*
	 * SIGREL says (what a hack!) to "main" that we aren't
	 * prompting for input and that we should continue
	 * reading data.
	 */
	longjmp(env, C_SIGREL);
}
#endif KILLSERVER

timeout()
{
	fprintf(stderr, "Input timeout!  Logging you out...\n");
	exit(1);
}
