#ifndef lint
static char	rcsid[] = "$Header: ship.c,v 1.1 88/12/16 19:57:25 muir Locked $";
#endif lint

#include <sys/types.h>
#include "var.h"
#include "ship.h"
#include "menu.h"
#include "wio.h"
#include "swio.h"

extern int			vfix_var();
extern int			ship_next(), ship_prev(), ship_save();

static int			ship_n = 0;
static int			nv = MAXSHPV;
static struct shpstr		ship;
static struct menu_control	ship_control = {
	0,	ship_next,	ship_prev,	ship_save
};
static struct menu		ship_menu[] = {
	{ "Index",	wio_pii,  wio_sii,  0, (char *)&ship_n },
	{ "Location",	wio_pci2, wio_sci2, 0, &ship.shp_x, &ship.shp_y },
	{ "Owner",	swio_pown, wio_sci,   0, &ship.shp_own },
	{ "Type",	swio_pshiptype, wio_sci,   0, &ship.shp_type },
	{ "Effic",	wio_pci, wio_sci,   0, &ship.shp_effic },
	{ "Mobility",	wio_pci, wio_sci,   0, &ship.shp_mobil },
	{ "Unit ID",	wio_psi, wio_ssi,   0, (char *)&ship.shp_uid },
	{ "Forward",	wio_psi, wio_ssi,   0, (char *)&ship.shp_fwd },
	{ "Backward",	wio_psi, wio_ssi,   0, (char *)&ship.shp_back },
	{ "Nplane",	wio_pci, wio_sci,   0, &ship.shp_nplane },
	{ "Fleet",	wio_pci, wio_sci,   0, &ship.shp_fleet },
	{ "Tech",	wio_psi, wio_ssi,   0, (char *)&ship.shp_tech },
	{ "Contents",	0,0,vfix_var,0,0, (char *)ship.shp_vtype,
			(char *)ship.shp_vamt, (char *)&nv },
};

vfix_ship()
{

	ship_load(ship_n);

	menu(&ship_control, ship_menu, sizeof(ship_menu) / sizeof(struct menu));
}

ship_next()
{

	ship_n += 1;
	ship_load(ship_n);
}

ship_prev()
{

	ship_n -= 1;
	if (ship_n < 0)
		ship_n = 0;
	ship_load(ship_n);
}

ship_save()
{

	fio_shipput(ship_n, &ship);
}

static
ship_load(n)
	int	n;
{
	
	if (fio_shipget(n, &ship) == 0)
		bzero(&ship, sizeof(ship));
}
