#ifndef lint
static char	rcsid[] = "$Header: /usr6/postgres/muir/empire/UTIL/vfix/RCS/plane.c,v 1.2 89/03/03 16:52:07 muir Exp $";
#endif lint

#include "plane.h"
#include "menu.h"
#include "wio.h"
#include "swio.h"

extern int			var();
extern int			plane_next(), plane_prev(), plane_save();

static int			plane_n = 0;
static struct plnstr		plane;
static struct menu_control	plane_control = {
	0,	plane_next,	plane_prev,	plane_save
};
static struct menu		plane_menu[] = {
	{ "Index",	wio_pii,  wio_sii,  0, (char *)&plane_n },
	{ "Location",	wio_pci2, wio_sci2, 0, &plane.pln_x, &plane.pln_y },
	{ "Owner",	swio_pown, wio_sci,   0, &plane.pln_own },
	{ "Type",	swio_ppt, wio_sci,  0, &plane.pln_type },
	{ "Effic",	wio_pci, wio_sci,   0, &plane.pln_effic },
	{ "Mobility",	wio_pci, wio_sci,   0, &plane.pln_mobil },
	{ "Range",	wio_pci, wio_sci,   0, &plane.pln_range },
	{ "Attack",	wio_pci, wio_sci,   0, &plane.pln_att },
	{ "Defense",	wio_pci, wio_sci,   0, &plane.pln_def },
	{ "Wing",	wio_pci, wio_sci,   0, &plane.pln_wing },
	{ "Tech",	wio_psi, wio_ssi,   0, (char *)&plane.pln_tech },
	{ "Ship",	wio_psi, wio_ssi,   0, (char *)&plane.pln_ship },
	{ "Forward",	wio_psi, wio_ssi,   0, (char *)&plane.pln_fwd },
	{ "Backward",	wio_psi, wio_ssi,   0, (char *)&plane.pln_back },
	{ "Uid",	wio_psi, wio_ssi,   0, (char *)&plane.pln_uid },
	{ "Hardness",	wio_pci, wio_sci,   0, &plane.pln_harden },
	{ "Nuke Type",	wio_pci, wio_sci,   0, &plane.pln_nuketype },
	{ "Nuke Amt",	wio_pci, wio_sci,   0, &plane.pln_nukeamt },
	{ "Flags",	wio_pci, wio_sci,   0, &plane.pln_flags },
};

vfix_plane()
{

	plane_load(plane_n);

	menu(&plane_control, plane_menu, sizeof(plane_menu)
	    / sizeof(struct menu));
}

plane_next()
{

	plane_n += 1;
	plane_load(plane_n);
}

plane_prev()
{

	plane_n -= 1;
	if (plane_n < 0)
		plane_n = 0;
	plane_load(plane_n);
}

plane_save()
{

	fio_planeput(plane_n, &plane);
}


static
plane_load(n)
	int	n;
{
	
	if (fio_planeget(n, &plane) == 0)
		bzero(&plane, sizeof(plane));
}
