#ifndef lint
static char	rcsid[] = "$Header: map.c 1.1 89/03/16 $";
#endif lint

#include <sys/types.h>
#include <curses.h>
#include <ctype.h>
#include "var.h"
#include "sect.h"
#include "misc.h"
#include "nat.h"
#include "swio.h"

extern int	w_xsize, w_ysize;

extern struct dchrstr	dchr[];

WINDOW		*w_map = NULL;
WINDOW		*w_stat = NULL;
struct sctstr	*sects = NULL;
int		md_lines, md_cols;			/* map dimensions */
int		sd_lines, sd_cols;			/* status dimensions */

int		map_n = 0;

#define MAP_STATLINES	5
#define MAP_VERTBOR	2
#define MAP_HORZBOR	4

#define MAP_STRLEN	80

#define	NTOLINE(xx)	((xx) / (w_ysize / 2))
#define	NTOCOL(xx)	((xx) % (w_ysize / 2))
#define LADJ(xl) { \
	while (xl < 0)	\
		xl = xl + w_ysize; \
	while (xl >= w_ysize) \
		xl = xl - w_ysize; \
	}
#define CADJ(xc) { \
		while (xc < 0) \
			xc = xc + w_xsize; \
		while (xc >= w_xsize) \
			xc = xc - w_xsize; \
	}
#define LCADJ(xl, xc)	{ \
		LADJ(xl); \
		CADJ(xc) \
	}
#define CENTER(xcwl, xcwc, xmdl, xmdc) { \
		(xcwl) = (xmdl) / 2; \
		(xcwc) = ((xmdc) / 2) + ((xcwl) % 2); \
	}
#define	ORIENT(xsml, xsmc, xnml, xnmc, xmdl, xmdc) { \
		xsml = (xnml) - ((xmdl) / 2); \
		xsmc = ((xnmc) - ((xmdc) / 2)) + ((xsml) % 2); \
		LCADJ(xsml, xsmc); \
	}

vfix_map()
{
	int	sml, smc;				/* start x, y */
	int	cwl, cwc;				/* current x, y */
	int	c;

	sml = NTOLINE(map_n);
	smc = NTOCOL(map_n);

	if (w_map == NULL || w_stat == NULL || sects == NULL)
		map_init();

	CENTER(cwl, cwc, md_lines, md_cols);

	wclear(w_stat);
	wclear(w_map);

	map_statline();
	map_dstat(wcltomn(cwl, cwc, sml, smc));
	map_dmap(sml, smc);
	wmove(w_map, cwl, cwc);
	wrefresh(w_stat);
	wrefresh(w_map);

	while (1) {
		switch ((c = getchar())) {
		case 'c':
			CENTER(cwl, cwc, md_lines, md_cols);
			break;
		case 'g':
			cwc -= 2;
			break;
		case 'y':
			cwl--;
			cwc--;
			break;
		case 'u':
			cwl--;
			cwc++;
			break;
		case 'j':
			cwc += 2;
			break;
		case 'n':
			cwl++;
			cwc++;
			break;
		case 'b':
			cwl++;
			cwc--;
			break;
			break;
		case 'G':
			smc -= md_cols / 2;
			LCADJ(sml, smc);
			map_dmap(sml, smc);
			break;
		case 'Y':
			sml -= md_lines / 2;
			smc -= md_cols / 2;
			LCADJ(sml, smc);
			map_dmap(sml, smc);
			break;
		case 'U':
			sml -= md_lines / 2;
			smc += md_cols / 2;
			LCADJ(sml, smc);
			map_dmap(sml, smc);
			break;
		case 'J':
			smc += md_cols / 2;
			LCADJ(sml, smc);
			map_dmap(sml, smc);
			break;
		case 'N':
			sml += md_lines / 2;
			smc += md_cols / 2;
			LCADJ(sml, smc);
			map_dmap(sml, smc);
			break;
		case 'B':
			sml += md_lines / 2;
			smc -= md_cols / 2;
			LCADJ(sml, smc);
			map_dmap(sml, smc);
			break;
		case 'Z':			/* orient on this sector */
			break;
		case 'o':			/* orient on a given player */
			if (map_orient(&smc, &sml) == 0) {
				sml -= md_lines / 2;
				smc -= md_cols / 2;
				CENTER(cwl, cwc, md_lines, md_cols);
				map_dmap(sml, smc);
			}
			break;
		case '\r':
			{
				struct sctstr	*sp;
				int		n;

				n = wcltomn(cwl, cwc, sml, smc);
				sp = &sects[n];

				if (fio_sectget(n, sp) != 1)
					panic("fio_sectget(%d, 0x%x): %m\n",
					    n, sp);
				vfix_sect(sp->sct_x, sp->sct_y);
				wclear(w_stat);
				wclear(w_map);
				map_dmap(sml, smc);
				map_statline();
				map_dstat(wcltomn(cwl, cwc, sml, smc));
			}
			break;
		case '.':
		case '-':
		case '^':
			map_chtype(c, wcltomn(cwl, cwc, sml, smc));
			wclear(w_map);
			map_dmap(sml, smc);
			map_statline();
			wclear(w_stat);
			map_dstat(wcltomn(cwl, cwc, sml, smc));
			break;
		case 'q':
		case 'Q':
		case '\033':
			return;
		default:
			map_error();
		}

		if (cwl < MAP_VERTBOR || cwl > md_lines - MAP_VERTBOR - 1
		    || cwc < MAP_HORZBOR || cwc > md_cols - MAP_HORZBOR - 1) {
			ORIENT(sml, smc, sml + cwl, smc + cwc,
			    md_lines, md_cols);
			map_dmap(sml, smc);
			CENTER(cwl, cwc, md_lines, md_cols);
		}

		map_dstat(wcltomn(cwl, cwc, sml, smc));
		wmove(w_map, cwl, cwc);
		wrefresh(w_stat);
		wrefresh(w_map);
	}
}

map_dmap(sml, smc)
	int	sml;
	int	smc;
{
	extern struct dchrstr	dchr[];		/* for speed */
	int	cwl, cwc;
	int	sindex;

	for (cwl = 0; cwl < md_cols; cwl++)
		for (cwc = cwl % 2; cwc < COLS; cwc += 2) {
			wmove(w_map, cwl, cwc);
			waddch(w_map, dchr[sects[wcltomn(cwl, cwc, 
			    sml, smc)].sct_type].d_mnem);
		}
}

map_dstat(n)
	int	n;
{
	extern char	*var_ttos();
	struct sctstr	*sp;
	int		i;

	wmove(w_stat, 1, 0);
	wclrtobot(w_stat);

	sp = &sects[n];

	if (fio_sectget(n, sp) != 1)
		panic("fio_sectget(%d, 0x%x): %m\n", n, sp);

	wprintw(w_stat, "(%d, %d) Type: ", sp->sct_x, sp->sct_y);
	swio_psecttype(w_stat, &sp->sct_type);
	wprintw(w_stat, " Owner: ");
	swio_pown(w_stat, &sp->sct_own);
	wmove(w_stat, 2, 0);
	wprintw(w_stat,
	    "Effic: %d%% Mobil: %d Min: %d Gmin: %d Fert: %d Oil: %d Uran: %d",
		(int)sp->sct_effic, (int)sp->sct_mobil, (int)sp->sct_min,
		(int)sp->sct_gmin, (int)sp->sct_fertil, (int)sp->sct_oil,
		(int)sp->sct_uran);

	wmove(w_stat, 3, 0);
	for (i = 0; i < sp->sct_nv; i++)
		if (var_deldis((int)sp->sct_vtype[i]) == NULL)
			wprintw(w_stat, "%-4.4s ",
			    var_ttos((int)sp->sct_vtype[i]));

	wmove(w_stat, 4, 0);
	for (i = 0; i < sp->sct_nv; i++)
		if (var_deldis((int)sp->sct_vtype[i]) == NULL)
			wprintw(w_stat, "%-4.4d ",
			    (int)sp->sct_vamt[i]);
}

map_init()
{
	int	nsects;

	md_cols = COLS;
	md_lines = LINES - MAP_STATLINES;
	sd_cols = COLS;
	sd_lines = MAP_STATLINES;

	if ((w_map = newwin(md_lines, md_cols, 0, 0)) == NULL)
		panic("newwin(%d, %d, %d, %d): %m\n", md_lines, md_cols, 0, 0);
	if ((w_stat = newwin(sd_lines, sd_cols, md_lines, 0)) == NULL)
		panic("newwin(%d, %d, %d, %d): %m\n", md_lines, md_cols, 0, 0);
	nsects = (w_xsize / 2) * w_ysize;
	if ((sects = (struct sctstr *)malloc(sizeof(struct sctstr) * nsects))
	    == NULL)
		panic("malloc(%d): %m\n", sizeof(struct sctstr) * nsects);

	if (fio_sectbget(nsects, sects) < 0)
		panic("fio_sect(%d, 0x%x): %m\n", nsects, sects);
}

map_error()
{

	putc('\007', stdout);
}

map_statline()
{
	int	i;

	wmove(w_stat, 0, 0);
	for (i = 0; i < sd_cols; i++)
		waddch(w_stat, '-');
}

wcltomn(cwl, cwc, sml, smc)
	int	cwl;
	int	cwc;
	int	sml;
	int	smc;
{
	int	tl, tc;

	tl = sml + cwl;
	tc = smc + cwc;
	LCADJ(tl, tc);
	
	return ((tl * (w_ysize / 2)) + (tc / 2));
}

map_chtype(newtype, which)
	int		newtype;
	int		which;
{
	struct dchrstr	*dp;
	struct sctstr	*sp;
	int		n;
	int		index;

	for (dp = dchr, index = 0; dp->d_mnem != '\0'; dp++, index++)
		if (dp->d_mnem == (char)newtype)
			break;

	if (dp->d_mnem == '\0') {
		return;
	}

	sp = &sects[which];

	if (fio_sectget(which, sp) != 1)
		panic("fio_sectget(%d, 0x%x): %m\which",
		    which, sp);

	if (sp->sct_type == index)
		return;			/* already that type! */

	sp->sct_type = index;

	fio_sectput(which, sp);
}


char	*
map_query(sp)
	char	*sp;
{
	int	sav_x, sav_y;
	char	*answer;

	getyx(w_map, sav_y, sav_x);

	wmove(w_stat, 0, COLS / 2 - strlen(sp));

	wprintw(w_stat, sp);

	wrefresh(w_stat);

	if ((answer = (char *)malloc(MAP_STRLEN)) == NULL)
		panic("malloc(%d): %m\n", MAP_STRLEN);

	echo();
	nocrmode();
	nl();

	wscanw(w_stat, "%s", answer);

	noecho();
	crmode();
	nonl();

	map_statline();

	wmove(w_map, sav_y, sav_x);

	wrefresh(w_map);
	wrefresh(w_stat);

	return (answer);
}

map_orient(x, y)
	int		*x;
	int		*y;
{
	struct natstr	n;
	char		*answer;
	int		new_n;
	extern int	maxcno;

	answer = map_query("Orient on which country? ");

	if (isdigit(*answer)) {
		new_n = atoi(answer);
		if (new_n < 0 || new_n > maxcno) {
			free (answer);
			return (-1);
		}
	} else if ((new_n = nat_match(answer)) < 0) {
		free (answer);
		return (-1);
	}

	if (fio_natget(new_n, &n) == 0)
		panic("map_orient: non-existent country!\n");
	
	free (answer);

	*x = (int)n.nat_xcap;
	*y = (int)n.nat_ycap;

	return (0);
}
