#ifndef lint
static char	rcsid[] = "$Header: fio.c,v 1.1 88/08/09 12:47:43 muir Exp $";
#endif lint

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "loan.h"
#include "ship.h"
#include "plane.h"
#include "nuke.h"
#include <sys/file.h>

extern int	sectf, natf, newsf, loanf, shipf, planef, nukf;

int
fio_natgetall(np, size)
	struct natstr	*np;
	int		size;
{

	return (fio_genget(natf, 0, np, size));
}

int
fio_natget(n, np)
	int		n;
	struct natstr	*np;
{

	return (fio_genget(natf, n, np, sizeof(*np)));
}

int
fio_natbget(n, np)
	int		n;
	struct natstr	*np;
{

	return (fio_genget(natf, 0, np, sizeof(*np) * n));
}

fio_natput(n, np)
	int		n;
	struct natstr	*np;
{

	fio_genput(natf, n, np, sizeof(*np));
}

int
fio_nukeget(n, np)
	int		n;
	struct nukstr	*np;
{

	return (fio_genget(nukf, n, np, sizeof(*np)));
}

fio_nukeput(n, np)
	int		n;
	struct nukstr	*np;
{

	fio_genput(nukf, n, np, sizeof(*np));
}

int
fio_planeget(n, pp)
	int		n;
	struct plnstr	*pp;
{

	return (fio_genget(planef, n, pp, sizeof(*pp)));
}

fio_planeput(n, pp)
	int		n;
	struct plnstr	*pp;
{

	fio_genput(planef, n, pp, sizeof(*pp));
}

int
fio_sectget(n, sp)
	int	n;
	struct sctstr	*sp;
{

	return (fio_genget(sectf, n, sp, sizeof(*sp)));
}

int
fio_sectbget(n, sp)
	int	n;
	struct sctstr	*sp;
{

	return (fio_genget(sectf, 0, sp, sizeof(*sp) *n));
}

/*
 * If the sector ownership or designation changed, we must
 * tell the transaction manager ...
 */
fio_sectput(n, sp)
	int	n;
	struct sctstr	*sp;
{

	fio_genput(sectf, n, sp, sizeof(*sp));
}

int
fio_shipget(n, sp)
	int	n;
	struct shpstr	*sp;
{

	return (fio_genget(shipf, n, sp, sizeof(*sp)));
}

fio_shipput(n, sp)
	int	n;
	struct shpstr	*sp;
{

	fio_genput(shipf, n, sp, sizeof(*sp));
}

static
int
fio_genget(fd, n, bp, size)
	int	fd;
	int	n;
	char	*bp;
	int	size;
{
	int	pos;
	int	nread;

	pos = n * size;
	if (lseek(fd, pos, L_SET) != pos)
		panic("lseek(%d, %d, L_SET): %m\n", fd, pos);

	if ((nread = read(fd, bp, size)) == 0)		/* none to read */
		return (0);
	if (nread != size)				/* botched */
		panic("read(%d, 0x%x, %d): %m\n", fd, bp, size);

	return (1);
}

static
fio_genput(fd, n, bp, size)
	int	fd;
	int	n;
	char	*bp;
	int	size;
{
	int	pos;

	pos = n * size;
	if (lseek(fd, pos, L_SET) != pos)
		panic("lseek(%d, %d, L_SET): %m\n", fd, pos);

	if (write(fd, bp, size) != size)
		panic("write(%d, 0x%x, %d): %m\n", fd, bp, size);
}
