#ifndef lint
static char	rcsid[] = "$Header: error.c,v 1.1 88/12/16 19:56:46 muir Locked $";
#endif lint

/*
 * Error reporting/handling routines error(), log(), warn(), panic()
 * all of which call _efmt().
 *
 * Written by Nick Lai.
 * Derived from / based on a similar package by Serge Granik.
 *
 * This software is in the public domain.
 */

#include <stdio.h>
#include <strings.h>
#include <time.h>
#include <sys/types.h>
#include <sys/file.h>

extern char	*sys_errlist[];
extern int	sys_nerr;
extern int	errno;

extern int	exit();
extern char	*malloc();

char	*_hostname = NULL;		/* name of host computer */
char	*_program = NULL;		/* name of program */
char	*_filename = NULL;		/* name of file */
int	_datestamp = 0;			/* date stamp message flag */

FILE	*_errorfp = stderr;		/* where to send error() output */
FILE	*_logfp = stderr;		/* where to send log() output */
FILE	*_panicfp = stderr;		/* where to send panic() output */
FILE	*_warnfp = stderr;		/* where to send warn() output */

int	(*_errorfunc)() = NULL;		/* error() handler */
int	(*_panicfunc)() = exit;		/* what to do on panic() */

char	*
_efmt(ofmt)
	char		*ofmt;		/* old format string */
{
	char		*nfmt;		/* new format string */
	register char	*ocp, *ncp;	/* pointers into format strings */
	time_t		now, time();	/* current time in seconds */

	if ((nfmt = (char *)malloc(BUFSIZ)) == NULL)
		return (ofmt);			/* what else can we do? */

	nfmt[0] = '\0';

	if (_datestamp != 0) {
		now = time((time_t *)0);	/* obsolete but portable */
		(void) strcat(nfmt, ctime(&now));
		if ((ncp = index(nfmt, '\n')))
			*ncp = '\0';
		if (!_hostname && !_program && !_filename)
			(void) strcat(nfmt, ": ");
		else
			(void) strcat(nfmt, " ");
	}
	if (_hostname) {
		(void) strcat(nfmt, _hostname);
		if (!_program && !_filename)
			(void) strcat(nfmt, ": ");
		else
			(void) strcat(nfmt, " ");
	}
	if (_program) {
		(void) strcat(nfmt, _program);
		if (!_filename)
			(void) strcat(nfmt, ": ");
		else
			(void) strcat(nfmt, " ");
	}
	if (_filename) {
		(void) strcat(nfmt, _filename);
		(void) strcat(nfmt, ": ");
	}

	if ((ncp = index(nfmt, '\0')) == NULL)
		return ("_efmt: internal error\n");

	for (ocp = ofmt; *ocp != '\0';) {
		if (ocp[0] == '%' && ocp[1] == 'm') {
			if (errno < 0 || errno >= sys_nerr)
				(void) sprintf(ncp, "unknown error %d", errno);
			else
				(void) strcat(ncp, sys_errlist[errno]);
			if ((ncp = index(nfmt, '\0')) == NULL)
				return ("_efmt: internal error\n");
			ocp += 2;
		} else {
			*ncp = *ocp;
			ncp++;
			ocp++;
		}
	}

	*ncp = '\0';

	return (nfmt);
}

error(fmt, argv)
	char	*fmt;
	char	*argv;
{

	_doprnt(_efmt(fmt), &argv, _errorfp);

	if (_errorfunc)
		(_errorfunc)(errno);
	
	return;
}

log(fmt, argv)
	char	*fmt;
	char	*argv;
{

	_doprnt(_efmt(fmt), &argv, _logfp);

	return;
}

FILE	*
open_log(filename, mode)
	char	*filename;
	char	*mode;
{

	if ((_logfp = fopen(filename, mode)) == (FILE *)NULL)
		return (NULL);
	if (fcntl(fileno(_logfp), F_SETFD, 1) < 0)	/* close on exec */
		return (NULL);
	
	return (_logfp);
}

panic(fmt, argv)
	char	*fmt;
	char	*argv;
{

	_doprnt(_efmt(fmt), &argv, _panicfp);

	if (_panicfunc)
		(_panicfunc)(errno);
}

warn(fmt, argv)
	char	*fmt;
	char	*argv;
{

	_doprnt(_efmt(fmt), &argv, _warnfp);

	return;
}
