static char *RCSid = "$Header: /n/postgres/a/postgres/muir/empire/empmain/RCS/empglb.c,v 1.41 89/01/15 11:20:54 muir Exp $";

/*
 * constglb.c
 *
 * Global constants file.
 *
 */

#include "gamesdef.h"
#include "misc.h"
#include "xy.h"

char    *privname   = PRVNAM;			      /* name of priv user */
char    *privlog    = PRVLOG;			   /* logname of priv user */
int	privuid     = PRVUID;			 /* uid of owner of Empire */
int	m_m_p_d     = 1000;	 /* max mins of play per day (per country) */

int	maxnoc      = MAXNOC;			   /* max num of countries */
int	maxcno      = MAXNOC-1;			    /* largest country num */

/* Note: this constant is still built into many info files  */
/* DO NOT use low values of this in this "server update" version */
/* without setting the PROD_ETU value to something large (like */
/* somewhere around 40 or so) or else your machine will die */
long    s_p_etu   = 1400;                  /* seconds per Empire time unit */
long    upd_adj	  = 0;			   /* update time adjustment */

/* Note: these constants are built into the "food" info file               */
/* "(dt * fert * wrk)" means the rate is multiplied by Empire time units,  */
/* fertility units and number of "workers" (civil + milit/5)               */
double   fgrate      = 0.0012;               /* food growth rate (dt * fert) */
double   fcrate      = 0.0013;       /* food cultivate rate (dt * workforce) */
double   eatrate     = 0.0010;            /* food eating rate (dt * people) */
double   babyeat     = 0.0120;      /* food to mature 1 baby into a civilian */

 /* values greater than 0.25 for either birth rate will give overflow */
double   obrate      = 0.005;                   /* other sectors birth rate */
double	 uwbrate     = 0.0025;		/* uncompensated worker birth rate */

/* this is the main factor in determining how much "hardware" exists... */
double   bankint     = 0.25;             /* bank interest rate (dt * bars) */

/* minimum trade mulitple */
double	 minmult     = 0.5;

/* money gained from taxes, paid to military, and reservists */
double	money_civ	= 0.0083333;
double	money_uw	= 0.0037777;
double	money_mil	= -0.0833333;
double	money_res	= -0.0083333;

/* edu and hap consumption factors -- hap_cons civs need 1 hap --> hlev++ */
double	hap_cons        = 5000.0;
double	edu_cons        = 4000.0;

/* hap and edu avg mean that the weight on current happiness is
 *  (cur_hap * hap_avg + hap_prod * etu) / (hap_avg + etu);  		*/
float   hap_avg = 48.0 * 1.0;
float   edu_avg = 48.0 * 4.0;

/* tech sharing among allies...  	 0 = no sharing */
float   ally_factor = 64.0;      /* shared tech with allies = 1/factor */

/* tech/research/hap/edu aging rate.  how may updates to decline 1% */
float	level_age_rate = 96.0; 	  /* old default was 48 , 0 = no decline */

/* tech build limitations.  Tech limits only apply after easy_tech.
 * Two ways of limiting tech: asymptotic or logrithmic:
 * tech_hard is asymptopic limitation, tech_log_base is the logrithmic
 * limitation.  set tech_log_base > 1.0 to have it take effect,
 * set hard_tech > 0 to have it take effect
 * for log based, only tech values where the slop is < 1 are used	*/

float	easy_tech = -2.0;	/* amount of tech built with no penality */
float	hard_tech = 0.0;	/* amount of in-efficiently built tech */
float	tech_log_base = 2.0;	/* base of log to take of in-efficient tech */

/* should player co-ordinate systems be centered at the deity's 0,0? */
int	players_at_00 = 0;		/* 1 for yes, 0 for no */

/* should players be given one 100/100/100/100 sector? */
int	at_least_one_100 = 1;		/* 1 for yes, 0 for no */

/* D_P_POWE power report parameters */
double	powe_cost	= 10.;	    /* btu cost to do a "new" power report */

/* btu limit and btu build rate: btus += etu's * eff * civs * build_rate */
int	max_btus	= 255;		/* suggested value: 511 */
float	btu_build_rate	= 1.0/2500.0;	/* suggested value: 1/5000 */

/* D_P_BUIL build parameters */
double	buil_bt		= 50.;	  /* tech level required to build a bridge */
int	buil_bh		= 100;		 /* hcm required to build a bridge */
double	buil_bc		= 2000.;	/* cash required to build a bridge */
