/*
 *	File:	inter.c
 *
 *	Allows the user to change the database
 */

#include <stdio.h>
#include "misc.h"
#include "list.h"

extern char * dataf;

static void Help ()
{
	printf ("Following commands are available:\n");
	printf ("l: list groups             u: list users of a group\n");
	printf ("a: add a user              d: delete a user\n");
	printf ("A: add a group             D: Delete a group\n");
	printf ("w: write database          q: quit\n");
}

static void ListGroups (list)
List list;
{
	char * ptr;
	int i;

	for (i = 0, ptr = FirstGroup (list);
	     ptr != (char *) 0;
	     i ++, ptr = NextGroup (list))
		puts (ptr);
	
	if (i == 0)
		printf ("No groups.\n");
}

static void GroupMembers (list, groupname)
List list;
char * groupname;
{
	Group group;
	User user;
	int i;

	group = GetGroup (list, groupname);

	if (group == (Group) 0)
	{
		fprintf (stderr, "Can't find group \"%s\".\n", groupname);
		return;
	}

	printf ("%s: ", groupname);
	for (i = 0, user = FirstUser (group);
	     user != (User) 0;
	     i ++, user = NextUser (group))
		printf ("\n\t%s <%s>", UserName (user), UserAddress (user));
	
	if (i == 0)
		printf ("No members\n");
	else
		printf ("\n");
}

void Inter (list)
List list;
{
	char * ans, * group, * username, * address;

	extern char * index ();

	for (;;)
	{
		ans = Get ("\nmlist> ");
		if (* ans == '\0')
			continue;

		if (index ("uadAD", * ans) != (char *) 0)
			group = Get ("group? ");

		switch (* ans)
		{

		case 'l':
			ListGroups (list);
			break;

		case 'u':
			GroupMembers (list, group);
			break;

		case 'a':
			username = Get ("Username? ");
			address = Get ("Address? ");
			AddUser (list, group, username, address);
			break;

		case 'd':
			username = Get ("Username? ");
			DeleteUser (list, group, username);
			break;

		case 'w':
			SaveList (list, dataf);
			break;

		case 'q':
			return;

		case 'h':
		case '?':
			Help ();
			continue;

		case 'A':
			AddGroup (list, group);
			break;

		case 'D':
			DeleteGroup (list, group);
			break;

		default:
			printf ("huh?\n");
			continue;
		}
	}
}
