#include "type.h"
#include "main.h"
#include "var.h"
#include "ship.h"
#include "sector.h"
#include "func.h"
#include "nation.h"

char * SelectShips (x, y, shtask, quest)
int x, y;
ShTask shtask;
char * quest;
{
	extern int last_layout;

	static char buffer [200];

	Strings strings;
	Pager pager;
	Ship ptr, ship;
	bool flag, first;
	int func;
	int i;
	int nr;

	strings = InitStrings ();
	AddStringID (strings, 
		      "Ship                   Fl Eff  Mob Civ Mil Foo Tec", -1);

	for (ptr = s_fship (cursct); ptr != (Ship) 0; ptr = sh_nxtsct (ptr))
	{
		if (! sh_owned (ptr))
			continue;

		if (shtask == ST_NAVIGATE && sh_mob (ptr) <= 0)
			continue;
		
		if (shtask == ST_UPGRADE && sh_tech (ptr) ==
							(int) n_tech (nation))
			continue;

		if (shtask == ST_TEND && ptr == curship)
			continue;

		AddStringID (strings, Fmt (
			"%-4d %-16.16s  %c %-3d%% %-3d %-3d %-3d %-3d %-4d",
				sh_nr (ptr),
				ShipName (ptr),
				sh_fleet (ptr),
				sh_eff (ptr),
				sh_mob (ptr),
				sh_civ (ptr),
				sh_mil (ptr),
				sh_foo (ptr),
				sh_tech (ptr)),
			sh_nr (ptr));

		nr = sh_nr (ptr);
	}

	if (StringsSize (strings) == 1)
	{
		FreeStrings (strings);
		Message ("No available ships.");
		Bell ();
		return (char *) 0;
	}
	else if (StringsSize (strings) == 2)
	{
		FreeStrings (strings);
		return Fmt ("%d", nr);
	}

	if (last_layout == SHIP_MODE)
		SetStringFlag (strings, sh_nr (curship), True);
	else if (last_layout == FLEET_MODE)
		for (ptr = s_fship (cursct); ptr != (Ship) 0;
							ptr = sh_nxtsct (ptr))
			if (sh_fleet (ptr) == curfleet)
				SetStringFlag (strings, sh_nr (ptr), True);

	pager = InitPager (strings, quest);
        AddPagerFunc (pager, "Cancel", CANCELFUNC);
	AddPagerFunc (pager, "Done", DONEFUNC);
        SetPagerButtons (pager, "Toggle", "Toggle Fleet", "Done");
        SetPagerButtonIDs (pager, TOGGLEFUNC, TOGGLEFLEETFUNC, DONEFUNC);
	SetPagerSelect (pager);

	MapPagerFromTop (pager, map_win, x, y);

	for (;;)
	{
		i = PagerMenuFunc (pager, & func, (int *) 0);

		if (i < 0)
		{
			FreePager (pager);
			FreeStrings (strings);
			return (char * ) 0;
		}

		switch (func)
		{

		case TOGGLEFUNC:
			if (i < 0)
				continue;
			ToggleStringFlag (strings, i);
			RemapPager (pager);
			continue;
			
		case TOGGLEWINGFUNC:
			if (i < 0)
				continue;
			flag = ! GiveStringFlag (strings, i);
			ship = NrToShip (i);
			for (ptr = s_fship (cursct); ptr != (Ship) 0;
							ptr = sh_nxtsct (ptr))
				if (sh_fleet (ptr) == sh_fleet (ship))
				     SetStringFlag (strings, sh_nr (ptr), flag);

			RemapPager (pager);
			continue;

		case DONEFUNC:
			FreePager (pager);
			InitStringList (strings);
			buffer [0] = '\0';
			first = True;
			while ((nr = GetNextSelectedId (strings)) != -1)
			{
				if (first)
					first = False;
				else
					strcat (buffer, "/");

				strcat (buffer, Fmt ("%d", nr));
			}

			FreeStrings (strings);
			if (first)
			{
				Message ("No ships selected");
				return (char *) 0;
			}
			else
				return buffer;
		
		case CANCELFUNC:
			FreePager (pager);
			FreeStrings (strings);
			return (char * ) 0;
		}
	}
}
