#include <varargs.h>
#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"

struct fmtst {
	char *str;
	struct fmtst *next;
} *firstbuf, *lastbuf;

/*VARARGS0*/
char *Fmt (va_alist)
va_dcl
{
	va_list args;
	char *ptr;
	struct fmtst *new;
	char fmtbuf [BUFSIZ];
	
	new = (struct fmtst *) doalloc (sizeof (struct fmtst));
	new->next = (struct fmtst *) 0;
	if (lastbuf == (struct fmtst *) 0)
		lastbuf = firstbuf = new;
	else
	{
		lastbuf-> next = new;
		lastbuf = new;
	}

	va_start (args);
	ptr = va_arg (args, char *);

	(void) vsprintf (fmtbuf, ptr, args);
	va_end (args);

	new->str = Str (fmtbuf);

	return new-> str;
}

void FreeFmts ()
{
	struct fmtst *next;

	for (next = firstbuf; next != (struct fmtst *) 0; next = firstbuf)
	{
		firstbuf = firstbuf-> next;
		free (next-> str);
		free (next);
	}
	firstbuf = lastbuf = (struct fmtst *) 0;
	
	return;
}

char *DateFmt (tim)
time_t tim;
{
	char dayname [5], monthname [5];
	int daynr, hour, min; 
	char *ctime ();

	(void) sscanf (ctime (& tim), "%4s %4s %d %d:%d",
		monthname, dayname, &daynr, &hour, &min);

	return Fmt ("%s %2d %s %2d:%02d",
				dayname, daynr, monthname, hour, min);
}

char *Centered (str, n)
char *str;
int n;
{
	return Fmt ("%*s%s", (n - strlen (str)) / 2, "", str);
}

bool CharInFormat (ch, format)
char ch, *format;
{
	char *ptr;

	for (ptr = format; *ptr != '\0'; ptr++)
		if (*(ptr + 1) == '-')
			if (ch >= *ptr && ch <= *(ptr + 2))
				return True;
			else
				ptr += 2;
		else
			if (*ptr == ch) 
				return True;
	return False;
}

char *Str (s)
char *s;
{
	char *ptr;

	ptr = doalloc ((unsigned) strlen (s) + 1);
	(void) strcpy (ptr, s);
	return ptr;
}

char *StrNl (s)
char *s;
{
	char *ptr;
	int len;

	len = strlen (s);
	ptr = doalloc ((unsigned) len + 2);
	strcpy (ptr, s);
	strcpy (ptr + len, "\n");
	return ptr;
}

void NoNl (str)
char * str;
{
	if (str [strlen (str) - 1] == '\n')
		str [strlen (str) - 1] = '\0';
}
		

char *CrdStr (sct)
Sector sct;
{
	return Fmt ("%d,%d", s_xcd (sct), s_ycd (sct));
}

double TechFact (level, mult)
int	level;
double	mult;
{
	return mult * ((50.0 + level) / (200.0 + level));
}

char *doalloc (size)
unsigned size;
{
	char *ptr;

	if ((ptr = malloc (size)) == (char *) 0) {
		perror ("Malloc Failed");
		leave ();
	}

	return ptr;
}

double PlagueChance (sct)
Sector sct;
{
	double plg_num, plg_denom;

        plg_num = ((s_civ (sct) + s_mil (sct) + q_uw (sct)) / 999.0) *
                ((q_iro (sct) + q_oil (sct)) / 10.0 + n_tech (nation) + 100.0);

        plg_denom = s_eff (sct) + s_mob (sct) + 100.0 + n_research (nation);

	if (plg_num <= plg_denom)
		return 0.0;
	else
		return (((plg_num / plg_denom) - 1.0) * 0.01);
}

char *  ReadEmpireStrings (strings)
Strings strings;
{
	char * ptr;

	for (;;)
	{
		ptr = ReadEmpire (DONT_PRINT);

		switch (EmpireStatus ())
		{

		case E_COMMAND:
			PrintAtEmpire (ptr);
			return (char *) 0;

		case E_PRINTING:
			AddString (strings, ptr);
			continue;
		
		case E_QUESTION:
			PrintAtEmpire (ptr);
			return ptr;
		}
	}
}

bool StrEQ (s1, s2)
char * s1, * s2;
{
	return (strncmp (s1, s2, strlen (s2)) == 0);
}

#define RUNWINY		20

static text_line = 0;
static WinInfo text_win = (WinInfo) 0;

void OpenTextWindow (x, y, name)
int x, y;
char *name;
{
#ifdef X_VERSION
	text_win = OpenWinForWM (name, x, y, 80, RUNWINY, CHARS, 0);
	text_line = 0;

	SetDefaultCursor (text_win, CR_SMILEY);

#else /* TERMC_VERSION */

	text_win = OpenRelToRoot (map_win, x, y, 70, RUNWINY, FULL_BOX, 0);
	text_line = 0;

#endif /* VERSION */
}

void CloseTextWindow ()
{
	DestroyWindow (text_win);
	text_win = (WinInfo) 0;
}

void ClearText ()
{
	text_line = 1;

	if (text_win == (WinInfo) 0)
		printf ("- - - -\n");
	else
		ClearWindow (text_win);
}

void ShowText (s)
char * s;
{
	if (text_win == (WinInfo) 0)
	{
		puts (s);
		fflush (stdout);
	}
	else
	{
		if (text_line == RUNWINY - 3)
		{
			PrintB (text_win, 1, RUNWINY - 1, "[ MORE ]");
			FlushWindow (text_win);
			Pause ();
			ClearWindow (text_win);
			text_line = 1;
		}

		PrintN (text_win, 1, text_line ++, s);
		FlushWindow (text_win);
	}
}

void ShowDone ()
{
	if (text_win != (WinInfo) 0)
	{
		PrintB (text_win, 1, ++ text_line, "[ DONE ]");
		FlushWindow (text_win);
		Pause ();
	}
}

void ShowStrings (strings)
Strings strings;
{
	char * ptr;

	InitStringList (strings);

	while ((ptr = GetNextString (strings)) != (char *) 0)
		ShowText (ptr);
}

double dmin(n1, n2)
double n1;
double n2;
{
	if (n1 < n2)
		return n1;
	return n2;
}

double dmax (d1, d2)
double d1, d2;
{
	if (d1 > d2)
		return d1;
	return d2;
}

char * MakeFreeString (upper, lower)
bool upper [], lower [];
{
	int j;
	static char buffer [53];
	char start, end;

	buffer [0] = '\0';
	end = start = '\0';
	for (j = 0; j < 26; j ++)
		if (lower [j])
			if (start != '\0')
				if (end == 'a' + j - 1)
					end ++;
				else
				{
					if (end == start)
						strcat (buffer, Fmt ("%c",
									start));
					else if (end != start + 1)
						strcat (buffer, Fmt ("%c-%c",
								start, end));
					else
						strcat (buffer, Fmt ("%c%c",
								start, end));
					start = end = 'a' + j;
				}
			else
				start = end = 'a' + j;
	
	if (start != '\0')
		if (end == start)
			strcat (buffer, Fmt ("%c", end));
		else if (end == start + 1)
			strcat (buffer, Fmt ("%c%c", start, end));
		else
			strcat (buffer, Fmt ("%c-%c", start, end));
	
	start = '\0';
	for (j = 0; j < 26; j ++)
		if (upper [j])
			if (start != '\0')
				if (end == 'A' + j - 1)
					end ++;
				else
				{
					if (end == start)
						strcat (buffer, Fmt ("%c",
									start));
					else if (end != start + 1)
						strcat (buffer, Fmt ("%c-%c",
								start, end));
					else
						strcat (buffer, Fmt ("%c%c",
								start, end));
					start = end = 'A' + j;
				}
			else
				start = end = 'A' + j;
	
	if (start != '\0')
		if (end == start)
			strcat (buffer, Fmt ("%c", end));
		else if (end == start + 1)
			strcat (buffer, Fmt ("%c%c", start, end));
		else
			strcat (buffer, Fmt ("%c-%c", start, end));

	return buffer;
}
