/* 
 * HISTORY
 * $Log: wavelan.h,v $
 * Revision 2.0  1996/10/01  15:42:45  bob
 * Reviewed PSA, MMI and added V.2 WaveMODEM
 *
 * Revision 1.1  1994/06/02  20:31:11  klemets
 * Initial revision
 *
 */
#ifndef	_CHIPS_WAVELAN_H
#define _CHIPS_WAVELAN_H

/* This file contains definitions that are common for all versions of
 * the NCR WaveLAN
 */

#define WAVELAN_ADDR_SIZE	6	/* Size of a MAC address */
#define WAVELAN_MTU		1500	/* Maximum size of Wavelan packet */

struct wl_cntrs {
	struct {
		u_int xmt, xmti;
		u_int defer;
		u_int busy;
		u_int sleaze, intrinsic, intrinsic_count;
		u_int chain;
		u_int heart;
		u_int coll;
		u_int ncoll;
		u_int nodcd;
		u_int nocts;
		u_int dma;
	} xmt; 
	struct {
		u_int rcv;
		u_int ovw;
		u_int crc;
		u_int frame;
		u_int rscerrs, ovrnerrs;
		u_int partial;
		u_int snr[5];
	} rcv;
	struct {
		u_short status;
		u_short nwids;
		u_short badnwids;
		u_short thrpreset;
		u_short siglvl;
		u_short sillvl;
		u_short sigqual;
		u_short netwidl;
		u_short des;
	} mmc;
	u_int watch;
};
typedef	struct wl_cntrs *wl_cntrs_t;

#define	CNTR_NAME	"_wl_cntrs"

/* command unit for wlsetstat */
struct wl_ucmd {
  int cmd;
  int param;
};
typedef struct wl_ucmd *wl_ucmd_t;

#ifdef	IF_CNTRS
/* interface driver specific counters */
struct wl_ifcntrs {
  int pkt_arp;
  int pkt_ein[32];
  int pkt_lin[128/8];
  int pkt_eout[32]; 
  int pkt_lout[128/8]; 
};
typedef struct wl_ifcntrs *wl_ifcntrs_t;
#define	NET_WL_IFCNTRS		(('w'<<16) + 3)
#define NET_WL_IFCNTRS_CNT	(sizeof (struct wl_ifcntrs)/sizeof(int))
#endif	IF_CNTRS

/* local flavor value for wlsetstat and wlgetstat */
#define	NET_WL_CNTRS		(('w'<<16) + 1)
#define	NET_WL_CMD		(('w'<<16) + 2)
#define	NET_WL_PSA		(('w'<<24) + ('l'<<16))
#define NET_WL_CNTRS_CNT	(sizeof (struct wl_cntrs)/sizeof(int))
#define NET_WL_CMD_CNT		(sizeof (struct wl_ucmd)/sizeof(int))
#define	NET_WL_PSA_CNT	1

#ifdef	IF_LINKSTATUS
#define NET_LINKSTATE		(('w'<<16) + 4)
#define NET_LADDR_ADD		(('w'<<16) + 5)
#define NET_LADDR_DEL		(('w'<<16) + 6)
#define NET_LADDR_ADD_CNT	((WAVELAN_ADDR_SIZE + sizeof(int) - 1)/sizeof(int))
#define NET_LADDR_DEL_CNT	((WAVELAN_ADDR_SIZE + sizeof(int) - 1)/sizeof(int))
#define	MAX_LINKADDR		64
#endif	IF_LINKSTATUS


/* local commands */
#define	WLCMD_CLEAR		1
#define WLCMD_SENDCMD		2
#define WLCMD_SETNWID		3
#define WLCMD_SETIRQ		4
#define WLCMD_PARAM		5
#define WLCMD_POWER_DOWN	6
#define WLCMD_POWER_UP		7


/*******************************
* Parameter Storage Area (PSA) *
*******************************/

/*
 * address 0000-000F:  The Hardware Interpreted PSA Segment
 * address 0010-003F:  The Software Interpreted PSA Segment
 */
/* Software interpreted PSA */
#define	PSA_MAC_ADDR		0x10	/* Factory network address */
#define	PSA_MAC_ADDR_LOCAL	0x16	/* Local network address */
#define	PSA_MAC_SELECT		0x1c	/* 0=factory, 1=local address */
#define	PSA_COMP_NUMBER		0x1d	/* 0=PC-AT 915 MHz, 1=PC-MC 915 MHz
					   2=PC-AT 2.4 GHz, 3=PC-MC 2.4 GHz */
#define	PSA_THR_PRE_SET		0x1e	/* Level threshold preset; max 0x3f */
#define	PSA_FEATURE_SELECT	0x1f	/* 1=Japan, 0=Other */
#define	PSA_SUBBAND		0x20	/* 1=2425 MHz, 2=2460 MHz, 3=2484 MHz
					   4=2430.5 MHz */
#define	PSA_QUALITY_THR		0x21	/* Quality threshold preset; 0x03 */
#define	PSA_NETW_ID		0x23	/* Network ID; 0100-FFFF */
#define	PSA_NETW_ID_SELECT	0x25	/* Select NWID; 0=off, 1=on */
#define PSA_SECURITY_SELECT	0x26	/* Select Datalink Security; 0=off,1=on */
#define PSA_ENCRYPTION_KEY	0x27	/* 8 bytes; each 00-FE */
#define PSA_DATABUS_WIDTH	0x2f	/* ??? */
#define PSA_CALL_CODE		0x30	/* Call code; for Japanese market */
#define PSA_NWID_PREFIX		0x38	/* Domain ID; used by roaming drivers */
#define PSA_CONF_STATUS		0x3c	/* 0=not configured, 1=configured */
#define PSA_CRC			0x3d	/* CRC16 0-3c; NIC production value */
#define PSA_CRC_STATUS		0x3f	/* 0xAA=valid, 0x55=invalid or error */


/*******************************************************
* Modem Management Controler Interface registers (MMC) *
*******************************************************/

/*
 * Modem Command registers that are used to configure the WaveMODEM.
 * WRITE POSSIBILITY.
 */
/* Security registers */
#define MMC_ENCR_KEY		0x00	/* Security keys 1-8 exclude 0 bits */
#define MMC_ENCR_ENABLE		0x08	/* 0b - Enable security; 1b - mode */
#define MMC_ENCR_IO_INVERT	0x0a	/* Security I/O invert */

/* DSP registers */
#define MMC_LOOPT_SEL		0x10	/* Loopback selector */
#define	MMC_LOOPT_SEL_A			0x08	/* analog loop, pwr disabled */
#define	MMC_LOOPT_SEL_B			0x04	/* analog loop, pwr enabled */
#define	MMC_LOOPT_SEL_C			0x02	/* long digital loop */
#define	MMC_LOOPT_SEL_D			0x01	/* short digital loop */
#define	MMC_LOOPT_SEL_LP		0x10	/* disable CSMA/CA protocol */
#define	MMC_LOOPT_SEL_IGNWID		0x40	/* disable NWID detector */
#define MMC_JABBER_ENABLE	0x11	/* 0b - Enable jabber timer */
#define MMC_FREEZE		0x12	/* 0b - Collect signal lvl & quality */
#define MMC_ANTEN_SEL		0x13	/* Receiver antenna */
#define	MMC_ANTEN_SEL_AUTO		0x02	/* enable antenna autoselect */
#define	MMC_ANTEN_SEL_AUX		0x01	/* select auxiliary antenna */
#define MMC_IFS			0x14	/* Inter frame space */
#define	MMC_IFS_DEFAULT			0x20	/* recommended value */
#define MMC_MOD_DELAY		0x15	/* Modem delay to optimize T/R sync */
#define	MMC_MOD_DEFAULT			0x04	/* recommended value */
#define MMC_JAM_TIME		0x16	/* Jamming sequence for a cert. time */
#define	MMC_JAM_DEFAULT			0x38	/* recommended value */
#define MMC_THR_PRE_SET		0x18	/* Signal level threshold; max 0x3f */
#define	MMC_THR_DEFAULT			0x04	/* recommended value */
#define MMC_QUALITY_THR		0x1b	/* Quality threshold; max 0x0f */
#define	MMC_QUALITY_DEFAULT		0x03	/* recommended value */
#define MMC_NETW_ID_L		0x1c	/* Network ID low byte */
#define MMC_NETW_ID_H		0x1d	/* Network ID high byte */
#define MMC_MODE_SEL		0x1e	/* Select test mode */

/* Modem Support registers. For V.2 WaveMODEM only */
#define	MMC_EECTRL		0x20	/* Control R/W cycle MMI<->EEPROM */
#define	MMC_EECTRL_WEN_WDS		0x04	/* write enable/disable */
#define	MMC_EECTRL_WRITE		0x05	/* register write */
#define	MMC_EECTRL_PRREAD		0x06	/* protect register read */
#define	MMC_EECTRL_DWLD			0x08	/* download command bit */
#define	MMC_EECTRL_EEPRE		0x10	/* protect register enable */
#define	MMC_EEADDR		0x21	/* Select EEPROM register for R/W */
#define	MMC_EEADDR_WEN			0xC0	/* write enable */
#define	MMC_EEADDR_WDS			0x00	/* Write disable */
#define	MMC_EEDATA_L		0x22	/* EEPROM Data register low byte */
#define	MMC_EEDATA_H		0x23	/* EEPROM Data register high byte */
#define	MMC_ANALCTRL		0x24	/* Analog Control register */
#define	MMC_ANALCTRL_INTANT		0x00	/* internal antenna */
#define	MMC_ANALCTRL_EXTANT		0x04	/* external antenna */

/*
 * Modem Status that can be used to retrieve the status and diagnostic
 * information from the modem. READ ONLY.
 */
/* Security registers */
#define MMC_ENCR_AVAIL		0x09	/* Security option ID */
#define	MMC_ENCR_OPTION		0x0a	/* Security I/O invert */

/* DSP registers */
#define MMC_DCE_STATUS		0x10	/* Transmit/receive status */
#define	MMC_DCE_STATUS_RX_BUSY		0x01	/* Receiver busy flag */
#define	MMC_DCE_STATUS_LP_EN		0x02	/* Loop enabled flag */
#define	MMC_DCE_STATUS_TX_BUSY		0x04	/* Transmiter busy flag */
#define	MMC_DCE_STATUS_JAB_EXP		0x08	/* Jabber timer expired flag */
#define	MMC_DSP_ID		0x11	/* Modem DSP ID code; always 0xAA */
#define MMC_NWID_CORRECT_L	0x14	/* Correct NWID counter low byte */
#define MMC_NWID_CORRECT_H	0x15	/* Correct NWID counter high byte */
#define MMC_NWID_WRONG_L	0x16	/* Incorrect NWID counter low byte */
#define MMC_NWID_WRONG_H	0x17	/* Incorrect NWID counter high byte */
#define MMC_SIGNAL_THR		0x18	/* Signal level threshold */
#define	MMC_SIGNAL_THR_VALUE		0x3f	/* value mask */
#define	MMC_SIGNAL_THR_ABOVE		0x80	/* above threshold flag */
#define MMC_SIGNAL_LVL		0x19	/* Signal level of last receive */
#define	MMC_SIGNAL_LVL_VALUE		0x3f	/* value mask */
#define	MMC_SIGNAL_LVL_VALID		0x80	/* valid value flag */
#define MMC_SILENCE_LVL		0x1a	/* Signal level of `silence' */
#define	MMC_SILENCE_LVL_VALUE		0x3f	/* value mask */
#define	MMC_SILENCE_LVL_VALID		0x80	/* valid value flag */
#define MMC_SIGNAL_QUAL		0x1b	/* Signal quality of last receive */
#define	MMC_SIGNAL_QUAL_VALUE		0x0f	/* value mask */
#define	MMC_SIGNAL_QUAL_SELANT		0x80	/* which antenna was used */

/* EEPROM status register. For V.2 WaveMODEM only */
#define	MMC_X24STAT		0x20	/* X24 Status register */
#define	MMC_X24STAT_EEBUSY		0x04	/* EEPROM cycle Status bit */
#define	MMC_X24STAT_DLWD		0x08	/* DownLoad Status bit */
#define	MMC_X24STAT_CHIPID		0xF0	/* ChipID field */
#define	MMC_X24STAT_CHIPID_X24		0xA0	/* X24 ChipID value */
#define	MMC_X24STAT_CHIPID_ARIADNE	0xB0	/* Ariadne ChipID value */

#endif	_CHIPS_WAVELAN_H

/* additional socket ioctl params for wl card   
 * see sys/sockio.h for numbers.  The 2nd params here
 * must be greater than any values in sockio.h
 */

#define SIOCGWLNWID	_IOWR('i', 60, struct ifreq)	/* get wlan nwid */
#define SIOCSWLNWID	_IOWR('i', 61, struct ifreq)	/* set wlan nwid */

/* 
 * signal strength cache
 *
 * driver (wlp only at the moment) keeps cache of last
 * IP (only) packets to arrive including signal strength info.
 * daemons may read this with kvm.  See if_wlp.c for globals
 * that may be accessed through kvm.
 *
 * Each entry in the w_sigcache has a unique macsrc and age.
 * Each entry is identified by its macsrc field.
 * Age of the packet is identified by its age field.
 */

#define  MAXCACHEITEMS	10
#ifndef INT_MAX
#define        INT_MAX         2147483647
#endif
#define  MAX_AGE        (INT_MAX - MAXCACHEITEMS)

/* signal is 7 bits, 0..63, although it doesn't seem to get to 63.
 * silence is 7 bits, 0..63
 * quality is 4 bits, 0..15
 */
struct w_sigcache {
        char   macsrc[6]; /* unique MAC address for entry */
        int    ipsrc;     /* ip address associated with packet */
        int    signal;    /* signal strength of the packet */
        int    silence;   /* silence of the packet */
        int    quality;   /* quality of the packet */
        int    age;       /* packet has unique age between 1 to MAX_AGE - 1 */
};

