# Copyright (c) 1993 by Sanjay Ghemawat
#
# Startup script for text-based ical

# Parse arguments (some argument parsing has already been done by startup.tcl)
set showcount 1
while {[llength $argv] != 0} {
    set arg [lindex $argv 0]
    set argv [lrange $argv 1 end]

    case $arg in {
	"-show" {
	    if {[llength $argv] < 1} ical_usage
	    set count [lindex $argv 0]
	    set argv [lrange $argv 1 end]

	    if ![regexp {^\+([0-9]+)$} $count junk days] ical_usage
	    set showcount $days
	}
	"-list" {set showcount 1}
	default {ical_usage}
    }
}

############################################################################
# Get calendar

calendar cal $ical(calendar)

############################################################################
# Print listing

set lastdate ""
set sep ""
cal listing [date today] [expr [date today]+$showcount-1] i d {
    if {$d != $lastdate} {
	puts stdout "$sep[date2text $d]"
	set lastdate $d
	set sep "\n"
    }
    puts -nonewline stdout [item2text $i]
}
exit 0
