###############################################################################
#  The BYTE UNIX Benchmarks - Release 2
#          Module: fs.awk   SID: 2.1 8/6/89 22:24:32
#          
###############################################################################
# Bug reports, patches, comments, suggestions should be sent to:
#
#	Ben Smith or Rick Grehan at BYTE Magazine
#	ben@bytepb.UUCP    rick_g@bytepb.UUCP
#
###############################################################################
#  Modification Log:
#       added geometric mean 8/6/89 -ben
#
###############################################################################
BEGIN   { w_product = 0.0000; r_product = 0.0000; c_product = 0.0000; }
/real/	{ next; }
/user/	{ next; }
/sys/	{ next; }
/^$/	{ next; } 
/^[0-9][ .0-9]*$/ && NF==3 {
       if (!fail) {
	    w+=$1;
	    w2+=$1*$1;
	    if ($1) { w_product += log($1); }
	    r+=$2;
	    r2+=$2*$2;
	    if ($2) { r_product += log($2); }
	    c+=$3;
	    c2+=$3*$3;
	    if ($3) { c_product += log($3); }
	    ok++;
	    }
	fail=0; iter++; next;
	}
    { print "** Iteration ",iter+1," Failed: ",$0; fail=1;} # fails if no digits
END {
	if (fail) iter++;
	if (ok != iter) {
	    printf "For %d successful iterations from %d attempts ...\n",ok,iter
	    iter=ok
	}
	if (ok > 0) {
	    printf "                       Arithmetric        Geometric         Variance\n";
	    printf "                              Mean             Mean         (%d tests)\n",ok
	    printf "Read (Kbytes/sec):        %9.0f        %9.0f         ",r/ok,exp(r_product/ok);
	    if (ok > 1) printf "%9.2f\n",(r2-r*r/ok)/(ok-1);
	    else printf "n/a\n"
	    printf "Write (Kbytes/sec):       %9.0f        %9.0f         ",w/ok,exp(w_product/ok);
	    if (ok > 1) printf "%9.2f\n",(w2-w*w/ok)/(ok-1);
	    else printf "n/a\n"
	    printf "Copy (Kbytes/sec):        %9.0f        %9.0f         ",c/ok,exp(c_product/ok);
	    if (ok > 1) printf "%9.2f\n",(c2-c*c/ok)/(ok-1);
	    else printf "n/a\n"
	} else {
	    print "-- no measured results --"
	}
    }
