/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.io;

import java.io.IOException;
import java.io.OutputStream;

public class ByteCountingOutputStream
extends OutputStream {
    private long count;
    private OutputStream os;

    public ByteCountingOutputStream(OutputStream os) {
        this.setOutputStream(os);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
        this.count += (long)len;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.os.write(b);
        this.count += (long)b.length;
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
        ++this.count;
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    public long getByteCount() {
        return this.count;
    }

    protected void setOutputStream(OutputStream stream) {
        this.os = stream;
        this.count = 0L;
    }
}

