/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.controller;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.JFrame;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.SourcesSavable;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.view.SaveAllSourcesView;

public class SaveAllSourcesController
implements SourcesSavable.Controller,
SourcesSavable.Listener {
    protected API api;
    protected SaveAllSourcesView saveAllSourcesView;
    protected boolean cancel;
    protected int counter;
    protected int mask;

    public SaveAllSourcesController(API api, JFrame mainFrame) {
        this.api = api;
        this.saveAllSourcesView = new SaveAllSourcesView(mainFrame, this::onCanceled);
    }

    public void show(ScheduledExecutorService executor, SourcesSavable savable, File file) {
        this.saveAllSourcesView.show(file);
        executor.execute(() -> {
            block7: {
                int fileCount = savable.getFileCount();
                this.saveAllSourcesView.updateProgressBar(0);
                this.saveAllSourcesView.setMaxValue(fileCount);
                this.cancel = false;
                this.counter = 0;
                this.mask = 2;
                while (fileCount > 64) {
                    fileCount >>= 1;
                    this.mask <<= 1;
                }
                --this.mask;
                try {
                    Path path = Paths.get(file.toURI());
                    Files.deleteIfExists(path);
                    try {
                        savable.save(this.api, this, this, path);
                    }
                    catch (Exception e) {
                        assert (ExceptionUtil.printStackTrace(e));
                        this.saveAllSourcesView.showActionFailedDialog();
                        this.cancel = true;
                    }
                    if (this.cancel) {
                        Files.deleteIfExists(path);
                    }
                }
                catch (Throwable t) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(t)) break block7;
                    throw new AssertionError();
                }
            }
            this.saveAllSourcesView.hide();
        });
    }

    public boolean isActivated() {
        return this.saveAllSourcesView.isVisible();
    }

    protected void onCanceled() {
        this.cancel = true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public void pathSaved(Path path) {
        if ((this.counter++ & this.mask) == 0) {
            this.saveAllSourcesView.updateProgressBar(this.counter);
        }
    }
}

