/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.visitor;

import java.util.List;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclaration;
import org.jd.core.v1.model.javasyntax.expression.ArrayExpression;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.BooleanExpression;
import org.jd.core.v1.model.javasyntax.expression.CastExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.DoubleConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.EnumConstantReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.FloatConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.InstanceOfExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.LambdaFormalParametersExpression;
import org.jd.core.v1.model.javasyntax.expression.LambdaIdentifiersExpression;
import org.jd.core.v1.model.javasyntax.expression.LengthExpression;
import org.jd.core.v1.model.javasyntax.expression.LocalVariableReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.LongConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.NewArray;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.NewInitializedArray;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.ParenthesesExpression;
import org.jd.core.v1.model.javasyntax.expression.PostOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.PreOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperExpression;
import org.jd.core.v1.model.javasyntax.expression.TernaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.ThisExpression;
import org.jd.core.v1.model.javasyntax.expression.TypeReferenceDotClassExpression;
import org.jd.core.v1.model.javasyntax.statement.AssertStatement;
import org.jd.core.v1.model.javasyntax.statement.DoWhileStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ForEachStatement;
import org.jd.core.v1.model.javasyntax.statement.ForStatement;
import org.jd.core.v1.model.javasyntax.statement.IfElseStatement;
import org.jd.core.v1.model.javasyntax.statement.IfStatement;
import org.jd.core.v1.model.javasyntax.statement.LabelStatement;
import org.jd.core.v1.model.javasyntax.statement.LambdaExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.LocalVariableDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.SwitchStatement;
import org.jd.core.v1.model.javasyntax.statement.SynchronizedStatement;
import org.jd.core.v1.model.javasyntax.statement.ThrowStatement;
import org.jd.core.v1.model.javasyntax.statement.TryStatement;
import org.jd.core.v1.model.javasyntax.statement.TypeDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.WhileStatement;

public class SingleLineStatementVisitor
extends AbstractJavaSyntaxVisitor {
    protected int minLineNumber;
    protected int maxLineNumber;
    protected int statementCount;

    public void init() {
        this.minLineNumber = -2;
        this.maxLineNumber = -1;
        this.statementCount = 0;
    }

    public boolean isSingleLineStatement() {
        if (this.minLineNumber <= 0) {
            return this.statementCount <= 1;
        }
        return this.minLineNumber == this.maxLineNumber;
    }

    @Override
    public void visit(AssertStatement statement) {
        statement.getCondition().accept(this);
        this.safeAccept(statement.getMessage());
        this.minLineNumber = statement.getCondition().getLineNumber();
        this.statementCount = 1;
    }

    @Override
    public void visit(DoWhileStatement statement) {
        this.minLineNumber = statement.getCondition().getLineNumber();
        this.safeAccept(statement.getStatements());
        statement.getCondition().accept(this);
        this.statementCount = 2;
    }

    @Override
    public void visit(ExpressionStatement statement) {
        statement.getExpression().accept(this);
        this.minLineNumber = statement.getExpression().getLineNumber();
        this.statementCount = 1;
    }

    @Override
    public void visit(ForEachStatement statement) {
        statement.getExpression().accept(this);
        this.safeAccept(statement.getStatements());
        this.minLineNumber = statement.getExpression().getLineNumber();
        this.statementCount = 2;
    }

    @Override
    public void visit(ForStatement statement) {
        if (statement.getStatements() != null) {
            statement.getStatements().accept(this);
        } else if (statement.getUpdate() != null) {
            statement.getUpdate().accept(this);
        } else if (statement.getCondition() != null) {
            statement.getCondition().accept(this);
        } else if (statement.getInit() != null) {
            statement.getInit().accept(this);
        } else {
            this.maxLineNumber = 0;
        }
        this.minLineNumber = statement.getCondition() != null ? statement.getCondition().getLineNumber() : (statement.getCondition() != null ? statement.getCondition().getLineNumber() : this.maxLineNumber);
        this.statementCount = 2;
    }

    @Override
    public void visit(IfStatement statement) {
        statement.getCondition().accept(this);
        this.safeAccept(statement.getStatements());
        this.minLineNumber = statement.getCondition().getLineNumber();
        this.statementCount = 2;
    }

    @Override
    public void visit(IfElseStatement statement) {
        statement.getCondition().accept(this);
        statement.getElseStatements().accept(this);
        this.minLineNumber = statement.getCondition().getLineNumber();
        this.statementCount = 2;
    }

    @Override
    public void visit(LabelStatement statement) {
        this.maxLineNumber = 0;
        this.minLineNumber = 0;
        this.safeAccept(statement.getStatement());
        this.statementCount = 1;
    }

    @Override
    public void visit(LambdaExpressionStatement statement) {
        statement.getExpression().accept(this);
        this.minLineNumber = statement.getExpression().getLineNumber();
        this.statementCount = 1;
    }

    @Override
    public void visit(LocalVariableDeclarationStatement statement) {
        this.visit((LocalVariableDeclaration)statement);
        this.statementCount = 1;
    }

    @Override
    public void visit(ReturnExpressionStatement statement) {
        statement.getExpression().accept(this);
        this.minLineNumber = statement.getExpression().getLineNumber();
        this.statementCount = 1;
    }

    @Override
    public void visit(SwitchStatement statement) {
        statement.getCondition().accept(this);
        this.acceptListStatement(statement.getBlocks());
        this.minLineNumber = statement.getCondition().getLineNumber();
        this.statementCount = 2;
    }

    @Override
    public void visit(SynchronizedStatement statement) {
        statement.getMonitor().accept(this);
        this.safeAccept(statement.getStatements());
        this.minLineNumber = statement.getMonitor().getLineNumber();
        this.statementCount = 2;
    }

    @Override
    public void visit(ThrowStatement statement) {
        statement.getExpression().accept(this);
        this.minLineNumber = statement.getExpression().getLineNumber();
        this.statementCount = 1;
    }

    @Override
    public void visit(TryStatement statement) {
        statement.getTryStatements().accept(this);
        int min = this.minLineNumber;
        this.safeAcceptListStatement(statement.getCatchClauses());
        this.safeAccept(statement.getFinallyStatements());
        this.minLineNumber = min;
        this.statementCount = 2;
    }

    @Override
    public void visit(TryStatement.CatchClause statement) {
        this.safeAccept(statement.getStatements());
    }

    @Override
    public void visit(TypeDeclarationStatement statement) {
        this.maxLineNumber = 0;
        this.minLineNumber = 0;
        this.statementCount = 1;
    }

    @Override
    public void visit(WhileStatement statement) {
        statement.getCondition().accept(this);
        this.safeAccept(statement.getStatements());
        this.minLineNumber = statement.getCondition().getLineNumber();
        this.statementCount = 2;
    }

    @Override
    protected void acceptListStatement(List<? extends Statement> list) {
        int size = list.size();
        switch (size) {
            case 0: {
                this.maxLineNumber = 0;
                this.minLineNumber = 0;
                break;
            }
            case 1: {
                list.get(0).accept(this);
                break;
            }
            default: {
                list.get(0).accept(this);
                int min = this.minLineNumber;
                list.get(size - 1).accept(this);
                this.minLineNumber = min;
                this.statementCount = size;
            }
        }
    }

    @Override
    protected void safeAcceptListStatement(List<? extends Statement> list) {
        if (list == null) {
            this.maxLineNumber = 0;
            this.minLineNumber = 0;
        } else {
            this.acceptListStatement(list);
        }
    }

    @Override
    public void visit(ConstructorInvocationExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters == null) {
            this.maxLineNumber = expression.getLineNumber();
        } else {
            parameters.accept(this);
        }
    }

    @Override
    public void visit(SuperConstructorInvocationExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters == null) {
            this.maxLineNumber = expression.getLineNumber();
        } else {
            parameters.accept(this);
        }
    }

    @Override
    public void visit(MethodInvocationExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters == null) {
            this.maxLineNumber = expression.getLineNumber();
        } else {
            parameters.accept(this);
        }
    }

    @Override
    public void visit(NewArray expression) {
        BaseExpression dimensionExpressionList = expression.getDimensionExpressionList();
        if (dimensionExpressionList == null) {
            this.maxLineNumber = expression.getLineNumber();
        } else {
            dimensionExpressionList.accept(this);
        }
    }

    @Override
    public void visit(NewExpression expression) {
        BodyDeclaration bodyDeclaration = expression.getBodyDeclaration();
        if (bodyDeclaration == null) {
            BaseExpression parameters = expression.getParameters();
            if (parameters == null) {
                this.maxLineNumber = expression.getLineNumber();
            } else {
                parameters.accept(this);
            }
        } else {
            this.maxLineNumber = expression.getLineNumber() + 1;
        }
    }

    @Override
    protected void acceptListExpression(List<? extends Expression> list) {
        int size = list.size();
        if (size == 0) {
            this.maxLineNumber = 0;
        } else {
            list.get(size - 1).accept(this);
        }
    }

    @Override
    public void visit(ArrayExpression expression) {
        expression.getIndex().accept(this);
    }

    @Override
    public void visit(BinaryOperatorExpression expression) {
        expression.getRightExpression().accept(this);
    }

    @Override
    public void visit(CastExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(LambdaFormalParametersExpression expression) {
        expression.getStatements().accept(this);
    }

    @Override
    public void visit(LambdaIdentifiersExpression expression) {
        this.safeAccept(expression.getStatements());
    }

    @Override
    public void visit(NewInitializedArray expression) {
        expression.getArrayInitializer().accept(this);
    }

    @Override
    public void visit(ParenthesesExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(PostOperatorExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(PreOperatorExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(TernaryOperatorExpression expression) {
        expression.getExpressionFalse().accept(this);
    }

    @Override
    public void visit(BooleanExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(ConstructorReferenceExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(DoubleConstantExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(EnumConstantReferenceExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(FloatConstantExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(IntegerConstantExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(FieldReferenceExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(InstanceOfExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(LengthExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(LocalVariableReferenceExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(LongConstantExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(MethodReferenceExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(NullExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(ObjectTypeReferenceExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(StringConstantExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(SuperExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(ThisExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }

    @Override
    public void visit(TypeReferenceDotClassExpression expression) {
        this.maxLineNumber = expression.getLineNumber();
    }
}

