/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import org.jd.core.v1.model.classfile.attribute.Annotation;
import org.jd.core.v1.model.classfile.attribute.Annotations;
import org.jd.core.v1.model.classfile.attribute.ElementValueAnnotationValue;
import org.jd.core.v1.model.classfile.attribute.ElementValueArrayValue;
import org.jd.core.v1.model.classfile.attribute.ElementValueClassInfo;
import org.jd.core.v1.model.classfile.attribute.ElementValueEnumConstValue;
import org.jd.core.v1.model.classfile.attribute.ElementValuePair;
import org.jd.core.v1.model.classfile.attribute.ElementValuePrimitiveType;
import org.jd.core.v1.model.classfile.attribute.ElementValueVisitor;
import org.jd.core.v1.model.classfile.constant.ConstantDouble;
import org.jd.core.v1.model.classfile.constant.ConstantFloat;
import org.jd.core.v1.model.classfile.constant.ConstantInteger;
import org.jd.core.v1.model.classfile.constant.ConstantLong;
import org.jd.core.v1.model.classfile.constant.ConstantUtf8;
import org.jd.core.v1.model.javasyntax.expression.DoubleConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.FloatConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.LongConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.TypeReferenceDotClassExpression;
import org.jd.core.v1.model.javasyntax.reference.AnnotationElementValue;
import org.jd.core.v1.model.javasyntax.reference.AnnotationReference;
import org.jd.core.v1.model.javasyntax.reference.AnnotationReferences;
import org.jd.core.v1.model.javasyntax.reference.BaseAnnotationReference;
import org.jd.core.v1.model.javasyntax.reference.ElementValue;
import org.jd.core.v1.model.javasyntax.reference.ElementValueArrayInitializerElementValue;
import org.jd.core.v1.model.javasyntax.reference.ElementValuePairs;
import org.jd.core.v1.model.javasyntax.reference.ElementValues;
import org.jd.core.v1.model.javasyntax.reference.ExpressionElementValue;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;

public class AnnotationConverter
implements ElementValueVisitor {
    protected TypeMaker typeMaker;
    protected ElementValue elementValue = null;

    public AnnotationConverter(TypeMaker typeMaker) {
        this.typeMaker = typeMaker;
    }

    public BaseAnnotationReference convert(Annotations visibles, Annotations invisibles) {
        if (visibles == null) {
            if (invisibles == null) {
                return null;
            }
            return this.convert(invisibles);
        }
        if (invisibles == null) {
            return this.convert(visibles);
        }
        AnnotationReferences aral = new AnnotationReferences();
        for (Annotation a : visibles.getAnnotations()) {
            aral.add(this.convert(a));
        }
        for (Annotation a : invisibles.getAnnotations()) {
            aral.add(this.convert(a));
        }
        return aral;
    }

    protected BaseAnnotationReference convert(Annotations annotations) {
        Annotation[] as = annotations.getAnnotations();
        if (as.length == 1) {
            return this.convert(as[0]);
        }
        AnnotationReferences aral = new AnnotationReferences(as.length);
        for (Annotation a : as) {
            aral.add(this.convert(a));
        }
        return aral;
    }

    protected AnnotationReference convert(Annotation annotation) {
        String descriptor = annotation.getDescriptor();
        assert (descriptor != null && descriptor.length() > 2 && descriptor.charAt(0) == 'L' && descriptor.charAt(descriptor.length() - 1) == ';');
        ObjectType ot = this.typeMaker.makeFromDescriptor(descriptor);
        ElementValuePair[] elementValuePairs = annotation.getElementValuePairs();
        if (elementValuePairs == null) {
            return new AnnotationReference(ot);
        }
        if (elementValuePairs.length == 1) {
            ElementValuePair elementValuePair = elementValuePairs[0];
            String elementName = elementValuePair.getElementName();
            Object elementValue = elementValuePair.getElementValue();
            if ("value".equals(elementName)) {
                return new AnnotationReference(ot, this.convert((org.jd.core.v1.model.classfile.attribute.ElementValue)elementValue));
            }
            return new AnnotationReference(ot, new org.jd.core.v1.model.javasyntax.reference.ElementValuePair(elementName, this.convert((org.jd.core.v1.model.classfile.attribute.ElementValue)elementValue)));
        }
        ElementValuePairs list = new ElementValuePairs(elementValuePairs.length);
        for (ElementValuePair elementValuePair : elementValuePairs) {
            String elementName = elementValuePair.getElementName();
            Object elementValue = elementValuePair.getElementValue();
            list.add(new org.jd.core.v1.model.javasyntax.reference.ElementValuePair(elementName, this.convert((org.jd.core.v1.model.classfile.attribute.ElementValue)elementValue)));
        }
        return new AnnotationReference(ot, list);
    }

    public ElementValue convert(org.jd.core.v1.model.classfile.attribute.ElementValue ev) {
        ev.accept(this);
        return this.elementValue;
    }

    @Override
    public void visit(ElementValuePrimitiveType elementValuePrimitiveType) {
        switch (elementValuePrimitiveType.getType()) {
            case 66: {
                this.elementValue = new ExpressionElementValue(new IntegerConstantExpression(PrimitiveType.TYPE_BYTE, ((ConstantInteger)elementValuePrimitiveType.getConstValue()).getValue()));
                break;
            }
            case 68: {
                this.elementValue = new ExpressionElementValue(new DoubleConstantExpression(((ConstantDouble)elementValuePrimitiveType.getConstValue()).getValue()));
                break;
            }
            case 70: {
                this.elementValue = new ExpressionElementValue(new FloatConstantExpression(((ConstantFloat)elementValuePrimitiveType.getConstValue()).getValue()));
                break;
            }
            case 73: {
                this.elementValue = new ExpressionElementValue(new IntegerConstantExpression(PrimitiveType.TYPE_INT, ((ConstantInteger)elementValuePrimitiveType.getConstValue()).getValue()));
                break;
            }
            case 74: {
                this.elementValue = new ExpressionElementValue(new LongConstantExpression(((ConstantLong)elementValuePrimitiveType.getConstValue()).getValue()));
                break;
            }
            case 83: {
                this.elementValue = new ExpressionElementValue(new IntegerConstantExpression(PrimitiveType.TYPE_SHORT, ((ConstantInteger)elementValuePrimitiveType.getConstValue()).getValue()));
                break;
            }
            case 90: {
                this.elementValue = new ExpressionElementValue(new IntegerConstantExpression(PrimitiveType.TYPE_BOOLEAN, ((ConstantInteger)elementValuePrimitiveType.getConstValue()).getValue()));
                break;
            }
            case 67: {
                this.elementValue = new ExpressionElementValue(new IntegerConstantExpression(PrimitiveType.TYPE_CHAR, ((ConstantInteger)elementValuePrimitiveType.getConstValue()).getValue()));
                break;
            }
            case 115: {
                this.elementValue = new ExpressionElementValue(new StringConstantExpression(((ConstantUtf8)elementValuePrimitiveType.getConstValue()).getValue()));
            }
        }
    }

    @Override
    public void visit(ElementValueClassInfo elementValueClassInfo) {
        String classInfo = elementValueClassInfo.getClassInfo();
        ObjectType ot = this.typeMaker.makeFromDescriptor(classInfo);
        this.elementValue = new ExpressionElementValue(new TypeReferenceDotClassExpression(ot));
    }

    @Override
    public void visit(ElementValueAnnotationValue elementValueAnnotationValue) {
        Annotation annotationValue = elementValueAnnotationValue.getAnnotationValue();
        AnnotationReference annotationReference = this.convert(annotationValue);
        this.elementValue = new AnnotationElementValue(annotationReference);
    }

    @Override
    public void visit(ElementValueEnumConstValue elementValueEnumConstValue) {
        String descriptor = elementValueEnumConstValue.getDescriptor();
        assert (descriptor != null && descriptor.length() > 2 && descriptor.charAt(0) == 'L' && descriptor.charAt(descriptor.length() - 1) == ';') : "AnnotationConverter.visit(elementValueEnumConstValue)";
        ObjectType ot = this.typeMaker.makeFromDescriptor(descriptor);
        String constName = elementValueEnumConstValue.getConstName();
        String internalTypeName = descriptor.substring(1, descriptor.length() - 1);
        this.elementValue = new ExpressionElementValue(new FieldReferenceExpression(ot, new ObjectTypeReferenceExpression(ot), internalTypeName, constName, descriptor));
    }

    @Override
    public void visit(ElementValueArrayValue elementValueArrayValue) {
        org.jd.core.v1.model.classfile.attribute.ElementValue[] values = elementValueArrayValue.getValues();
        if (values == null) {
            this.elementValue = new ElementValueArrayInitializerElementValue();
        } else if (values.length == 1) {
            values[0].accept(this);
            this.elementValue = new ElementValueArrayInitializerElementValue(this.elementValue);
        } else {
            ElementValues list = new ElementValues(values.length);
            for (org.jd.core.v1.model.classfile.attribute.ElementValue value : values) {
                value.accept(this);
                list.add(this.elementValue);
            }
            this.elementValue = new ElementValueArrayInitializerElementValue(list);
        }
    }
}

