/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.openid.token;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.openid.conf.ConfigurationService;
import org.apache.guacamole.auth.sso.NonceService;
import org.apache.guacamole.token.TokenName;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenValidationService {
    private final Logger logger = LoggerFactory.getLogger(TokenValidationService.class);
    public static final String OIDC_ATTRIBUTE_TOKEN_PREFIX = "OIDC_";
    @Inject
    private ConfigurationService confService;
    @Inject
    private NonceService nonceService;

    public JwtClaims validateToken(String token) throws GuacamoleException {
        HttpsJwks jwks = new HttpsJwks(this.confService.getJWKSEndpoint().toString());
        HttpsJwksVerificationKeyResolver resolver = new HttpsJwksVerificationKeyResolver(jwks);
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setMaxFutureValidityInMinutes(this.confService.getMaxTokenValidity()).setAllowedClockSkewInSeconds(this.confService.getAllowedClockSkew()).setRequireSubject().setExpectedIssuer(this.confService.getIssuer()).setExpectedAudience(new String[]{this.confService.getClientID()}).setVerificationKeyResolver((VerificationKeyResolver)resolver).build();
        try {
            JwtClaims claims = jwtConsumer.processToClaims(token);
            String nonce = claims.getStringClaimValue("nonce");
            if (nonce != null) {
                if (this.nonceService.isValid(nonce)) {
                    return claims;
                }
                this.logger.info("Rejected OpenID token with invalid/old nonce.");
            } else {
                this.logger.info("Rejected OpenID token without nonce.");
            }
        }
        catch (MalformedClaimException e) {
            this.logger.info("Rejected OpenID token with malformed claim: {}", (Object)e.getMessage());
            this.logger.debug("Malformed claim within received JWT.", (Throwable)e);
        }
        catch (InvalidJwtException e) {
            this.logger.info("Rejected invalid OpenID token: {}", (Object)e.getMessage());
            this.logger.debug("Invalid JWT received.", (Throwable)e);
        }
        return null;
    }

    public String processUsername(JwtClaims claims) throws GuacamoleException {
        String usernameClaim = this.confService.getUsernameClaimType();
        if (claims != null) {
            try {
                String username = claims.getStringClaimValue(usernameClaim);
                if (username != null) {
                    return username;
                }
            }
            catch (MalformedClaimException e) {
                this.logger.info("Rejected OpenID token with malformed claim: {}", (Object)e.getMessage());
                this.logger.debug("Malformed claim within received JWT.", (Throwable)e);
            }
            this.logger.warn("Username claim \"{}\" missing from token. Perhaps the OpenID scope and/or username claim type are misconfigured?", (Object)usernameClaim);
        }
        return null;
    }

    public Set<String> processGroups(JwtClaims claims) throws GuacamoleException {
        String groupsClaim = this.confService.getGroupsClaimType();
        if (claims != null) {
            try {
                List oidcGroups = claims.getStringListClaimValue(groupsClaim);
                if (oidcGroups != null && !oidcGroups.isEmpty()) {
                    return Collections.unmodifiableSet(new HashSet(oidcGroups));
                }
            }
            catch (MalformedClaimException e) {
                this.logger.info("Rejected OpenID token with malformed claim: {}", (Object)e.getMessage());
                this.logger.debug("Malformed claim within received JWT.", (Throwable)e);
            }
        }
        return Collections.emptySet();
    }

    public Map<String, String> processAttributes(JwtClaims claims) throws GuacamoleException {
        Collection<String> attributesClaim = this.confService.getAttributesClaimType();
        if (claims != null && !attributesClaim.isEmpty()) {
            try {
                this.logger.debug("Iterating over attributes claim list : {}", attributesClaim);
                HashMap<String, String> tokens = new HashMap<String, String>(attributesClaim.size());
                for (String key : attributesClaim) {
                    String oidcAttr = claims.getStringClaimValue(key);
                    if (oidcAttr != null && !oidcAttr.isEmpty()) {
                        String tokenName = TokenName.canonicalize((String)key, (String)OIDC_ATTRIBUTE_TOKEN_PREFIX);
                        tokens.put(tokenName, oidcAttr);
                        this.logger.debug("Claim {} found and set to {}", (Object)key, (Object)tokenName);
                        continue;
                    }
                    this.logger.debug("Claim {} not found in JWT.", (Object)key);
                }
                return Collections.unmodifiableMap(tokens);
            }
            catch (MalformedClaimException e) {
                this.logger.info("Rejected OpenID token with malformed claim: {}", (Object)e.getMessage());
                this.logger.debug("Malformed claim within received JWT.", (Throwable)e);
            }
        }
        this.logger.debug("Attributes claim not defined. Returning empty map.");
        return Collections.emptyMap();
    }
}

