/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.membership;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPDn;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.storage.ldap.mappers.membership.CommonLDAPGroupMapper;
import org.keycloak.storage.ldap.mappers.membership.MembershipType;
import org.keycloak.utils.StreamsUtil;

public interface UserRolesRetrieveStrategy {
    public List<LDAPObject> getLDAPRoleMappings(CommonLDAPGroupMapper var1, LDAPObject var2, LDAPConfig var3);

    public List<UserModel> getLDAPRoleMembers(RealmModel var1, CommonLDAPGroupMapper var2, LDAPObject var3, int var4, int var5);

    public void beforeUserLDAPQuery(CommonLDAPGroupMapper var1, LDAPQuery var2);

    public static class LoadRolesByMemberRecursively
    extends LoadRolesByMember {
        @Override
        protected Condition getMembershipCondition(String membershipAttr, String userMembership) {
            return new LDAPQueryConditionsBuilder().equal(membershipAttr + ":1.2.840.113556.1.4.1941:", userMembership);
        }
    }

    public static class GetRolesFromUserMemberOfAttribute
    implements UserRolesRetrieveStrategy {
        @Override
        public List<LDAPObject> getLDAPRoleMappings(CommonLDAPGroupMapper roleOrGroupMapper, LDAPObject ldapUser, LDAPConfig ldapConfig) {
            Set<String> memberOfValues = ldapUser.getAttributeAsSet(roleOrGroupMapper.getConfig().getMemberOfLdapAttribute());
            if (memberOfValues == null || memberOfValues.isEmpty()) {
                return Collections.emptyList();
            }
            try (LDAPQuery ldapQuery = roleOrGroupMapper.createLDAPGroupQuery();){
                String rdnAttr = roleOrGroupMapper.getConfig().getLDAPGroupNameLdapAttribute();
                LDAPQueryConditionsBuilder conditionBuilder = new LDAPQueryConditionsBuilder();
                Condition[] conditions = (Condition[])memberOfValues.stream().map(LDAPDn::fromString).filter(roleDN -> roleDN.isDescendantOf(LDAPDn.fromString(roleOrGroupMapper.getConfig().getLDAPGroupsDn()))).map(roleDN -> conditionBuilder.equal(rdnAttr, roleDN.getFirstRdn().getAttrValue(rdnAttr))).toArray(Condition[]::new);
                if (conditions.length > 0) {
                    ldapQuery.addWhereCondition(conditionBuilder.orCondition(conditions));
                }
                List<LDAPObject> list = LDAPUtils.loadAllLDAPObjects(ldapQuery, ldapConfig);
                return list;
            }
        }

        @Override
        public List<UserModel> getLDAPRoleMembers(RealmModel realm, CommonLDAPGroupMapper roleOrGroupMapper, LDAPObject ldapRoleOrGroup, int firstResult, int maxResults) {
            String memberOfLdapAttrName = roleOrGroupMapper.getConfig().getMemberOfLdapAttribute();
            String roleOrGroupDn = ldapRoleOrGroup.getDn().toString();
            return StreamsUtil.paginatedStream(roleOrGroupMapper.getLdapProvider().searchForUserByUserAttributeStream(realm, memberOfLdapAttrName, roleOrGroupDn), (Integer)firstResult, (Integer)maxResults).toList();
        }

        @Override
        public void beforeUserLDAPQuery(CommonLDAPGroupMapper roleOrGroupMapper, LDAPQuery query) {
            String memberOfLdapAttrName = roleOrGroupMapper.getConfig().getMemberOfLdapAttribute();
            query.addReturningLdapAttribute(memberOfLdapAttrName);
            query.addReturningReadOnlyLdapAttribute(memberOfLdapAttrName);
        }
    }

    public static class LoadRolesByMember
    implements UserRolesRetrieveStrategy {
        @Override
        public List<LDAPObject> getLDAPRoleMappings(CommonLDAPGroupMapper roleOrGroupMapper, LDAPObject ldapUser, LDAPConfig ldapConfig) {
            try (LDAPQuery ldapQuery = roleOrGroupMapper.createLDAPGroupQuery();){
                String membershipAttr = roleOrGroupMapper.getConfig().getMembershipLdapAttribute();
                String membershipUserAttrName = roleOrGroupMapper.getConfig().getMembershipUserLdapAttribute(ldapConfig);
                String userMembership = LDAPUtils.getMemberValueOfChildObject(ldapUser, roleOrGroupMapper.getConfig().getMembershipTypeLdapAttribute(), membershipUserAttrName);
                Condition membershipCondition = this.getMembershipCondition(membershipAttr, userMembership);
                ldapQuery.addWhereCondition(membershipCondition);
                List<LDAPObject> list = LDAPUtils.loadAllLDAPObjects(ldapQuery, ldapConfig);
                return list;
            }
        }

        @Override
        public List<UserModel> getLDAPRoleMembers(RealmModel realm, CommonLDAPGroupMapper roleOrGroupMapper, LDAPObject ldapRoleOrGroup, int firstResult, int maxResults) {
            MembershipType membershipType = roleOrGroupMapper.getConfig().getMembershipTypeLdapAttribute();
            return membershipType.getGroupMembers(realm, roleOrGroupMapper, ldapRoleOrGroup, firstResult, maxResults);
        }

        @Override
        public void beforeUserLDAPQuery(CommonLDAPGroupMapper roleOrGroupMapper, LDAPQuery query) {
        }

        protected Condition getMembershipCondition(String membershipAttr, String userMembership) {
            return new LDAPQueryConditionsBuilder().equal(membershipAttr, userMembership);
        }
    }
}

