/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ECPointFormatExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECPointFormatExtensionSerializer
extends ExtensionSerializer<ECPointFormatExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ECPointFormatExtensionMessage msg;

    public ECPointFormatExtensionSerializer(ECPointFormatExtensionMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        LOGGER.debug("Serializing ECPointFormatExtensionMessage");
        this.writePointFormatsLength(this.msg);
        this.writePointFormats(this.msg);
        return this.getAlreadySerialized();
    }

    private void writePointFormatsLength(ECPointFormatExtensionMessage msg) {
        this.appendInt((Integer)msg.getPointFormatsLength().getValue(), 1);
        LOGGER.debug("PointFormatsLength: " + msg.getPointFormatsLength().getValue());
    }

    private void writePointFormats(ECPointFormatExtensionMessage msg) {
        this.appendBytes((byte[])msg.getPointFormats().getValue());
        LOGGER.debug("PointFormats: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPointFormats().getValue())));
    }
}

