/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.protocol.message.extension.PWDClearExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PWDClearExtensionParser
extends ExtensionParser<PWDClearExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PWDClearExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(PWDClearExtensionMessage msg) {
        LOGGER.debug("Parsing PWDClearExtensionMessage");
        this.parseUsernameLength(msg);
        this.parseUsername(msg);
    }

    @Override
    protected PWDClearExtensionMessage createExtensionMessage() {
        return new PWDClearExtensionMessage();
    }

    private void parseUsernameLength(PWDClearExtensionMessage msg) {
        msg.setUsernameLength(this.parseIntField(1));
        LOGGER.debug("UsernameLength: " + msg.getUsernameLength().getValue());
    }

    private void parseUsername(PWDClearExtensionMessage msg) {
        msg.setUsername(new String(this.parseByteArrayField((Integer)msg.getUsernameLength().getValue())));
        LOGGER.debug("Username: " + (String)msg.getUsername().getValue());
    }
}

