/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.UriInfo;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.concurrent.ExecutorService;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.executors.ExecutorsProvider;
import org.keycloak.http.FormPartValue;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.storage.ReadOnlyException;

public class DefaultBruteForceProtector
implements BruteForceProtector {
    private static final Logger logger = Logger.getLogger(DefaultBruteForceProtector.class);
    protected int maxDeltaTimeSeconds = 43200;
    protected KeycloakSessionFactory factory;

    public DefaultBruteForceProtector(KeycloakSessionFactory factory) {
        this.factory = factory;
    }

    protected void failure(KeycloakSession session, RealmModel realm, String userId, String remoteAddr, long failureTime) {
        logger.debug((Object)"failure");
        UserLoginFailureModel userLoginFailure = this.getUserFailureModel(session, realm, userId);
        if (userLoginFailure == null) {
            userLoginFailure = session.loginFailures().addUserLoginFailure(realm, userId);
        }
        userLoginFailure.setLastIPFailure(remoteAddr);
        long last = userLoginFailure.getLastFailure();
        long deltaTime = 0L;
        if (last > 0L) {
            deltaTime = failureTime - last;
        }
        userLoginFailure.setLastFailure(failureTime);
        if (!(realm.isPermanentLockout() && realm.getMaxTemporaryLockouts() == 0 || deltaTime <= 0L || deltaTime <= (long)realm.getMaxDeltaTimeSeconds() * 1000L)) {
            userLoginFailure.clearFailures();
        }
        userLoginFailure.incrementFailures();
        logger.debugv("new num failures: {0}", (Object)userLoginFailure.getNumFailures());
        int waitSeconds = 0;
        if (!realm.isPermanentLockout() || realm.getMaxTemporaryLockouts() != 0) {
            waitSeconds = RealmRepresentation.BruteForceStrategy.MULTIPLE.equals((Object)realm.getBruteForceStrategy()) ? realm.getWaitIncrementSeconds() * (userLoginFailure.getNumFailures() / realm.getFailureFactor()) : realm.getWaitIncrementSeconds() * (1 + userLoginFailure.getNumFailures() - realm.getFailureFactor());
        }
        logger.debugv("waitSeconds: {0}", (Object)waitSeconds);
        logger.debugv("deltaTime: {0}", (Object)deltaTime);
        boolean quickLoginFailure = false;
        if (waitSeconds <= 0 && last > 0L && deltaTime < realm.getQuickLoginCheckMilliSeconds()) {
            logger.debugv("quick login, set min wait seconds", new Object[0]);
            waitSeconds = realm.getMinimumQuickLoginWaitSeconds();
            quickLoginFailure = true;
        }
        if (waitSeconds > 0) {
            if (!realm.isPermanentLockout() || realm.getMaxTemporaryLockouts() > 0) {
                waitSeconds = Math.min(realm.getMaxFailureWaitSeconds(), waitSeconds);
            }
            if (!quickLoginFailure) {
                userLoginFailure.incrementTemporaryLockouts();
            }
            if (quickLoginFailure || !realm.isPermanentLockout() || userLoginFailure.getNumTemporaryLockouts() <= realm.getMaxTemporaryLockouts()) {
                int notBefore = (int)(failureTime / 1000L) + waitSeconds;
                logger.debugv("set notBefore: {0}", (Object)notBefore);
                userLoginFailure.setFailedLoginNotBefore(notBefore);
                this.sendEvent(session, realm, userLoginFailure, EventType.USER_DISABLED_BY_TEMPORARY_LOCKOUT);
            }
        }
        if (!realm.isPermanentLockout()) {
            return;
        }
        if (userLoginFailure.getNumTemporaryLockouts() > realm.getMaxTemporaryLockouts() || realm.getMaxTemporaryLockouts() == 0 && userLoginFailure.getNumFailures() >= realm.getFailureFactor()) {
            UserModel user = session.users().getUserById(realm, userId);
            if (user == null) {
                return;
            }
            logger.debugv("user {0} locked permanently due to too many login attempts", (Object)user.getUsername());
            user.setEnabled(false);
            try {
                user.setSingleAttribute("disabledReason", "permanentLockout");
            }
            catch (ReadOnlyException e) {
                logger.debug((Object)"Cannot set disabled reason on read only user");
            }
            this.sendEvent(session, realm, userLoginFailure, EventType.USER_DISABLED_BY_PERMANENT_LOCKOUT);
        }
    }

    protected UserLoginFailureModel getUserFailureModel(KeycloakSession session, RealmModel realm, String userId) {
        if (realm == null) {
            return null;
        }
        return session.loginFailures().getUserLoginFailure(realm, userId);
    }

    protected void sendEvent(KeycloakSession session, RealmModel realm, UserLoginFailureModel userLoginFailure, EventType type) {
        EventBuilder builder = new EventBuilder(realm, session).ipAddress(userLoginFailure.getLastIPFailure()).event(type).detail("reason", "brute_force_attack detected").detail("num_failures", String.valueOf(userLoginFailure.getNumFailures())).user(userLoginFailure.getUserId());
        if (type == EventType.USER_DISABLED_BY_TEMPORARY_LOCKOUT) {
            long secondsSinceEpoch = userLoginFailure.getFailedLoginNotBefore();
            Instant instant = Instant.ofEpochSecond(secondsSinceEpoch);
            LocalDateTime timestamp = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            builder.detail("not_before", timestamp.toString());
        }
        builder.success();
    }

    public void shutdown() {
    }

    protected void success(KeycloakSession session, RealmModel realm, String userId) {
        UserLoginFailureModel userLoginFailure = this.getUserFailureModel(session, realm, userId);
        if (userLoginFailure == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            UserModel model = session.users().getUserById(realm, userId);
            logger.debugv("user {0} successfully logged in, clearing all failures", (Object)model.getUsername());
        }
        userLoginFailure.clearFailures();
    }

    public void failedLogin(RealmModel realm, UserModel user, ClientConnection clientConnection, UriInfo uriInfo) {
        this.processLogin(realm, user, clientConnection, uriInfo, false);
        logger.trace((Object)"sent failure event");
    }

    public void successfulLogin(RealmModel realm, UserModel user, ClientConnection clientConnection, UriInfo uriInfo) {
        this.processLogin(realm, user, clientConnection, uriInfo, true);
        logger.trace((Object)"sent success event");
    }

    protected void processLogin(RealmModel realm, UserModel user, ClientConnection clientConnection, UriInfo uriInfo, boolean success) {
        ExecutorService executor = (ExecutorService)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)this.factory, session -> {
            ExecutorsProvider provider = (ExecutorsProvider)session.getProvider(ExecutorsProvider.class);
            return provider.getExecutor("bruteforce");
        });
        BruteForceHttpRequest bruteForceHttpRequest = new BruteForceHttpRequest(uriInfo);
        BruteForceHttpResponse bruteForceHttpResponse = new BruteForceHttpResponse();
        executor.execute(() -> KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.factory, s -> {
            s.getContext().setRealm(s.realms().getRealm(realm.getId()));
            s.getContext().setHttpRequest(bruteForceHttpRequest);
            s.getContext().setHttpResponse(bruteForceHttpResponse);
            if (success) {
                this.success(s, realm, user.getId());
            } else {
                this.failure(s, realm, user.getId(), clientConnection.getRemoteAddr(), Time.currentTimeMillis());
            }
        }));
    }

    public boolean isTemporarilyDisabled(KeycloakSession session, RealmModel realm, UserModel user) {
        int failedLoginNotBefore;
        int currTime;
        UserLoginFailureModel userLoginFailure = this.getUserFailureModel(session, realm, user.getId());
        if (userLoginFailure != null && (currTime = (int)(Time.currentTimeMillis() / 1000L)) < (failedLoginNotBefore = userLoginFailure.getFailedLoginNotBefore())) {
            logger.debugv("Current: {0} notBefore: {1}", (Object)currTime, (Object)failedLoginNotBefore);
            return true;
        }
        return false;
    }

    public boolean isPermanentlyLockedOut(KeycloakSession session, RealmModel realm, UserModel user) {
        if (!user.isEnabled() && "permanentLockout".equals(user.getFirstAttribute("disabledReason"))) {
            return true;
        }
        if (!realm.isPermanentLockout()) {
            return false;
        }
        UserLoginFailureModel userLoginFailure = this.getUserFailureModel(session, realm, user.getId());
        return userLoginFailure != null && userLoginFailure.getNumTemporaryLockouts() > realm.getMaxTemporaryLockouts();
    }

    public void cleanUpPermanentLockout(KeycloakSession session, RealmModel realm, UserModel user) {
        if ("permanentLockout".equals(user.getFirstAttribute("disabledReason"))) {
            user.removeAttribute("disabledReason");
        }
    }

    public void close() {
    }

    private static class BruteForceHttpRequest
    implements HttpRequest {
        private final UriInfo uriInfo;

        BruteForceHttpRequest(UriInfo uriInfo) {
            this.uriInfo = uriInfo;
        }

        public String getHttpMethod() {
            return "";
        }

        public MultivaluedMap<String, String> getDecodedFormParameters() {
            return new MultivaluedHashMap();
        }

        public MultivaluedMap<String, FormPartValue> getMultiPartFormParameters() {
            return new MultivaluedHashMap();
        }

        public HttpHeaders getHttpHeaders() {
            return null;
        }

        public X509Certificate[] getClientCertificateChain() {
            return null;
        }

        public UriInfo getUri() {
            return this.uriInfo;
        }
    }

    private static class BruteForceHttpResponse
    implements HttpResponse {
        private BruteForceHttpResponse() {
        }

        public int getStatus() {
            return -1;
        }

        public void setStatus(int statusCode) {
        }

        public void addHeader(String name, String value) {
        }

        public void setHeader(String name, String value) {
        }

        public void setCookieIfAbsent(NewCookie cookie) {
        }
    }
}

