/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.SrpClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrpClientKeyExchangePreparator
extends ClientKeyExchangePreparator<SrpClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private BigInteger clientPublicKey;
    private byte[] premasterSecret;
    private byte[] random;
    private final SrpClientKeyExchangeMessage msg;

    public SrpClientKeyExchangePreparator(Chooser chooser, SrpClientKeyExchangeMessage msg) {
        super(chooser, msg);
        this.msg = msg;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing SRPClientExchangeMessage");
        this.msg.prepareComputations();
        this.setComputationGenerator(this.msg);
        this.setComputationModulus(this.msg);
        this.setComputationPrivateKey(this.msg);
        this.setComputationServerPublicKey(this.msg);
        this.setComputationSalt(this.msg);
        this.setSRPIdentity(this.msg);
        this.setSRPPassword(this.msg);
        this.clientPublicKey = this.calculatePublicKey((BigInteger)this.msg.getComputations().getGenerator().getValue(), (BigInteger)this.msg.getComputations().getModulus().getValue(), (BigInteger)this.msg.getComputations().getPrivateKey().getValue());
        this.prepareModulus(this.msg);
        this.prepareModulusLength(this.msg);
        this.prepareGenerator(this.msg);
        this.prepareGeneratorLength(this.msg);
        this.prepareSalt(this.msg);
        this.prepareSaltLength(this.msg);
        this.preparePublicKey(this.msg);
        this.preparePublicKeyLength(this.msg);
        this.premasterSecret = this.calculateClientPremasterSecret((BigInteger)this.msg.getComputations().getModulus().getValue(), (BigInteger)this.msg.getComputations().getGenerator().getValue(), (BigInteger)this.msg.getComputations().getPrivateKey().getValue(), (BigInteger)this.msg.getComputations().getServerPublicKey().getValue(), this.clientPublicKey, (byte[])this.msg.getComputations().getSalt().getValue(), (byte[])this.msg.getComputations().getSRPIdentity().getValue(), (byte[])this.msg.getComputations().getSRPPassword().getValue());
        this.preparePremasterSecret(this.msg);
        this.prepareClientServerRandom(this.msg);
    }

    private BigInteger calculatePublicKey(BigInteger generator, BigInteger modulus, BigInteger privateKey) {
        return generator.modPow(privateKey, modulus);
    }

    private byte[] calculateClientPremasterSecret(BigInteger modulus, BigInteger generator, BigInteger privateKey, BigInteger serverPublicKey, BigInteger clientPublicKey, byte[] salt, byte[] identity, byte[] password) {
        BigInteger u = this.calculateU(clientPublicKey, serverPublicKey, modulus);
        LOGGER.debug("Intermediate Value U" + ArrayConverter.bytesToHexString((byte[])ArrayConverter.bigIntegerToByteArray((BigInteger)u)));
        BigInteger k = this.calculateSRP6Multiplier(modulus, generator);
        BigInteger x = this.calculateX(salt, identity, password);
        LOGGER.debug("Intermediate Value X" + ArrayConverter.bytesToHexString((byte[])ArrayConverter.bigIntegerToByteArray((BigInteger)x)));
        BigInteger helpValue1 = generator.modPow(x, modulus);
        LOGGER.debug("Intermediate Value V" + ArrayConverter.bytesToHexString((byte[])ArrayConverter.bigIntegerToByteArray((BigInteger)helpValue1)));
        BigInteger helpValue2 = k.multiply(helpValue1);
        BigInteger helpValue3 = helpValue2.mod(modulus);
        helpValue1 = serverPublicKey.subtract(helpValue3);
        helpValue2 = helpValue1.mod(modulus);
        helpValue3 = u.multiply(x);
        helpValue1 = helpValue3.mod(modulus);
        helpValue3 = privateKey.add(helpValue1);
        helpValue1 = helpValue3.mod(modulus);
        helpValue3 = helpValue2.modPow(helpValue1, modulus);
        return ArrayConverter.bigIntegerToByteArray((BigInteger)helpValue3);
    }

    private byte[] calculatePremasterSecretServer(BigInteger modulus, BigInteger generator, BigInteger serverPrivateKey, BigInteger serverPublicKey, BigInteger clientPublicKey, byte[] salt, byte[] identity, byte[] password) {
        BigInteger u = this.calculateU(clientPublicKey, serverPublicKey, modulus);
        LOGGER.debug("Intermediate Value U" + ArrayConverter.bytesToHexString((byte[])ArrayConverter.bigIntegerToByteArray((BigInteger)u)));
        BigInteger x = this.calculateX(salt, identity, password);
        LOGGER.debug("Intermediate Value X" + ArrayConverter.bytesToHexString((byte[])ArrayConverter.bigIntegerToByteArray((BigInteger)x)));
        BigInteger v = this.calculateV(x, generator, modulus);
        LOGGER.debug("Intermediate Value V" + ArrayConverter.bytesToHexString((byte[])ArrayConverter.bigIntegerToByteArray((BigInteger)v)));
        BigInteger helpValue1 = v.modPow(u, modulus);
        LOGGER.debug("v^u" + ArrayConverter.bytesToHexString((byte[])ArrayConverter.bigIntegerToByteArray((BigInteger)helpValue1)));
        BigInteger helpValue2 = clientPublicKey.multiply(helpValue1);
        BigInteger helpValue3 = helpValue2.mod(modulus);
        LOGGER.debug("A * v^u" + ArrayConverter.bytesToHexString((byte[])ArrayConverter.bigIntegerToByteArray((BigInteger)helpValue3)));
        helpValue1 = helpValue3.modPow(serverPrivateKey, modulus);
        LOGGER.debug("PremstSercret" + ArrayConverter.bytesToHexString((byte[])ArrayConverter.bigIntegerToByteArray((BigInteger)helpValue1)));
        return ArrayConverter.bigIntegerToByteArray((BigInteger)helpValue1);
    }

    private BigInteger calculateV(BigInteger x, BigInteger generator, BigInteger modulus) {
        BigInteger v = generator.modPow(x, modulus);
        return v;
    }

    private BigInteger calculateU(BigInteger clientPublic, BigInteger serverPublic, BigInteger modulus) {
        byte[] paddedClientPublic = this.calculatePadding(modulus, clientPublic);
        LOGGER.debug("ClientPublic Key:" + ArrayConverter.bytesToHexString((byte[])ArrayConverter.bigIntegerToByteArray((BigInteger)clientPublic)));
        LOGGER.debug("PaddedClientPublic. " + ArrayConverter.bytesToHexString((byte[])paddedClientPublic));
        byte[] paddedServerPublic = this.calculatePadding(modulus, serverPublic);
        LOGGER.debug("ServerPublic Key:" + ArrayConverter.bytesToHexString((byte[])ArrayConverter.bigIntegerToByteArray((BigInteger)serverPublic)));
        LOGGER.debug("PaddedServerPublic. " + ArrayConverter.bytesToHexString((byte[])paddedServerPublic));
        byte[] hashInput = ArrayConverter.concatenate((byte[][])new byte[][]{paddedClientPublic, paddedServerPublic});
        LOGGER.debug("HashInput for u: " + ArrayConverter.bytesToHexString((byte[])hashInput));
        byte[] hashOutput = this.SHAsum(hashInput);
        LOGGER.debug("Hashvalue for u: " + ArrayConverter.bytesToHexString((byte[])hashOutput));
        return new BigInteger(1, hashOutput);
    }

    private byte[] calculatePadding(BigInteger modulus, BigInteger topad) {
        byte[] paddingArray;
        int modulusByteLength = ArrayConverter.bigIntegerToByteArray((BigInteger)modulus).length;
        if (modulusByteLength == (paddingArray = ArrayConverter.bigIntegerToByteArray((BigInteger)topad)).length) {
            return paddingArray;
        }
        int paddingByteLength = modulusByteLength - paddingArray.length;
        if (paddingByteLength < 0) {
            LOGGER.warn("Negative SRP Padding Size. Using 0");
            paddingByteLength = 0;
        }
        byte[] padding = new byte[paddingByteLength];
        return ArrayConverter.concatenate((byte[][])new byte[][]{padding, paddingArray});
    }

    public BigInteger calculateX(byte[] salt, byte[] identity, byte[] password) {
        byte[] hashInput1 = ArrayConverter.concatenate((byte[][])new byte[][]{identity, ArrayConverter.hexStringToByteArray((String)"3A"), password});
        LOGGER.debug("HashInput for hashInput1: " + ArrayConverter.bytesToHexString((byte[])hashInput1));
        byte[] hashOutput1 = this.SHAsum(hashInput1);
        LOGGER.debug("Hashvalue for hashInput1: " + ArrayConverter.bytesToHexString((byte[])hashOutput1));
        byte[] hashInput2 = ArrayConverter.concatenate((byte[][])new byte[][]{salt, hashOutput1});
        LOGGER.debug("HashInput for hashInput2: " + ArrayConverter.bytesToHexString((byte[])hashInput2));
        byte[] hashOutput2 = this.SHAsum(hashInput2);
        LOGGER.debug("Hashvalue for hashInput2: " + ArrayConverter.bytesToHexString((byte[])hashOutput2));
        return new BigInteger(1, hashOutput2);
    }

    private BigInteger calculateSRP6Multiplier(BigInteger modulus, BigInteger generator) {
        byte[] paddedGenerator = this.calculatePadding(modulus, generator);
        byte[] hashInput = ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.bigIntegerToByteArray((BigInteger)modulus), paddedGenerator});
        LOGGER.debug("HashInput SRP6Multi: " + ArrayConverter.bytesToHexString((byte[])hashInput));
        byte[] hashOutput = this.SHAsum(hashInput);
        return new BigInteger(1, hashOutput);
    }

    public byte[] SHAsum(byte[] toHash) {
        MessageDigest dig = null;
        try {
            dig = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.warn((Object)ex);
        }
        dig.update(toHash);
        return dig.digest();
    }

    private void setComputationGenerator(SrpClientKeyExchangeMessage msg) {
        msg.getComputations().setGenerator(this.chooser.getSRPGenerator());
        LOGGER.debug("Generator: " + msg.getComputations().getGenerator().getValue());
    }

    private void setComputationModulus(SrpClientKeyExchangeMessage msg) {
        msg.getComputations().setModulus(this.chooser.getSRPModulus());
        LOGGER.debug("Modulus: " + msg.getComputations().getModulus().getValue());
    }

    private void preparePremasterSecret(SrpClientKeyExchangeMessage msg) {
        msg.getComputations().setPremasterSecret(this.premasterSecret);
        this.premasterSecret = (byte[])msg.getComputations().getPremasterSecret().getValue();
        LOGGER.debug("PremasterSecret: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getComputations().getPremasterSecret().getValue())));
    }

    private void preparePublicKey(SrpClientKeyExchangeMessage msg) {
        msg.setPublicKey(this.clientPublicKey.toByteArray());
        LOGGER.debug("PublicKey: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPublicKey().getValue())));
    }

    private void preparePublicKeyLength(SrpClientKeyExchangeMessage msg) {
        msg.setPublicKeyLength(((byte[])msg.getPublicKey().getValue()).length);
        LOGGER.debug("PublicKeyLength: " + msg.getPublicKeyLength().getValue());
    }

    private void prepareClientServerRandom(SrpClientKeyExchangeMessage msg) {
        this.random = ArrayConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()});
        msg.getComputations().setClientServerRandom(this.random);
        this.random = (byte[])msg.getComputations().getClientServerRandom().getValue();
        LOGGER.debug("ClientServerRandom: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getComputations().getClientServerRandom().getValue())));
    }

    @Override
    public void prepareAfterParse(boolean clientMode) {
        if (!clientMode) {
            BigInteger privateKey = this.chooser.getSRPServerPrivateKey();
            BigInteger clientPublic = new BigInteger(1, (byte[])this.msg.getPublicKey().getValue());
            this.msg.prepareComputations();
            this.premasterSecret = this.calculatePremasterSecretServer(this.chooser.getSRPModulus(), this.chooser.getSRPGenerator(), privateKey, this.chooser.getSRPServerPublicKey(), clientPublic, this.chooser.getSRPServerSalt(), this.chooser.getSRPIdentity(), this.chooser.getSRPPassword());
            this.preparePremasterSecret(this.msg);
            this.prepareClientServerRandom(this.msg);
        }
    }

    private void setComputationPrivateKey(SrpClientKeyExchangeMessage msg) {
        msg.getComputations().setPrivateKey(this.chooser.getSRPClientPrivateKey());
        LOGGER.debug("Computation PrivateKey: " + ((BigInteger)msg.getComputations().getPrivateKey().getValue()).toString());
    }

    private void setComputationServerPublicKey(SrpClientKeyExchangeMessage msg) {
        msg.getComputations().setServerPublicKey(this.chooser.getSRPServerPublicKey());
        LOGGER.debug("Computation PublicKey: " + ((BigInteger)msg.getComputations().getServerPublicKey().getValue()).toString());
    }

    private void prepareSalt(SrpClientKeyExchangeMessage msg) {
        msg.setSalt(msg.getComputations().getSalt());
        LOGGER.debug("Salt: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSalt().getValue())));
    }

    private void prepareSaltLength(SrpClientKeyExchangeMessage msg) {
        msg.setSaltLength(((byte[])msg.getSalt().getValue()).length);
        LOGGER.debug("Salt Length: " + msg.getSaltLength().getValue());
    }

    private void setSRPIdentity(SrpClientKeyExchangeMessage msg) {
        msg.getComputations().setSRPIdentity(this.chooser.getSRPIdentity());
        LOGGER.debug("SRP Identity used for Computations: " + msg.getComputations().getSRPIdentity());
    }

    private void setSRPPassword(SrpClientKeyExchangeMessage msg) {
        msg.getComputations().setSRPPassword(this.chooser.getSRPPassword());
        LOGGER.debug("SRP Password used for Computations: " + msg.getComputations().getSRPPassword());
    }

    private void setComputationSalt(SrpClientKeyExchangeMessage msg) {
        msg.getComputations().setSalt(this.chooser.getSRPServerSalt());
        LOGGER.debug("Salt used for Computations: " + msg.getComputations().getSalt());
    }

    private void prepareGenerator(SrpClientKeyExchangeMessage msg) {
        msg.setGenerator(msg.getComputations().getGenerator().getByteArray());
        LOGGER.debug("Generator: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getGenerator().getValue())));
    }

    private void prepareModulus(SrpClientKeyExchangeMessage msg) {
        msg.setModulus(msg.getComputations().getModulus().getByteArray());
        LOGGER.debug("Modulus: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getModulus().getValue())));
    }

    private void prepareGeneratorLength(SrpClientKeyExchangeMessage msg) {
        msg.setGeneratorLength(((byte[])msg.getGenerator().getValue()).length);
        LOGGER.debug("Generator Length: " + msg.getGeneratorLength().getValue());
    }

    private void prepareModulusLength(SrpClientKeyExchangeMessage msg) {
        msg.setModulusLength(((byte[])msg.getModulus().getValue()).length);
        LOGGER.debug("Modulus Length: " + msg.getModulusLength().getValue());
    }
}

