/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import org.gradle.internal.resources.AbstractResourceLockRegistry;
import org.gradle.internal.resources.AllProjectsLock;
import org.gradle.internal.resources.LockCache;
import org.gradle.internal.resources.ProjectLock;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockContainer;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.util.Path;

public class ProjectLockRegistry
extends AbstractResourceLockRegistry<Path, ProjectLock> {
    private final boolean parallelEnabled;
    private final LockCache<Path, AllProjectsLock> allProjectsLocks;

    public ProjectLockRegistry(ResourceLockCoordinationService coordinationService, boolean parallelEnabled) {
        super(coordinationService);
        this.parallelEnabled = parallelEnabled;
        this.allProjectsLocks = new LockCache(coordinationService, this);
    }

    public boolean getAllowsParallelExecution() {
        return this.parallelEnabled;
    }

    public ResourceLock getAllProjectsLock(final Path buildIdentityPath) {
        return this.allProjectsLocks.getOrRegisterResourceLock(buildIdentityPath, new AbstractResourceLockRegistry.ResourceLockProducer<Path, AllProjectsLock>(){

            @Override
            public AllProjectsLock create(Path key, ResourceLockCoordinationService coordinationService, ResourceLockContainer owner) {
                String displayName = "All projects of " + buildIdentityPath;
                return new AllProjectsLock(displayName, coordinationService, owner);
            }
        });
    }

    public ProjectLock getProjectLock(Path buildIdentityPath, Path projectIdentityPath) {
        return this.doGetResourceLock(buildIdentityPath, this.parallelEnabled ? projectIdentityPath : buildIdentityPath);
    }

    private ProjectLock doGetResourceLock(final Path buildIdentityPath, final Path lockPath) {
        return this.getOrRegisterResourceLock(lockPath, new AbstractResourceLockRegistry.ResourceLockProducer<Path, ProjectLock>(){

            @Override
            public ProjectLock create(Path projectPath, ResourceLockCoordinationService coordinationService, ResourceLockContainer owner) {
                String displayName = ProjectLockRegistry.this.parallelEnabled ? "state of project " + lockPath : "state of build " + lockPath;
                return new ProjectLock(displayName, coordinationService, owner, ProjectLockRegistry.this.getAllProjectsLock(buildIdentityPath));
            }
        });
    }
}

