;;; DO NOT MODIFY THIS FILE
(if (featurep 'xwem-loaddefs) (error "Already loaded"))

;;;### (autoloads (xwem-client-local-variable-value xwem-client-local-variable-set xwem-client-local-variable-p xwem-dummy-selected-p xwem-dummy-client xwem-non-dummy-client-p xwem-dummy-client-p xwem-withdraw xwem-refit xwem-iconify xwem-deactivate xwem-activate xwem-manage xwem-cl-honour-init-state xwem-client-change-manage-type xwem-fini-clients xwem-cl-get-uptime xwem-cl-get-psize xwem-cl-get-usize xwem-cl-get-init-state xwem-cl-step-geom xwem-cl-min-geom xwem-cl-change-window xwem-client-move-resize xwem-client-resize xwem-client-move xwem-cl-apply-new-xgeom xwem-cl-apply-plist xwem-cl-destroy xwem-xwin-try-to-manage xwem-make-client xwem-client-change-state xwem-client-sendmsg-atom xwem-cl-correct-size-for-size xwem-select-last-or-other-client xwem-select-some-client xwem-cl-list-sort-by-recency xwem-clients-list xwem-find-client xwem-client-name xwem-select-client xwem-cl-select xwem-client-property xwem-client-set-properties xwem-client-set-property xwem-unsupport-cl-property xwem-support-cl-property xwem-property-supported-p define-xwem-client-property xwem-cl-marked-p) "xwem-clients" "lisp/xwem-clients.el")

(defcustom xwem-client-focusing 'advanced "Clients focusing type.\nOne of:\n\n  'advanced -  Any client can be selected, even if it has broken focus model.\n  'standard -  Strictly follow ICCCM, hoping everything will be ok.\n\nYou should change default value only in very rare circumstances.  You\nshould fully understand how focusing works in xwem to change default\nvalue." :type '(choice (const :tag "Advanced" advanced) (const :tag "Standard" standard)) :group 'xwem-cl)

(defvar xwem-clients nil "\
List of all managed clients.")

(defvar xwem-current-cl nil "\
Internal variable.
Use `xwem-cl-selected' to get selected client.")

(defvar xwem-last-cl nil "\
Last selected client.
Use `(xwem-last-client)' to get last selected client.")

(autoload 'xwem-cl-marked-p "xwem-clients" "\
Return non-nil if client CL is marked, i.e. in `xwem-cl-mark-ring' list." nil 'macro)

(defvar xwem-supported-client-properties nil "\
List of supported client's properties definitions.
Property definition is list in form:
\(NAME . (MANAGE-TYPE (KEYWORD VAL ...) ...)).

Valid KEYWORD are:

   `:type' - Same as for `defcustom'.  eval composite type added.

   `:set' - Function to call when setting this property. Default is
            `xwem-cl-put-prop'.  Function called with three
            arguments - CL PROP VAL.

   `:get'  - Function to call in order to fetch property value. Default
             is `xwem-cl-get-prop'. Function called with two
             arguments - CL PROP.
")

(autoload 'define-xwem-client-property "xwem-clients" "\
Define new xwem client property NAME." nil 'macro)

(autoload 'xwem-property-supported-p "xwem-clients" "\
Return non-nil if client property PROP is supported." nil nil)

(autoload 'xwem-support-cl-property "xwem-clients" "\
Add supported client property." nil nil)

(autoload 'xwem-unsupport-cl-property "xwem-clients" "\
Remove PROP-NAME from supported property for MANAGE-TYPE." nil nil)

(autoload 'xwem-client-set-property "xwem-clients" "\
Set client property." nil nil)

(autoload 'xwem-client-set-properties "xwem-clients" "\
To CL's properties import PROPS." nil nil)

(autoload 'xwem-client-property "xwem-clients" "\
Return CL's property PROP." nil nil)

(autoload 'xwem-cl-select "xwem-clients" "\
Set CL to be current cl." nil nil)

(autoload 'xwem-select-client "xwem-clients" "\
Select new client CL.
CL will not be selected if currently selected client has property
`skip-deselect', unless CL has property `override-skip-deselect'.
If CL is not selected because of above condition, last client is
updated however.
If CL is non-client, dummy client will be selected." nil nil)

(autoload 'xwem-client-name "xwem-clients" "\
Returns unique name for CL.
If CLIST is ommited, `xwem-clients' will be used.
If CL is string, return it." nil nil)

(autoload 'xwem-find-client "xwem-clients" "\
Find WIN-OR-ID in client windows list.
WIN-OR-ID can be X-Win or id of window." nil nil)
(autoload 'xwem-cl-send-config "xwem-clients")

(autoload 'xwem-clients-list "xwem-clients" "\
Return xwem clients list.

PREDICT is function passed with one argument - CL and must return
non-nil if CL must be included in resulting list.  If PREDICT not
specified - all clients are included.

If INCLUDE-DUMMY is non-nil also include dummy clients(clients for
which `xwem-dummy-client-p' returns non-nil).

STATES is a list of valid states for client or 'any." nil nil)

(autoload 'xwem-cl-list-sort-by-recency "xwem-clients" "\
Sort clients in CL-LIST by their recency." nil nil)
(autoload 'xwem-cl-other "xwem-clients")

(autoload 'xwem-select-some-client "xwem-clients" nil nil nil)

(autoload 'xwem-select-last-or-other-client "xwem-clients" "\
Select last or other client according to CL.
New client selected only if CL is current selected or FORCE is non-nil
or dummy client currently selected.

`xwem-select-last-or-other-client' tries to avoid selecting dummy
clients, unless ALLOW-DUMMY is non-nil." nil nil)

(autoload 'xwem-cl-correct-size-for-size "xwem-clients" "\
Make CL's geometry as close to NEW-GEOM as possible.
X-TYPE is one of 'center 'left or 'right, default is 'center.
Y-TYPE is one of 'center 'top or 'bottom, default is 'center." nil nil)
(autoload 'xwem-client-iconify-every "xwem-clients" "" t)

(autoload 'xwem-client-sendmsg-atom "xwem-clients" "\
Send Client message to client CL." nil nil)

(autoload 'xwem-client-change-state "xwem-clients" "\
Change WM_STATE for CL, to STATE.
STATE is one of 'active, 'inactive, 'iconified, 'withdrawn, etc." nil nil)

(autoload 'xwem-make-client "xwem-clients" "\
Make new client window.
XWIN   - X Window.
PROPS - Properties list for new client.
XWEM-WIN - xwem window where new client should be managed(if possible)." nil nil)

(autoload 'xwem-xwin-try-to-manage "xwem-clients" "\
Try to manage X window XWIN.
Return managed client, or nil if client wasnt managed." nil nil)

(autoload 'xwem-cl-destroy "xwem-clients" "\
Tottally destroy CL." nil nil)

(autoload 'xwem-cl-apply-plist "xwem-clients" "\
Set plist's properties in CL." nil nil)

(autoload 'xwem-cl-apply-new-xgeom "xwem-clients" "\
Apply entries in `xwem-cl-new-xgeom' to CL's x geometry.
When CORRECT-INCLUDING-BORDER is non-nil, then
`xwem-cl-correct-size-for-size' will correct size reguarding new
border width, otherwise it will correct size as if border width is 0.
If HOLD-SIZE is non-nil no size corrections are performed." nil nil)
(autoload 'xwem-cl-apply-xgeom "xwem-clients")
(autoload 'xwem-cl-apply-xgeom-1 "xwem-clients")

(autoload 'xwem-client-move "xwem-clients" "\
Move client CL to NEW-X, NEW-Y." nil nil)

(autoload 'xwem-client-resize "xwem-clients" "\
Resize client CL to NEW-WIDTH, NEW-HEIGHT." nil nil)

(autoload 'xwem-client-move-resize "xwem-clients" "\
Move CL to NEW-X, NEW-Y and resize to NEW-WIDTH, NEW-HEIGHT." nil nil)

(autoload 'xwem-cl-change-window "xwem-clients" "\
Change CL's window to NEW-WIN.
If NEW-WIN is nil, NEW-WIN will be other window to CL's win window." nil nil)

(autoload 'xwem-cl-min-geom "xwem-clients" "\
Returns minimal geometry for CL." nil nil)

(autoload 'xwem-cl-step-geom "xwem-clients" "\
Returns vertical and horisontal step's width for CL." nil nil)

(autoload 'xwem-cl-get-init-state "xwem-clients" "\
Return CL's initial state.
Initial state is one of `X-IconicState', `X-NormalState',
or nil if initial state did not specified by client." nil nil)

(autoload 'xwem-cl-get-usize "xwem-clients" "\
Returns cons cell (uwi . uhe) - CL's size in steps." nil nil)

(autoload 'xwem-cl-get-psize "xwem-clients" "\
Return pixel size of CL (pwi . phe)." nil nil)

(autoload 'xwem-cl-get-uptime "xwem-clients" "\
Return CL's uptime.
FORMAT can contain %-sequences to substitute parts of the uptime.
%d is replaced by the days
%h is replaced by the hours
%m is replaced by the minutes
%s is replaced by the seconds
%A is replaced by autogenerated format." nil nil)

(autoload 'xwem-fini-clients "xwem-clients" "\
Fini all clients." nil nil)

(autoload 'xwem-client-change-manage-type "xwem-clients" "\
Change CL's manage type to type specified in MANAGE-SPEC." nil nil)

(autoload 'xwem-cl-honour-init-state "xwem-clients" nil nil nil)

(autoload 'xwem-manage "xwem-clients" "\
Manage client CL." nil nil)

(autoload 'xwem-activate "xwem-clients" "\
Activate client CL in its context.
TYPE is one of:

  `activate' - Client is non-active and activation required.

  `select' - Client is about to be selected, so activation required.
             Client may be already activated.

Default TYPE is `activate'." nil nil)

(autoload 'xwem-deactivate "xwem-clients" "\
Deactivate client CL in its context.
NOTE that only active client can be deactivated!
TYPE is one of:

   `deactivate' - Client must be deactivate.
 
   `deselect' - Client is deselecting.

Default TYPE is `deactivate'." nil nil)

(autoload 'xwem-iconify "xwem-clients" "\
Function to iconify client CL.
ARGS - arguments." nil nil)

(autoload 'xwem-refit "xwem-clients" "\
Function to refit client CL.
ARGS - arguments." nil nil)

(autoload 'xwem-withdraw "xwem-clients" "\
Withdraw client CL." nil nil)

(autoload 'xwem-dummy-client-p "xwem-clients" "\
Return non-nil if CL is dummy client." nil nil)

(autoload 'xwem-non-dummy-client-p "xwem-clients" "\
Opposit to `xwem-dummy-client-p'." nil nil)

(autoload 'xwem-dummy-client "xwem-clients" "\
Return dummy client." nil nil)

(autoload 'xwem-dummy-selected-p "xwem-clients" "\
Return non-nil if dummy client is currently selected." nil nil)

(autoload 'xwem-client-local-variable-p "xwem-clients" "\
Return non-nil if VAL is client local variable." nil nil)

(autoload 'xwem-client-local-variable-set "xwem-clients" "\
Set CLIENT local VARIABLE to VALUE." nil nil)

(autoload 'xwem-client-local-variable-value "xwem-clients" "\
Return CLINEN's local VARIABLE value.
Or global VARIABLE value if CLIENT does not have local value." nil nil)

;;;***

;;;### (autoloads (xwem-unread-command-event xwem-dispatch-command-xevent xwem-dispatch-command-event xwem-next-command-event xwem-event-as-command xwem-next-event xwem-event-client xwem-ev-destroy xwem-ev-unmap xwem-ev-mapreq xwem-ev-resize xwem-ev-reconfig) "xwem-events" "lisp/xwem-events.el")

(autoload 'xwem-ev-reconfig "xwem-events" "\
Common ConfigureRequest handler." nil nil)

(autoload 'xwem-ev-resize "xwem-events" "\
Handle ResizeRequest event." nil nil)

(autoload 'xwem-ev-mapreq "xwem-events" "\
Handle MapRequest event." nil nil)

(autoload 'xwem-ev-unmap "xwem-events" "\
Handle UnmapNotify event." nil nil)

(autoload 'xwem-ev-destroy "xwem-events" "\
Handle Destroy event." nil nil)

(autoload 'xwem-event-client "xwem-events" "\
Return client where X event XEV occured." nil nil)

(autoload 'xwem-next-event "xwem-events" "\
Fetch next Emacs keyboard or mouse event, with corresponding X Event.

If EVT-LIST is given, stop when event of type that in EVT-LIST is
occured.  Default value of EVT-LIST is `(list X-KeyPress X-ButtonPress
X-ButtonRelease X-MotionNotify)'.

Return Emacs event.  To acces corresponding X Event use
`(event-object ev)' form." nil nil)

(autoload 'xwem-event-as-command "xwem-events" "\
Interpret event E-EV as command event.
Optional X-EV specifies corresponding X Event." nil nil)

(autoload 'xwem-next-command-event "xwem-events" "\
Return next command event.
Actually return cons cell where car is Emacs event and cdr is X Event." nil nil)

(autoload 'xwem-dispatch-command-event "xwem-events" "\
Dispatch command Emacs event EEV." nil nil)

(autoload 'xwem-dispatch-command-xevent "xwem-events" "\
Dispatch command event XEV." nil nil)

(autoload 'xwem-unread-command-event "xwem-events" "\
Make event EV to be readed by `xwem-next-command-event' later,
or to be executed by `xwem-dispatch-command-event'.
Event EV can be either Emacs event, or X-Event." nil nil)

;;;***

;;;### (autoloads (xwem-face-get-gc xwem-get-background-mode) "xwem-faces" "lisp/xwem-faces.el")

(autoload 'xwem-get-background-mode "xwem-faces" "\
Return `dark' or `light' according to COLOR.
COLOR is color instance, color name or list of color components." nil nil)

(autoload 'xwem-face-get-gc "xwem-faces" "\
Return X-Gc for FACE in TAG-SET.
D    - X drawable default is `XDefaultRootWindow'." nil nil)

;;;***

;;;### (autoloads (xwem-focus-mode-set xwem-focus-mode-invoke xwem-focus-set xwem-focus-pop-set xwem-focus-push-set xwem-focus-pop xwem-focus-xcurrent) "xwem-focus" "lisp/xwem-focus.el")

(autoload 'xwem-focus-xcurrent "xwem-focus" "\
Return current focus." nil nil)

(autoload 'xwem-focus-pop "xwem-focus" "\
Pop value from `xwem-focus-stack'." nil nil)

(autoload 'xwem-focus-push-set "xwem-focus" "\
Push current focus to `xwem-focus-stack' and set focus to XWIN." nil nil)

(autoload 'xwem-focus-pop-set "xwem-focus" "\
Pop from `xwem-focus-stack' and set focus." nil nil)

(autoload 'xwem-focus-set "xwem-focus" "\
Set input focus to THING.
THING - one of X-Win, xwem-frame, or xwem-client.
PUSH  - Non-nil for pushing thing into `xwem-focus-stack'." nil nil)

(autoload 'xwem-focus-mode-invoke "xwem-focus" "\
Invoke CL's focus mode function with ARGS.
Invoke focus mode, car of ARGS normally type of invocation.
Built-in invocation types are:

  'before-mode-change   - Called before focus mode changed.
  'after-mode-change    - Called after focus mode has been changed.
  'focus-in             - When CL receives focus.
  'focus-out            - When CL looses focus.
  'enter                - When CL enters.
  'leave                - When CL leaves.
  'before-keymap-change - Before CL's local map changed.
  'after-keymap-change  - After CL's local map changed.
" nil nil)

(autoload 'xwem-focus-mode-set "xwem-focus" "\
For CL window set focus mode to MODE.
If MODE is ommited, `xwem-default-focus-mode' is used." nil nil)

;;;***

;;;### (autoloads (xwem-frame-properties xwem-frame-property xwem-frame-set-properties xwem-frame-set-property xwem-frame-add-property-notifier xwem-frame-clients xwem-frame-imove-internal xwem-set-frame-configuration xwem-frame-configuration xwem-frame-configuration-p xwem-frame-set-size xwem-frame-set-pos xwem-frame-num xwem-frame-other xwem-frames-fini xwem-frames-init xwem-select-frame xwem-frame-map xwem-frames-list) "xwem-frame" "lisp/xwem-frame.el")

(defvar xwem-frames-list nil "\
List of all xwem frames.")

(autoload 'xwem-frames-list "xwem-frame" "\
Return list of xwem frames of TYPE.
If TYPE is ommited - list of frames of any type is returned." nil nil)

(autoload 'xwem-frame-map "xwem-frame" "\
Map frame FRAME." nil nil)

(autoload 'xwem-select-frame "xwem-frame" "\
Set FRAME to be selected frame.
Actually all the work done in `xwem-select-window'." nil nil)
(autoload 'xwem-make-frame-1 "xwem-frame")

(autoload 'xwem-frames-init "xwem-frame" "\
xwem frames initializer." nil nil)

(autoload 'xwem-frames-fini "xwem-frame" "\
Finialize frames." nil nil)

(autoload 'xwem-frame-other "xwem-frame" "\
Same as `xwem-frame-other-frame', but return nil, if no good other frame found.
TYPE is ane of 'any, 'linkage" nil nil)

(autoload 'xwem-frame-num "xwem-frame" "\
Return FRAME index in `xwem-frames-list'." nil nil)
(autoload 'xwem-frame-apply-xgeom-1 "xwem-frame" nil nil)
(autoload 'xwem-frame-apply-xgeom "xwem-frame" nil nil)

(autoload 'xwem-frame-set-pos "xwem-frame" "\
Set FRAME position at NEW-X and NEW-Y." nil nil)

(autoload 'xwem-frame-set-size "xwem-frame" "\
Resize FRAME to NEW-WIDTH and NEW-HEIGHT." nil nil)

(autoload 'xwem-frame-configuration-p "xwem-frame" "\
Return non-nil if FRAME-CONFIG is looks like frame configuration." nil nil)

(autoload 'xwem-frame-configuration "xwem-frame" "\
Return current xwem frame configuration." nil nil)

(autoload 'xwem-set-frame-configuration "xwem-frame" "\
Restore the frames to the state described by FRAME-CONFIG." nil nil)

(autoload 'xwem-frame-imove-internal "xwem-frame" "\
Interactively move FRAME." nil nil)

(autoload 'xwem-frame-clients "xwem-frame" "\
Make list of all clients FRAME holds." nil nil)

(autoload 'xwem-frame-add-property-notifier "xwem-frame" nil nil nil)

(autoload 'xwem-frame-set-property "xwem-frame" "\
Set FRAME's propertie PROP to VAL.
If FRAME is nil - selected frame is used." nil nil)

(autoload 'xwem-frame-set-properties "xwem-frame" "\
Set FRAME properties PROPS." nil nil)

(autoload 'xwem-frame-property "xwem-frame" "\
Return value for FRAME's property PROP.
If FRAME is nil - selected frame is used." nil nil)

(autoload 'xwem-frame-properties "xwem-frame" "\
Return a list of FRAME's properties.
List is copied, you are free to modify it for your needs.
Note that only supported properties are returned.
If FRAME is omitted - selected frame is used." nil nil)

;;;***

;;;### (autoloads (xwem-logo-string) "xwem-help" "lisp/xwem-help.el")

(autoload 'xwem-logo-string "xwem-help" "\
Return textified XWEM's logo string." nil nil)

;;;***

;;;### (autoloads (xwem-icons-cl-icon) "xwem-icons" "lisp/xwem-icons.el")

(autoload 'xwem-icons-cl-icon "xwem-icons" "\
Get X-Image of CL's icon.
Return cons cell where car is X-Pixmap of icon and cdr is X-Pixmap
where mask for icon is stored.

TAG-SET specifies environment list for which icon is created." nil nil)

;;;***

;;;### (autoloads (xwem-kbd-initialize-modifiers xwem-kbd-stop-grabbing xwem-kbd-start-grabbing xwem-kbd-uninstall-grab xwem-kbd-install-grab xwem-kbd-graugra-key xwem-kbd-dispatch-binding xwem-kbd-get-binding xwem-lookup-key xwem-minor-mode-key-binding xwem-local-key-binding xwem-global-key-binding xwem-lookup-map xwem-kbd-set-current-prefix-keymap xwem-kbd-global-map-current-p xwem-kbd-current-map xwem-kbd-fixup-keymap xwem-kbd-stop-command-keys-echoing xwem-kbd-schedule-command-keys-echoing xwem-kbd-add-default-keymap xwem-kbd-add-pending-keys xwem-kbd-force-mods-release xwem-kbd-wait-key-release xwem-xevents->emacs-events xwem-kbd-kcode-modifier-p xwem-use-local-map) "xwem-keyboard" "lisp/xwem-keyboard.el")

(defvar xwem-event-client nil "\
Client where last key/mouse event occured.")

(defvar xwem-last-event nil "\
Last key/mouse event(Emacs event).")

(defvar xwem-last-xevent nil "\
Last key/mouse X Event.")

(defvar xwem-this-command-keys [] "\
Vector of events that were used to invoke this command.")

(defvar xwem-this-command nil "\
The command now being executed.")

(defvar xwem-last-command nil "\
The last command executed.")

(autoload 'xwem-use-local-map "xwem-keyboard" "\
Select KEYMAP as  local CL's keymap." nil nil)

(autoload 'xwem-kbd-kcode-modifier-p "xwem-keyboard" "\
Return non-nil if key code KCODE is modifier." nil nil)

(autoload 'xwem-xevents->emacs-events "xwem-keyboard" "\
Convert X-Events XEVS to Emacs events.

If TRUST-MODBITS is non-nil than we can trust modifier bits in
X-Event, otherwise we are trying to keep track of modifiers presses
and releases.  This is needed because core X events obtained from
RECORD extension does not have valid inforamtion about modifiers
bits." nil nil)

(autoload 'xwem-kbd-wait-key-release "xwem-keyboard" "\
Wait for key with KEYCODE for release." nil nil)

(autoload 'xwem-kbd-force-mods-release "xwem-keyboard" "\
Force release of MODS modifiers." nil nil)

(autoload 'xwem-kbd-add-pending-keys "xwem-keyboard" "\
Add KEYS as pending to be pressed in CL.
If CL is ommited selected client considered." nil nil)

(autoload 'xwem-kbd-add-default-keymap "xwem-keyboard" "\
Add KEYMAP to default keymaps.
KEYMAP MUST NOT HAS PARENTS!" nil nil)

(autoload 'xwem-kbd-schedule-command-keys-echoing "xwem-keyboard" "\
Schedule echoing pressed KEY in minibuffer." nil nil)

(autoload 'xwem-kbd-stop-command-keys-echoing "xwem-keyboard" "\
Stop echoing." nil nil)

(autoload 'xwem-kbd-fixup-keymap "xwem-keyboard" "\
Return fixed KEYMAP.
KEYMAP might be valid keymap or symbol, which `symbol-function' is keymap.
If KEYMAP can't be fixed, just return it." nil nil)

(autoload 'xwem-kbd-current-map "xwem-keyboard" "\
Return current prefix map." nil nil)

(autoload 'xwem-kbd-global-map-current-p "xwem-keyboard" "\
Return non-nil if `xwem-global-map' is current prefix map." nil nil)

(autoload 'xwem-kbd-set-current-prefix-keymap "xwem-keyboard" "\
Set current keymap to NEWKEYMAP.

Use (xwem-kbd-set-current-prefix-keymap nil) to set current keymap
to `xwem-global-keymap' instead of
\(xwem-kbd-set-current-prefix-keymap xwem-global-map)." nil nil)

(autoload 'xwem-lookup-map "xwem-keyboard" "\
Lookup keymap where KEYS command is defined." nil nil)

(autoload 'xwem-global-key-binding "xwem-keyboard" "\
Return global binding for KEYS." nil nil)

(autoload 'xwem-local-key-binding "xwem-keyboard" "\
Return local binding for KEYS." nil nil)

(autoload 'xwem-minor-mode-key-binding "xwem-keyboard" "\
Return CL's minor mode binding for KEYS.
Retun cons cell in form `(MODENAME . BINDING)'." nil nil)

(autoload 'xwem-lookup-key "xwem-keyboard" "\
In CLIENT's context, lookup for KEYS binding.
`xwem-lookup-key' omits default binding unless ACCEPT-DEFAULT is
non-nil." nil nil)

(autoload 'xwem-kbd-get-binding "xwem-keyboard" "\
Get binding value for KEYS for CLIENT.
By default CLIENT is currently selected client.
If optional REJECT-DEFAULT is non-nil, skip looking up default binding
\(pass `nil' as ACCEPT-DEFAULT to `lookup-key')." nil nil)

(autoload 'xwem-kbd-dispatch-binding "xwem-keyboard" "\
Process keymap or command entry LKM after `lookup-key'.
Return non-nil if some action was performed." nil nil)

(autoload 'xwem-kbd-graugra-key "xwem-keyboard" "\
Grab or Ungrab KEY on WIN.
MODE is either 'grab or 'ungrab.
BUTTON-MASK is mask passed to `XGrabButton' if MODE is 'grab and key
is actually a mouse key." nil nil)

(autoload 'xwem-kbd-install-grab "xwem-keyboard" "\
Install KEYMAP grabs on X window WIN." nil nil)

(autoload 'xwem-kbd-uninstall-grab "xwem-keyboard" "\
Uninstall KEYMAP grabs on X window WIN.

Optionally you can specify PREDICT to decide for which keys grabbing
should be uinstalled.  PREDICT must accept two arguments - KEY and
BINDING, and return non-nil if this KEY must be ungrabbed.

By default all keys are ungrabbed." nil nil)

(autoload 'xwem-kbd-start-grabbing "xwem-keyboard" "\
Begin grabbing keyboard (some key-prefix is entered).
Optionally you can specify CURSOR to be used, while grabbing." nil nil)

(autoload 'xwem-kbd-stop-grabbing "xwem-keyboard" "\
Stop grabbing keyboard." nil nil)

(autoload 'xwem-kbd-initialize-modifiers "xwem-keyboard" "\
Create internal modifier representation to speedup futher work.
Also update `xwem-kbd-evilmasks' if `xwem-kbd-evillocks' is non-nil." nil nil)

;;;***

;;;### (autoloads (xwem-keymacro-internal-play xwem-keymacro-execute-keys xwem-keymacro-executing-p) "xwem-keymacro" "lisp/xwem-keymacro.el")

(defvar xwem-keymacro-macros-stack nil "\
List of defined keyboard macroses.")

(autoload 'xwem-keymacro-executing-p "xwem-keymacro" "\
Return non-nil if executing keyboard macro." nil nil)

(autoload 'xwem-keymacro-execute-keys "xwem-keymacro" "\
Execute keyboard macro KEYS." nil nil)

(autoload 'xwem-keymacro-internal-play "xwem-keymacro" "\
Play Emacs KEYS TIMES times." nil nil)

;;;***

;;;### (autoloads (xwem-file-find-command xwem-execute-program-expecting xwem-launcher-query) "xwem-launcher" "lisp/xwem-launcher.el")

(autoload 'xwem-launcher-query "xwem-launcher" "\
Query for command to launch using PROMPT." nil nil)

(autoload 'xwem-execute-program-expecting "xwem-launcher" "\
Execute CMD expecting till client will be managed.
MANAGE-TYPE specifies which manage type to use in expectance.
CL-PLIST is properties for expected client.
Return managed client unless NON-BLOCK is non-nil." nil nil)

(autoload 'xwem-file-find-command "xwem-launcher" "\
Find appropriate command to open FILENAME file." nil nil)

;;;***

;;;### (autoloads nil "xwem-main" "lisp/xwem-main.el")

(defcustom xwem-commands-gc-cons-threshold 5000000 "*Value of `gc-cons-threshold' to use when executing xwem commands.\nMake sense only if `xwem-commands-inhibit-gc' is non-nil." :type 'number :group 'xwem)

(defcustom xwem-commands-inhibit-gc t "*Non-nil mean that xwem interactive commands runs without GCing." :type 'boolean :group 'xwem)

;;;***

;;;### (autoloads (xwem-manage-set-property xwem-manage-rem-property xwem-manage-property xwem-manda-add-expectance xwem-cl-was-expected-p xwem-cl-was-expected xwem-manda-find-match-1 xwem-cl-match-p xwem-class-match-p) "xwem-manage" "lisp/xwem-manage.el")

(autoload 'xwem-class-match-p "xwem-manage" "\
Return non-nil if CL matches CLI-REGEX, CLN-REGEX, WMNAME-REGEX.
CLI-REGEX is regexp to match class instance name.
CLN-REGEX is regexp to match class name.
WMNAME-REGEX is regexp to match CL's WM_NAME." nil nil)

(autoload 'xwem-cl-match-p "xwem-manage" "\
Check whether CL matches MATCH-SPEC.
MATCH-SPEC format is a list in form
  
  (or (TYPE PARAM) ..)

or
  
  (and (TYPE PARAM) ..).

TYPE is one of:

  `class-name' - To match CL's class name (PARAM is regex).

  `class-inst' - To match CL's class instance name (PARAM is regex).

  `name'       - Client name (PARAM is regex).

  `command'    - Client's WM_COMMAND (PARAM is regex)

  `property'   - PARAM is either property symbol, or cons cell where car
                 is property symbol and cdr is value of property to match.

  `function'   - PARAM is function which passed with one argument CL and
                 returns non-nil if CL matches.

  `eval'       - PARAM is form to evaluate.

  `or'|`and'   - Starts subspec, PARAM is MATCH-SPEC.

  `override-redirect' - If this TYPE is used, also match client with
                        override-redirect attribute, otherwise clients
                        with override-redirect are skiped, even if others
                        specs matches.

  `buffer-major-mode' - PARAM is major-mode name.  Matches if current
                        client is Emacs frame, frame's buffer is current
                        and its major mode is eq to PARAM.

  `buffer-name' - PARAM is regexp.  As `buffer-major-mode' but if PARAM matches
                  current buffer's name.

  `buffer-filename' - PARAM is regexp.  As `buffer-name' but if PARAM matches
                      current buffer's filename.

  `application' - PARAM is application name that is looked in
                  `xwem-applications-alist'.
" nil nil)

(autoload 'xwem-manda-find-match-1 "xwem-manage" "\
Search for CL match in MANAGE-LIST.
EXTRACTOR is where to obtain match-spec from MANAGE-LIST elements,
default is 'cddr." nil nil)

(autoload 'xwem-cl-was-expected "xwem-manage" "\
Mark/unmark CL as it was expected according to NEW value.
If NEW is non-nil mark CL as was expected.
If NEW is nil then unmark." nil nil)

(autoload 'xwem-cl-was-expected-p "xwem-manage" "\
Return non-nil if CL was expected for managing." nil nil)

(autoload 'xwem-manda-add-expectance "xwem-manage" "\
Install new EXPECTANCE in `xwem-manage-expectances' list.
EXPIRE-TIMEOUT specifies time-to-live for new entry in seconds
\(default is `xwem-manage-default-expectance-expire-timeout')." nil nil)

(autoload 'xwem-manage-property "xwem-manage" "\
For MANAGE-TYPE, return manage property PROP." nil nil)

(autoload 'xwem-manage-rem-property "xwem-manage" "\
For MANAGE-TYPE, remove property PROP." nil nil)

(autoload 'xwem-manage-set-property "xwem-manage" "\
For MANAGE-TYPE, set manage property PROP to VAL." nil nil)

(defun* define-xwem-manage-model-1 (manage-name docstring &key manage-properties cl-properties match-spec append manage-method activate-method deactivate-method refit-method iconify-method withdraw-method) "Define new managing model of MANAGE-NAME.\nDOCSTRING is documentation for managing model.\nMANAGE-PROPERTIES - Some manage properties used when managing clients\nof this managing model.\nCL-PROPERTIES - Client properties to import into client when client\nmanaging using this managing model.\nMATCH-SPEC - Client matching specification, see `xwem-cl-match-p'.\nAPPEND - Non-nil mean append to the end of managing models list.  By\ndefault managing models are prepended to list." (put manage-name :docstring docstring) (add-to-list 'xwem-manage-internal-list (list manage-name cl-properties match-spec) append) (setq manage-properties (xwem-misc-merge-plists xwem-manage-default-properties manage-properties)) (while manage-properties (xwem-manage-set-property manage-name (car manage-properties) (cadr manage-properties)) (setq manage-properties (cddr manage-properties))) (when manage-method (put 'manage manage-name manage-method)) (when activate-method (put 'activate manage-name activate-method)) (when deactivate-method (put 'deactivate manage-name deactivate-method)) (when refit-method (put 'refit manage-name refit-method)) (when iconify-method (put 'iconify manage-name iconify-method)) (when withdraw-method (put 'withdraw manage-name withdraw-method)))

;;;***

;;;### (autoloads nil "xwem-minibuffer" "lisp/xwem-minibuffer.el")

(defcustom xwem-minibuffer-border-width 2 "Border width for `xwem-minibuffer'." :type 'number :set (lambda (sym val) (set sym val) (let ((cl (and xwem-minibuffer (xwem-minib-cl xwem-minibuffer)))) (when (xwem-cl-p cl) (xwem-client-set-property cl 'x-border-width xwem-minibuffer-border-width)))) :initialize 'custom-initialize-default :group 'xwem-minibuffer)

(defcustom xwem-minibuffer-outer-border-width 1 "*Outer border width for xwem minibuffer." :type 'number :group 'xwem-minibuffer)

(defvar xwem-minibuffer nil "\
Default xwem minibuffer.")

;;;***

;;;### (autoloads (xwem-misc-lower-xwin xwem-misc-raise-xwin xwem-misc-unset-always-on-top xwem-misc-set-xwin-always-on-top xwem-debug xwem-misc-rotate-data xwem-misc-merge-plists xwem-misc-fixup-string xwem-misc-xbutton-cl xwem-misc-completing-read-using-iswitchb xwem-misc-xwin-background-mode xwem-exit-recursive-edit xwem-recursive-edit xwem-list-exchange-els xwem-message xwem-clear-message xwem-misc-xwin-valid-p xwem-misc-find-emacs-frame xwem-misc-find-frame xwem-misc-draw-bar xwem-misc-draw-shadow xwem-cursor-recolorize xwem-make-cursor xwem-make-color xwem-misc-colorspec-valid-p xwem-misc-colorspec->rgb-vector-safe xwem-misc-colorspec->rgb-vector xwem-xwin-cl) "xwem-misc" "lisp/xwem-misc.el")

(defcustom xwem-misc-turbo-mode nil "*Non-nil mean xwem will work as fast as it can.\nIn this case, some color related customizations may not apply on fly.\nSo on-fly theming will not work, etc.\nHowever seting its value to non-nil is most convinient for most users." :type 'boolean :group 'xwem-misc)

(defvar xwem-misc-mask-fgc nil "\
X-Gc with foreground 1.0 destination drawable has depth 1.")

(defvar xwem-misc-mask-bgc nil "\
X-Gc with foreground 1.0 destination drawable has depth 1.")

(autoload 'xwem-xwin-cl "xwem-misc" "\
Return CL, which X window is XWIN." nil 'macro)

(autoload 'xwem-misc-colorspec->rgb-vector "xwem-misc" "\
Conver color specification COLSPEC to internal representation.
COLSPEC maybe in form: #RRGGBB or name like 'green4'." nil nil)

(autoload 'xwem-misc-colorspec->rgb-vector-safe "xwem-misc" "\
Validate COLSPEC to be color specification in safe manner.
Return DEFRET or [0 0 0] if there was error." nil nil)

(autoload 'xwem-misc-colorspec-valid-p "xwem-misc" "\
Return non-nil if COLSPEC is valid color specification.
Valid colorspecification is spec in form: #RRGGBB or name like 'green4'." nil nil)

(autoload 'xwem-make-color "xwem-misc" "\
Create X-Color according to COLORSPEC." nil nil)

(autoload 'xwem-make-cursor "xwem-misc" "\
Make new cursor of TYPE and store it in WHERE-STORE.
BGCOL maybe nil, that mean masking will not be done." nil nil)

(autoload 'xwem-cursor-recolorize "xwem-misc" "\
Recolorize CURSOR to use NEW-FG foreground and NEW-BG background." nil nil)

(autoload 'xwem-misc-draw-shadow "xwem-misc" "\
Draw shadow." nil nil)

(autoload 'xwem-misc-draw-bar "xwem-misc" "\
Draw shadowed bar.
Bar filled with GC1.
Shadow thickness is TH and it is drawed with GC2 and GC3." nil nil)

(autoload 'xwem-misc-find-frame "xwem-misc" "\
Find Emacs frame by its NAME." nil nil)

(autoload 'xwem-misc-find-emacs-frame "xwem-misc" "\
Return Emacs frame that corresponds CL.
HACK, DO NOT USE." nil nil)

(autoload 'xwem-misc-xwin-valid-p "xwem-misc" "\
Return non-nil if XWIN is valid X window.
Do it in safe manner." nil nil)

(autoload 'xwem-clear-message "xwem-misc" "\
Clear xwem minibuffer's buffer." nil nil)

(autoload 'xwem-message "xwem-misc" "\
Display xwem message of TYPE using FMT format." nil nil)

(autoload 'xwem-list-exchange-els "xwem-misc" "\
In LIST exchange places of EL1 and EL2." nil nil)

(autoload 'xwem-recursive-edit "xwem-misc" "\
Enter recursive edit." nil nil)

(autoload 'xwem-exit-recursive-edit "xwem-misc" "\
Exit from recursive edit." nil nil)

(autoload 'xwem-misc-xwin-background-mode "xwem-misc" "\
Return XWIN's background mode in rectange WIDTHxHEIGHT+X+y.
Background mode is one of `light' or `dark'." nil nil)

(autoload 'xwem-misc-completing-read-using-iswitchb "xwem-misc" "\
Read a string in the xwem minibuffer using iswitchb package.
PROMPT is a string to prompt with.
TABLE is a list of strings to select.
PREDICATE is a function that limits completion to a subset of TABLE." nil nil)

(autoload 'xwem-misc-xbutton-cl "xwem-misc" "\
Return client where button event XEV occured." nil nil)

(autoload 'xwem-misc-fixup-string "xwem-misc" "\
Fixup STR to be no-more than MAX-WIDTH chars." nil nil)

(autoload 'xwem-misc-merge-plists "xwem-misc" "\
Merge plist entries on MERG-PLIST to PLIST1 and return resulting plist." nil nil)

(autoload 'xwem-misc-rotate-data "xwem-misc" "\
Rotate DATA obtained from XGetImage for use by XPutImage." nil nil)

(autoload 'xwem-debug "xwem-misc" nil nil nil)

(autoload 'xwem-misc-set-xwin-always-on-top "xwem-misc" "\
Mark xwin as always on top window.
If number RANK is given, it denotes rank of always on top window.
Higher RANK mean XWIN is above windows with lower RANK.
By default RANK is 10." nil nil)

(autoload 'xwem-misc-unset-always-on-top "xwem-misc" "\
Unmark XWIN as always on top window." nil nil)

(autoload 'xwem-misc-raise-xwin "xwem-misc" "\
Raise XWIN reguarding always on top windows." nil nil)

(autoload 'xwem-misc-lower-xwin "xwem-misc" "\
Lower XWIN according to its always on top rank." nil nil)

;;;***

;;;### (autoloads (xwem-turn-off-minor-mode xwem-turn-on-minor-mode) "xwem-modes" "lisp/xwem-modes.el")

(defvar xwem-minor-mode-alist nil "\
Alist saying how to show minor modes.
Each element is a list which looks like (VAR STRING).
STRING is shown when VAR is non-nil.")

(defvar xwem-minor-mode-map-alist nil "\
Alist of keymaps for use of minor modes.
Each element looks like (VAR . KEYMAP).")
(autoload 'xwem-add-minor-mode "xwem-modes")

(autoload 'xwem-turn-on-minor-mode "xwem-modes" "\
On CL, turn on minor mode MM-TOGGLE." nil nil)

(autoload 'xwem-turn-off-minor-mode "xwem-modes" "\
On CL, turn off minor mode MM-TOGGLE." nil nil)

;;;***

;;;### (autoloads (xwem-generate-cl-menu xwem-generate-menu xwem-generate-clients-menu xwem-generate-window-menu) "xwem-mouse" "lisp/xwem-mouse.el")

(autoload 'xwem-generate-window-menu "xwem-mouse" "\
Generate menu for WIN." nil nil)

(autoload 'xwem-generate-clients-menu "xwem-mouse" "\
Generate clients menu.
TITLE is menu title.
Optional MAX-MWIDTH argument specifies maximum width for menu items,
default is 42." nil nil)

(autoload 'xwem-generate-menu "xwem-mouse" "\
Generate xwem menu on fly." nil nil)

(autoload 'xwem-generate-cl-menu "xwem-mouse" "\
Generate menu for CL.
MAXNLEN - maximum menu width in characters." nil nil)

;;;***

;;;### (autoloads nil "xwem-register" "lisp/xwem-register.el")
(autoload 'xwem-registers-help "xwem-registers" nil "Show info about registers.")

;;;***

;;;### (autoloads (xwem-init-root) "xwem-root" "lisp/xwem-root.el")

(defvar xwem-another-wm-mode nil "\
Non-nil mean another wm is running.")

(autoload 'xwem-init-root "xwem-root" "\
Initialization part for root." nil nil)

;;;***

;;;### (autoloads (xwem-special-revert-focus xwem-special-p xwem-special-popup-frame) "xwem-special" "lisp/xwem-special.el")

(autoload 'xwem-special-popup-frame "xwem-special" "\
As `special-display-popup-frame', but popup frame for sure.
When NONDEDICATED-P is non-nil then frame will not be dedicated." nil nil)

(autoload 'xwem-special-p "xwem-special" "\
Return non-nil if CL is special client." nil nil)

(autoload 'xwem-special-revert-focus "xwem-special" "\
Try to predict who has focus, before SPEC-CL and revert to it." nil nil)

;;;***

;;;### (autoloads (xwem-rootgeom xwem-rootwin xwem-dpy) "xwem-struct" "lisp/xwem-struct.el")

(autoload 'xwem-dpy "xwem-struct" "\
Return default X display for XWEM." nil 'macro)

(autoload 'xwem-rootwin "xwem-struct" "\
Return default root window of `xwem-dpy'." nil 'macro)

(autoload 'xwem-rootgeom "xwem-struct" nil nil 'macro)

;;;***

;;;### (autoloads (xwem-tray-background-mode xwem-tray-find-dapp xwem-XTrayInit) "xwem-tray" "lisp/xwem-tray.el")

(autoload 'xwem-XTrayInit "xwem-tray" "\
Same as `XTrayInit'.
You should use this function instead of direct calls to `XTrayInit',
because in time you doing it xwem-tray may be uninitialised." nil nil)

(autoload 'xwem-tray-find-dapp "xwem-tray" "\
Finds dock application by X window XWIN." nil nil)

(autoload 'xwem-tray-background-mode "xwem-tray" "\
Return background mode(`dark' or `light') for system tray." nil nil)

;;;***

;;;### (autoloads (xwem-window-set-size xwem-set-window-configuration xwem-window-configuration xwem-win-only-one-p xwem-win-map xwem-win-set-height xwem-win-set-width xwem-window-set-pixsize xwem-select-window xwem-window-other xwem-window-prev xwem-window-next-vertical xwem-window-next xwem-win-set-cl xwem-win-rem-cl xwem-win-add-cl xwem-cl-set-win xwem-win-find-by-id xwem-win-find-by-num xwem-win-num xwem-win-make-list-by-next xwem-win-delim-shadow-thickness xwem-win-delim-width) "xwem-win" "lisp/xwem-win.el")

(defcustom xwem-win-vertical-delim-width '(8 . 1) "*Width in pixels for vertical delimiters.\ncar is delimiter width, cdr is shadow thickness." :type '(cons number number) :group 'xwem-win)

(defcustom xwem-win-horizontal-delim-width '(6 . 1) "*Width in pixels for horizontal delimiters.\ncar is delimiter width, cdr is shadow thickness." :type '(cons number number) :group 'xwem-win)

(autoload 'xwem-win-delim-width "xwem-win" "\
Return WIN's delimiter width." nil nil)

(autoload 'xwem-win-delim-shadow-thickness "xwem-win" "\
Return WIN's delimiter width." nil nil)

(autoload 'xwem-win-make-list-by-next "xwem-win" "\
Create list of WINDOW and all next windows." nil nil)

(autoload 'xwem-win-num "xwem-win" "\
Return relative WIN's number in logical window list." nil nil)

(autoload 'xwem-win-find-by-num "xwem-win" "\
In FRAME find window for which `xwem-win-num' returns NUM." nil nil)

(autoload 'xwem-win-find-by-id "xwem-win" "\
Find a window with WIN-ID." nil nil)

(autoload 'xwem-cl-set-win "xwem-win" "\
Associate CL with WIN.
WIN is valid WIN or nil." nil nil)

(autoload 'xwem-win-add-cl "xwem-win" "\
Into WIN's clients list add new client CL." nil nil)

(autoload 'xwem-win-rem-cl "xwem-win" "\
From WIN's clients list remove client CL." nil nil)

(autoload 'xwem-win-set-cl "xwem-win" "\
Associate WIN with CL as current client in WIN." nil nil)

(autoload 'xwem-window-next "xwem-win" "\
Return next window after WINDOW in canonical ordering of windows.
If omitted, WINDOW defaults to the `(xwem-win-selected)'." nil nil)

(autoload 'xwem-window-next-vertical "xwem-win" "\
Return next window which is vertically after WINDOW.
If WINDOW is not given `(xwem-win-selected)' will be used." nil nil)

(autoload 'xwem-window-prev "xwem-win" "\
Retrun previous window before WINDOW in canonical ordering of windows.
If ommitted, WINDOW defaults to the `(xwem-win-selected)'." nil nil)

(autoload 'xwem-window-other "xwem-win" "\
Return CNT's next window for WINDOW if CNT is greater then zero and
  previous if negative." nil nil)

(autoload 'xwem-select-window "xwem-win" "\
Set WINDOW to be selected window." nil nil)

(autoload 'xwem-window-set-pixsize "xwem-win" "\
Set pixsize for WINDOW." nil nil)

(autoload 'xwem-win-set-width "xwem-win" "\
Set window's WIN width to NEW-WIDTH." nil nil)

(autoload 'xwem-win-set-height "xwem-win" "\
Set window's WIN height to NEW-HEIGHT." nil nil)

(autoload 'xwem-win-map "xwem-win" "\
Apply FN to FRAME-WIN and each subwindow.
FN will be called with a window as argument.
If ommitted, WINDOW defaults to the `(xwem-win-selected)'." nil nil)

(autoload 'xwem-win-only-one-p "xwem-win" "\
Return non-nil if WINDOW is only one in chain.
If WINDOW ommitted `(xwem-win-selected)' used." nil nil)

(autoload 'xwem-window-configuration "xwem-win" "\
Return an object representing the current window configuration of xwem FRAME.
If FRAME is nil or ommited, use the sected frame." nil nil)

(autoload 'xwem-set-window-configuration "xwem-win" "\
Set window to CONFIG.
If optional argument SELECT-FRAME-P is non-nil also select frame for
which window CONFIG was generated." nil nil)

(autoload 'xwem-window-set-size "xwem-win" "\
Set WIN's size to be NEW-WIDTH, NEW-HEIGHT." nil nil)

;;;***

(provide 'xwem-loaddefs)
