/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.transport.ResultRequest;

public class ForecastResultRequest
extends ResultRequest {
    public ForecastResultRequest(StreamInput in) throws IOException {
        super(in);
        in.readEnum(AnalysisType.class);
    }

    public ForecastResultRequest(String forecastID, long start, long end) {
        super(forecastID, start, end);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isEmpty((CharSequence)this.configId)) {
            validationException = ValidateActions.addValidationError((String)"Forecaster ID is missing", validationException);
        }
        if (this.end <= 0L) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.ROOT, "%s: start %d, end %d", "timestamp is invalid", this.start, this.end), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("forecasterID", this.configId);
        builder.field("start", this.start);
        builder.field("end", this.end);
        builder.endObject();
        return builder;
    }
}

