/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.ad.ml.ThresholdingResult;
import org.opensearch.ad.model.ExpectedValueList;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.timeseries.annotation.Generated;
import org.opensearch.timeseries.constant.CommonValue;
import org.opensearch.timeseries.model.DataByFeatureId;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.FeatureData;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.util.ParseUtils;

public class AnomalyResult
extends IndexableResult {
    private static final Logger LOG = LogManager.getLogger(ThresholdingResult.class);
    public static final String PARSE_FIELD_NAME = "AnomalyResult";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(AnomalyResult.class, new ParseField("AnomalyResult", new String[0]), it -> AnomalyResult.parse(it));
    public static final String DETECTOR_ID_FIELD = "detector_id";
    public static final String ANOMALY_SCORE_FIELD = "anomaly_score";
    public static final String ANOMALY_GRADE_FIELD = "anomaly_grade";
    public static final String APPROX_ANOMALY_START_FIELD = "approx_anomaly_start_time";
    public static final String RELEVANT_ATTRIBUTION_FIELD = "relevant_attribution";
    public static final String PAST_VALUES_FIELD = "past_values";
    public static final String EXPECTED_VALUES_FIELD = "expected_values";
    public static final String THRESHOLD_FIELD = "threshold";
    public static final String IS_ANOMALY_FIELD = "is_anomaly";
    private final Double anomalyScore;
    private final Double anomalyGrade;
    private final Instant approxAnomalyStartTime;
    private final List<DataByFeatureId> relevantAttribution;
    private final List<DataByFeatureId> pastValues;
    private final List<ExpectedValueList> expectedValuesList;
    private final Double threshold;
    protected final Double confidence;
    private final String modelId;

    public AnomalyResult(String detectorId, String taskId, List<FeatureData> featureData, Instant dataStartTime, Instant dataEndTime, Instant executionStartTime, Instant executionEndTime, String error, Optional<Entity> entity, User user, Integer schemaVersion, String modelId) {
        this(detectorId, taskId, Double.NaN, Double.NaN, Double.NaN, featureData, dataStartTime, dataEndTime, executionStartTime, executionEndTime, error, entity, user, schemaVersion, modelId, null, null, null, null, null);
    }

    public AnomalyResult(String configId, String taskId, Double anomalyScore, Double anomalyGrade, Double confidence, List<FeatureData> featureData, Instant dataStartTime, Instant dataEndTime, Instant executionStartTime, Instant executionEndTime, String error, Optional<Entity> entity, User user, Integer schemaVersion, String modelId, Instant approxAnomalyStartTime, List<DataByFeatureId> relevantAttribution, List<DataByFeatureId> pastValues, List<ExpectedValueList> expectedValuesList, Double threshold) {
        super(configId, featureData, dataStartTime, dataEndTime, executionStartTime, executionEndTime, error, entity, user, schemaVersion, taskId);
        this.confidence = confidence;
        this.anomalyScore = anomalyScore;
        this.anomalyGrade = anomalyGrade;
        this.modelId = modelId;
        this.approxAnomalyStartTime = approxAnomalyStartTime;
        this.relevantAttribution = relevantAttribution;
        this.pastValues = pastValues;
        this.expectedValuesList = expectedValuesList;
        this.threshold = threshold;
    }

    public static AnomalyResult fromRawTRCFResult(String detectorId, long intervalMillis, String taskId, Double rcfScore, Double grade, Double confidence, List<FeatureData> featureData, Instant dataStartTime, Instant dataEndTime, Instant executionStartTime, Instant executionEndTime, String error, Optional<Entity> entity, User user, Integer schemaVersion, String modelId, double[] relevantAttribution, Integer relativeIndex, double[] pastValues, double[][] expectedValuesList, double[] likelihoodOfValues, Double threshold) {
        ArrayList<DataByFeatureId> convertedRelevantAttribution = null;
        ArrayList<DataByFeatureId> convertedPastValuesList = null;
        ArrayList<ExpectedValueList> convertedExpectedValues = null;
        if (grade > 0.0) {
            int j;
            int featureSize = featureData.size();
            if (relevantAttribution != null) {
                if (relevantAttribution.length == featureSize) {
                    convertedRelevantAttribution = new ArrayList<DataByFeatureId>(featureSize);
                    for (j = 0; j < featureSize; ++j) {
                        convertedRelevantAttribution.add(new DataByFeatureId(featureData.get(j).getFeatureId(), relevantAttribution[j]));
                    }
                } else {
                    LOG.error((Message)new ParameterizedMessage("Attribution array size does not match.  Expected [{}] but got [{}]", (Object)featureSize, (Object)relevantAttribution.length));
                }
            }
            if (pastValues != null) {
                if (pastValues.length == featureSize) {
                    convertedPastValuesList = new ArrayList<DataByFeatureId>(featureSize);
                    for (j = 0; j < featureSize; ++j) {
                        convertedPastValuesList.add(new DataByFeatureId(featureData.get(j).getFeatureId(), pastValues[j]));
                    }
                } else {
                    LOG.error((Message)new ParameterizedMessage("Past value array size does not match.  Expected [{}] but got [{}]", (Object)featureSize, (Object)pastValues.length));
                }
            }
            if (expectedValuesList != null && expectedValuesList.length > 0) {
                int numberOfExpectedLists = expectedValuesList.length;
                int numberOfExpectedVals = expectedValuesList[0].length;
                if (numberOfExpectedVals == featureSize && likelihoodOfValues.length == numberOfExpectedLists) {
                    convertedExpectedValues = new ArrayList<ExpectedValueList>(numberOfExpectedLists);
                    for (int j2 = 0; j2 < numberOfExpectedLists; ++j2) {
                        ArrayList<DataByFeatureId> valueList = new ArrayList<DataByFeatureId>(featureSize);
                        for (int k = 0; k < featureSize; ++k) {
                            valueList.add(new DataByFeatureId(featureData.get(k).getFeatureId(), expectedValuesList[j2][k]));
                        }
                        convertedExpectedValues.add(new ExpectedValueList(likelihoodOfValues[j2], valueList));
                    }
                } else if (numberOfExpectedVals != featureSize) {
                    LOG.error((Message)new ParameterizedMessage("expected value array mismatch.  Expected [{}] actual [{}].", (Object)featureSize, (Object)numberOfExpectedVals));
                } else {
                    LOG.error((Message)new ParameterizedMessage("likelihood and expected array mismatch: Likelihood [{}] expected value [{}].", (Object)likelihoodOfValues.length, (Object)numberOfExpectedLists));
                }
            }
        }
        return new AnomalyResult(detectorId, taskId, rcfScore, Math.max(0.0, grade), confidence, featureData, dataStartTime, dataEndTime, executionStartTime, executionEndTime, error, entity, user, schemaVersion, modelId, relativeIndex == null || dataStartTime == null ? null : Instant.ofEpochMilli(dataStartTime.toEpochMilli() + (long)relativeIndex.intValue() * intervalMillis), convertedRelevantAttribution, convertedPastValuesList, convertedExpectedValues, threshold);
    }

    public AnomalyResult(StreamInput input) throws IOException {
        super(input);
        this.modelId = input.readOptionalString();
        this.confidence = input.readDouble();
        this.anomalyScore = input.readDouble();
        this.anomalyGrade = input.readDouble();
        this.approxAnomalyStartTime = input.readOptionalInstant();
        int attributeNumber = input.readVInt();
        if (attributeNumber <= 0) {
            this.relevantAttribution = null;
        } else {
            this.relevantAttribution = new ArrayList<DataByFeatureId>(attributeNumber);
            for (int i = 0; i < attributeNumber; ++i) {
                this.relevantAttribution.add(new DataByFeatureId(input));
            }
        }
        int pastValueNumber = input.readVInt();
        if (pastValueNumber <= 0) {
            this.pastValues = null;
        } else {
            this.pastValues = new ArrayList<DataByFeatureId>(pastValueNumber);
            for (int i = 0; i < pastValueNumber; ++i) {
                this.pastValues.add(new DataByFeatureId(input));
            }
        }
        int expectedValuesNumber = input.readVInt();
        if (expectedValuesNumber <= 0) {
            this.expectedValuesList = null;
        } else {
            this.expectedValuesList = new ArrayList<ExpectedValueList>();
            for (int i = 0; i < expectedValuesNumber; ++i) {
                this.expectedValuesList.add(new ExpectedValueList(input));
            }
        }
        this.threshold = input.readOptionalDouble();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().field(DETECTOR_ID_FIELD, this.configId).field("schema_version", this.schemaVersion);
        if (this.dataStartTime != null) {
            xContentBuilder.field("data_start_time", this.dataStartTime.toEpochMilli());
        }
        if (this.dataEndTime != null) {
            xContentBuilder.field("data_end_time", this.dataEndTime.toEpochMilli());
        }
        if (this.featureData != null) {
            xContentBuilder.field("feature_data", (Object)this.featureData.toArray());
        }
        if (this.executionStartTime != null) {
            xContentBuilder.field("execution_start_time", this.executionStartTime.toEpochMilli());
        }
        if (this.executionEndTime != null) {
            xContentBuilder.field("execution_end_time", this.executionEndTime.toEpochMilli());
        }
        if (this.anomalyScore != null && !this.anomalyScore.isNaN()) {
            xContentBuilder.field(ANOMALY_SCORE_FIELD, this.anomalyScore);
        }
        if (this.anomalyGrade != null && !this.anomalyGrade.isNaN()) {
            xContentBuilder.field(ANOMALY_GRADE_FIELD, this.anomalyGrade);
        }
        if (this.confidence != null && !this.confidence.isNaN()) {
            xContentBuilder.field("confidence", this.confidence);
        }
        if (this.error != null) {
            xContentBuilder.field("error", this.error);
        }
        if (this.optionalEntity.isPresent()) {
            xContentBuilder.field("entity", (ToXContent)this.optionalEntity.get());
        }
        if (this.user != null) {
            xContentBuilder.field("user", (ToXContent)this.user);
        }
        if (this.taskId != null) {
            xContentBuilder.field("task_id", this.taskId);
        }
        if (this.modelId != null) {
            xContentBuilder.field("model_id", this.modelId);
        }
        if (this.anomalyGrade != null && this.anomalyGrade > 0.0) {
            if (this.approxAnomalyStartTime != null) {
                xContentBuilder.field(APPROX_ANOMALY_START_FIELD, this.approxAnomalyStartTime.toEpochMilli());
            }
            if (this.relevantAttribution != null) {
                xContentBuilder.array(RELEVANT_ATTRIBUTION_FIELD, this.relevantAttribution.toArray());
            }
            if (this.pastValues != null) {
                xContentBuilder.array(PAST_VALUES_FIELD, this.pastValues.toArray());
            }
            if (this.expectedValuesList != null) {
                xContentBuilder.array(EXPECTED_VALUES_FIELD, this.expectedValuesList.toArray());
            }
        }
        if (this.threshold != null && !this.threshold.isNaN()) {
            xContentBuilder.field(THRESHOLD_FIELD, this.threshold);
        }
        return xContentBuilder.endObject();
    }

    public static AnomalyResult parse(XContentParser parser) throws IOException {
        String detectorId = null;
        Double anomalyScore = null;
        Double anomalyGrade = null;
        Double confidence = null;
        ArrayList<FeatureData> featureData = new ArrayList<FeatureData>();
        Instant dataStartTime = null;
        Instant dataEndTime = null;
        Instant executionStartTime = null;
        Instant executionEndTime = null;
        String error = null;
        Entity entity = null;
        User user = null;
        Integer schemaVersion = CommonValue.NO_SCHEMA_VERSION;
        String taskId = null;
        String modelId = null;
        Instant approAnomalyStartTime = null;
        ArrayList<DataByFeatureId> relavantAttribution = new ArrayList<DataByFeatureId>();
        ArrayList<DataByFeatureId> pastValues = new ArrayList<DataByFeatureId>();
        ArrayList<ExpectedValueList> expectedValues = new ArrayList<ExpectedValueList>();
        Double threshold = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block44: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "detector_id": {
                    detectorId = parser.text();
                    continue block44;
                }
                case "anomaly_score": {
                    anomalyScore = parser.doubleValue();
                    continue block44;
                }
                case "anomaly_grade": {
                    anomalyGrade = parser.doubleValue();
                    continue block44;
                }
                case "confidence": {
                    confidence = parser.doubleValue();
                    continue block44;
                }
                case "feature_data": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        featureData.add(FeatureData.parse(parser));
                    }
                    continue block44;
                }
                case "data_start_time": {
                    dataStartTime = ParseUtils.toInstant(parser);
                    continue block44;
                }
                case "data_end_time": {
                    dataEndTime = ParseUtils.toInstant(parser);
                    continue block44;
                }
                case "execution_start_time": {
                    executionStartTime = ParseUtils.toInstant(parser);
                    continue block44;
                }
                case "execution_end_time": {
                    executionEndTime = ParseUtils.toInstant(parser);
                    continue block44;
                }
                case "error": {
                    error = parser.text();
                    continue block44;
                }
                case "entity": {
                    entity = Entity.parse(parser);
                    continue block44;
                }
                case "user": {
                    user = User.parse((XContentParser)parser);
                    continue block44;
                }
                case "schema_version": {
                    schemaVersion = parser.intValue();
                    continue block44;
                }
                case "task_id": {
                    taskId = parser.text();
                    continue block44;
                }
                case "model_id": {
                    modelId = parser.text();
                    continue block44;
                }
                case "approx_anomaly_start_time": {
                    approAnomalyStartTime = ParseUtils.toInstant(parser);
                    continue block44;
                }
                case "relevant_attribution": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        relavantAttribution.add(DataByFeatureId.parse(parser));
                    }
                    continue block44;
                }
                case "past_values": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        pastValues.add(DataByFeatureId.parse(parser));
                    }
                    continue block44;
                }
                case "expected_values": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        expectedValues.add(ExpectedValueList.parse(parser));
                    }
                    continue block44;
                }
                case "threshold": {
                    threshold = parser.doubleValue();
                    continue block44;
                }
            }
            parser.skipChildren();
        }
        return new AnomalyResult(detectorId, taskId, anomalyScore, anomalyGrade, confidence, featureData, dataStartTime, dataEndTime, executionStartTime, executionEndTime, error, Optional.ofNullable(entity), user, schemaVersion, modelId, approAnomalyStartTime, relavantAttribution, pastValues, expectedValues, threshold);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        AnomalyResult that = (AnomalyResult)o;
        return Objects.equal((Object)this.modelId, (Object)that.modelId) && Objects.equal((Object)this.confidence, (Object)that.confidence) && Objects.equal((Object)this.anomalyScore, (Object)that.anomalyScore) && Objects.equal((Object)this.anomalyGrade, (Object)that.anomalyGrade) && Objects.equal((Object)this.approxAnomalyStartTime, (Object)that.approxAnomalyStartTime) && Objects.equal(this.relevantAttribution, that.relevantAttribution) && Objects.equal(this.pastValues, that.pastValues) && Objects.equal(this.expectedValuesList, that.expectedValuesList) && Objects.equal((Object)this.threshold, (Object)that.threshold);
    }

    @Override
    @Generated
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode((Object[])new Object[]{this.modelId, this.confidence, this.anomalyScore, this.anomalyGrade, this.approxAnomalyStartTime, this.relevantAttribution, this.pastValues, this.expectedValuesList, this.threshold});
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return super.toString() + ", " + new ToStringBuilder((Object)this).append("modelId", (Object)this.modelId).append("confidence", (Object)this.confidence).append("anomalyScore", (Object)this.anomalyScore).append("anomalyGrade", (Object)this.anomalyGrade).append("approAnomalyStartTime", (Object)this.approxAnomalyStartTime).append("relavantAttribution", this.relevantAttribution).append("pastValues", this.pastValues).append("expectedValuesList", (Object)StringUtils.join(this.expectedValuesList, (String)"|")).append(THRESHOLD_FIELD, (Object)this.threshold).toString();
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public String getDetectorId() {
        return this.configId;
    }

    public Double getAnomalyScore() {
        return this.anomalyScore;
    }

    public Double getAnomalyGrade() {
        return this.anomalyGrade;
    }

    public Instant getApproAnomalyStartTime() {
        return this.approxAnomalyStartTime;
    }

    public List<DataByFeatureId> getRelavantAttribution() {
        return this.relevantAttribution;
    }

    public List<DataByFeatureId> getPastValues() {
        return this.pastValues;
    }

    public List<ExpectedValueList> getExpectedValuesList() {
        return this.expectedValuesList;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public String getModelId() {
        return this.modelId;
    }

    @Override
    public boolean isHighPriority() {
        return this.getAnomalyGrade() != null && this.getAnomalyGrade() > 0.0 || this.getError() != null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.modelId);
        out.writeDouble(this.confidence.doubleValue());
        out.writeDouble(this.anomalyScore.doubleValue());
        out.writeDouble(this.anomalyGrade.doubleValue());
        out.writeOptionalInstant(this.approxAnomalyStartTime);
        if (this.relevantAttribution != null) {
            out.writeVInt(this.relevantAttribution.size());
            for (DataByFeatureId dataByFeatureId : this.relevantAttribution) {
                dataByFeatureId.writeTo(out);
            }
        } else {
            out.writeVInt(0);
        }
        if (this.pastValues != null) {
            out.writeVInt(this.pastValues.size());
            for (DataByFeatureId dataByFeatureId : this.pastValues) {
                dataByFeatureId.writeTo(out);
            }
        } else {
            out.writeVInt(0);
        }
        if (this.expectedValuesList != null) {
            out.writeVInt(this.expectedValuesList.size());
            for (ExpectedValueList expectedValueList : this.expectedValuesList) {
                expectedValueList.writeTo(out);
            }
        } else {
            out.writeVInt(0);
        }
        out.writeOptionalDouble(this.threshold);
    }

    public static AnomalyResult getDummyResult() {
        return new AnomalyResult("dummy_detector_id", null, null, null, null, null, null, null, Optional.empty(), null, CommonValue.NO_SCHEMA_VERSION, null);
    }
}

