/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.jni;

import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.opensearch.common.Nullable;
import org.opensearch.knn.index.IndexUtil;
import org.opensearch.knn.index.query.KNNQueryResult;
import org.opensearch.knn.index.util.KNNEngine;
import org.opensearch.knn.jni.FaissService;
import org.opensearch.knn.jni.NmslibService;

public class JNIService {
    public static void createIndex(int[] ids, long vectorsAddress, int dim, String indexPath, Map<String, Object> parameters, KNNEngine knnEngine) {
        if (KNNEngine.NMSLIB == knnEngine) {
            NmslibService.createIndex(ids, vectorsAddress, dim, indexPath, parameters);
            return;
        }
        if (KNNEngine.FAISS == knnEngine) {
            if (IndexUtil.isBinaryIndex(knnEngine, parameters)) {
                FaissService.createBinaryIndex(ids, vectorsAddress, dim, indexPath, parameters);
            } else {
                FaissService.createIndex(ids, vectorsAddress, dim, indexPath, parameters);
            }
            return;
        }
        throw new IllegalArgumentException(String.format("CreateIndex not supported for provided engine : %s", knnEngine.getName()));
    }

    public static void createIndexFromTemplate(int[] ids, long vectorsAddress, int dim, String indexPath, byte[] templateIndex, Map<String, Object> parameters, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            if (IndexUtil.isBinaryIndex(knnEngine, parameters)) {
                FaissService.createBinaryIndexFromTemplate(ids, vectorsAddress, dim, indexPath, templateIndex, parameters);
                return;
            }
            FaissService.createIndexFromTemplate(ids, vectorsAddress, dim, indexPath, templateIndex, parameters);
            return;
        }
        throw new IllegalArgumentException(String.format("CreateIndexFromTemplate not supported for provided engine : %s", knnEngine.getName()));
    }

    public static long loadIndex(String indexPath, Map<String, Object> parameters, KNNEngine knnEngine) {
        if (KNNEngine.NMSLIB == knnEngine) {
            return NmslibService.loadIndex(indexPath, parameters);
        }
        if (KNNEngine.FAISS == knnEngine) {
            if (IndexUtil.isBinaryIndex(knnEngine, parameters)) {
                return FaissService.loadBinaryIndex(indexPath);
            }
            return FaissService.loadIndex(indexPath);
        }
        throw new IllegalArgumentException(String.format("LoadIndex not supported for provided engine : %s", knnEngine.getName()));
    }

    public static boolean isSharedIndexStateRequired(long indexAddr, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            return FaissService.isSharedIndexStateRequired(indexAddr);
        }
        return false;
    }

    public static long initSharedIndexState(long indexAddr, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            return FaissService.initSharedIndexState(indexAddr);
        }
        throw new IllegalArgumentException(String.format("InitSharedIndexState not supported for provided engine : %s", knnEngine.getName()));
    }

    public static void setSharedIndexState(long indexAddr, long shareIndexStateAddr, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            FaissService.setSharedIndexState(indexAddr, shareIndexStateAddr);
            return;
        }
        throw new IllegalArgumentException(String.format("SetSharedIndexState not supported for provided engine : %s", knnEngine.getName()));
    }

    public static KNNQueryResult[] queryIndex(long indexPointer, float[] queryVector, int k, @Nullable Map<String, ?> methodParameters, KNNEngine knnEngine, long[] filteredIds, int filterIdsType, int[] parentIds) {
        if (KNNEngine.NMSLIB == knnEngine) {
            return NmslibService.queryIndex(indexPointer, queryVector, k, methodParameters);
        }
        if (KNNEngine.FAISS == knnEngine) {
            if (ArrayUtils.isNotEmpty((long[])filteredIds)) {
                return FaissService.queryIndexWithFilter(indexPointer, queryVector, k, methodParameters, filteredIds, filterIdsType, parentIds);
            }
            return FaissService.queryIndex(indexPointer, queryVector, k, methodParameters, parentIds);
        }
        throw new IllegalArgumentException(String.format("QueryIndex not supported for provided engine : %s", knnEngine.getName()));
    }

    public static KNNQueryResult[] queryBinaryIndex(long indexPointer, byte[] queryVector, int k, @Nullable Map<String, ?> methodParameters, KNNEngine knnEngine, long[] filteredIds, int filterIdsType, int[] parentIds) {
        if (KNNEngine.FAISS == knnEngine) {
            return FaissService.queryBinaryIndexWithFilter(indexPointer, queryVector, k, methodParameters, ArrayUtils.isEmpty((long[])filteredIds) ? null : filteredIds, filterIdsType, parentIds);
        }
        throw new IllegalArgumentException(String.format("QueryBinaryIndex not supported for provided engine : %s", knnEngine.getName()));
    }

    public static void free(long indexPointer, KNNEngine knnEngine) {
        JNIService.free(indexPointer, knnEngine, false);
    }

    public static void free(long indexPointer, KNNEngine knnEngine, boolean isBinaryIndex) {
        if (KNNEngine.NMSLIB == knnEngine) {
            NmslibService.free(indexPointer);
            return;
        }
        if (KNNEngine.FAISS == knnEngine) {
            FaissService.free(indexPointer, isBinaryIndex);
            return;
        }
        throw new IllegalArgumentException(String.format("Free not supported for provided engine : %s", knnEngine.getName()));
    }

    public static void freeSharedIndexState(long shareIndexStateAddr, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            FaissService.freeSharedIndexState(shareIndexStateAddr);
            return;
        }
        throw new IllegalArgumentException(String.format("FreeSharedIndexState not supported for provided engine : %s", knnEngine.getName()));
    }

    public static byte[] trainIndex(Map<String, Object> indexParameters, int dimension, long trainVectorsPointer, KNNEngine knnEngine) {
        if (KNNEngine.FAISS == knnEngine) {
            if (IndexUtil.isBinaryIndex(knnEngine, indexParameters)) {
                return FaissService.trainBinaryIndex(indexParameters, dimension, trainVectorsPointer);
            }
            return FaissService.trainIndex(indexParameters, dimension, trainVectorsPointer);
        }
        throw new IllegalArgumentException(String.format("TrainIndex not supported for provided engine : %s", knnEngine.getName()));
    }

    @Deprecated(since="2.14.0", forRemoval=true)
    public static long transferVectors(long vectorsPointer, float[][] trainingData) {
        return FaissService.transferVectors(vectorsPointer, trainingData);
    }

    public static KNNQueryResult[] radiusQueryIndex(long indexPointer, float[] queryVector, float radius, @Nullable Map<String, ?> methodParameters, KNNEngine knnEngine, int indexMaxResultWindow, long[] filteredIds, int filterIdsType, int[] parentIds) {
        if (KNNEngine.FAISS == knnEngine) {
            if (ArrayUtils.isNotEmpty((long[])filteredIds)) {
                return FaissService.rangeSearchIndexWithFilter(indexPointer, queryVector, radius, methodParameters, indexMaxResultWindow, filteredIds, filterIdsType, parentIds);
            }
            return FaissService.rangeSearchIndex(indexPointer, queryVector, radius, methodParameters, indexMaxResultWindow, parentIds);
        }
        throw new IllegalArgumentException("RadiusQueryIndex not supported for provided engine");
    }
}

