/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.filtered;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.query.filtered.KNNIterator;

public class FilteredIdsKNNByteIterator
implements KNNIterator {
    protected final BitSet filterIdsBitSet;
    protected final BitSetIterator bitSetIterator;
    protected final byte[] queryVector;
    protected final BinaryDocValues binaryDocValues;
    protected final SpaceType spaceType;
    protected float currentScore = Float.NEGATIVE_INFINITY;
    protected int docId;

    public FilteredIdsKNNByteIterator(BitSet filterIdsBitSet, byte[] queryVector, BinaryDocValues binaryDocValues, SpaceType spaceType) {
        this.filterIdsBitSet = filterIdsBitSet;
        this.bitSetIterator = new BitSetIterator(filterIdsBitSet, (long)filterIdsBitSet.length());
        this.queryVector = queryVector;
        this.binaryDocValues = binaryDocValues;
        this.spaceType = spaceType;
        this.docId = this.bitSetIterator.nextDoc();
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.docId == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int doc = this.binaryDocValues.advance(this.docId);
        this.currentScore = this.computeScore();
        this.docId = this.bitSetIterator.nextDoc();
        return doc;
    }

    @Override
    public float score() {
        return this.currentScore;
    }

    protected float computeScore() throws IOException {
        BytesRef value = this.binaryDocValues.binaryValue();
        ByteArrayInputStream byteStream = new ByteArrayInputStream(value.bytes, value.offset, value.length);
        byte[] vector = byteStream.readAllBytes();
        return this.spaceType.getKnnVectorSimilarityFunction().compare(this.queryVector, vector);
    }
}

