/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.opensearch.Version;
import org.opensearch.common.ValidationException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.knn.index.MethodComponentContext;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.util.KNNEngine;
import org.opensearch.knn.training.VectorSpaceInfo;

public class KNNMethodContext
implements ToXContentFragment,
Writeable {
    private static KNNMethodContext defaultInstance = null;
    @NonNull
    private final KNNEngine knnEngine;
    @NonNull
    private SpaceType spaceType;
    @NonNull
    private final MethodComponentContext methodComponentContext;

    public static synchronized KNNMethodContext getDefault() {
        if (defaultInstance == null) {
            MethodComponentContext methodComponentContext = new MethodComponentContext("hnsw", Collections.emptyMap());
            methodComponentContext.setIndexVersion(Version.CURRENT);
            defaultInstance = new KNNMethodContext(KNNEngine.DEFAULT, SpaceType.DEFAULT, methodComponentContext);
        }
        return defaultInstance;
    }

    public KNNMethodContext(StreamInput in) throws IOException {
        this.knnEngine = KNNEngine.getEngine(in.readString());
        this.spaceType = SpaceType.getSpace(in.readString());
        this.methodComponentContext = new MethodComponentContext(in);
    }

    public ValidationException validate() {
        return this.knnEngine.validateMethod(this);
    }

    public ValidationException validateWithData(VectorSpaceInfo vectorSpaceInfo) {
        return this.knnEngine.validateMethodWithData(this, vectorSpaceInfo);
    }

    public boolean isTrainingRequired() {
        return this.knnEngine.isTrainingRequired(this);
    }

    public int estimateOverheadInKB(int dimension) {
        return this.knnEngine.estimateOverheadInKB(this, dimension);
    }

    public static KNNMethodContext parse(Object in) {
        if (!(in instanceof Map)) {
            throw new MapperParsingException("Unable to parse mapping into KNNMethodContext. Object not of type \"Map\"");
        }
        Map methodMap = (Map)in;
        KNNEngine engine = KNNEngine.DEFAULT;
        SpaceType spaceType = SpaceType.UNDEFINED;
        String name = "";
        Map<String, Object> parameters = new HashMap<String, Object>();
        for (Map.Entry methodEntry : methodMap.entrySet()) {
            String key = (String)methodEntry.getKey();
            Object value = methodEntry.getValue();
            if ("engine".equals(key)) {
                if (value != null && !(value instanceof String)) {
                    throw new MapperParsingException("\"engine\" must be a string");
                }
                if (value == null) continue;
                try {
                    engine = KNNEngine.getEngine((String)value);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    throw new MapperParsingException("Invalid engine: " + String.valueOf(value));
                }
            }
            if ("space_type".equals(key)) {
                if (value != null && !(value instanceof String)) {
                    throw new MapperParsingException("\"space_type\" must be a string");
                }
                try {
                    spaceType = SpaceType.getSpace((String)value);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    throw new MapperParsingException("Invalid space_type: " + String.valueOf(value));
                }
            }
            if ("name".equals(key)) {
                if (!(value instanceof String)) {
                    throw new MapperParsingException("namehas to be a string");
                }
                name = (String)value;
                continue;
            }
            if ("parameters".equals(key)) {
                if (value == null) {
                    parameters = null;
                    continue;
                }
                if (!(value instanceof Map)) {
                    throw new MapperParsingException("Unable to parse parameters for main method component");
                }
                Map<String, Object> parameters1 = ((Map)value).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                    Object v = e.getValue();
                    if (v instanceof Map) {
                        return MethodComponentContext.parse(v);
                    }
                    return v;
                }));
                parameters = parameters1;
                continue;
            }
            throw new MapperParsingException("Invalid parameter: " + key);
        }
        if (name.isEmpty()) {
            throw new MapperParsingException("name needs to be set");
        }
        MethodComponentContext method = new MethodComponentContext(name, parameters);
        return new KNNMethodContext(engine, spaceType, method);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("engine", this.knnEngine.getName());
        builder.field("space_type", this.spaceType.getValue());
        builder = this.methodComponentContext.toXContent(builder, params);
        return builder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KNNMethodContext other = (KNNMethodContext)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.knnEngine, (Object)other.knnEngine);
        equalsBuilder.append((Object)this.spaceType, (Object)other.spaceType);
        equalsBuilder.append((Object)this.methodComponentContext, (Object)other.methodComponentContext);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.knnEngine).append((Object)this.spaceType).append((Object)this.methodComponentContext).toHashCode();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.knnEngine.getName());
        out.writeString(this.spaceType.getValue());
        this.methodComponentContext.writeTo(out);
    }

    @Generated
    public KNNMethodContext(@NonNull KNNEngine knnEngine, @NonNull SpaceType spaceType, @NonNull MethodComponentContext methodComponentContext) {
        if (knnEngine == null) {
            throw new NullPointerException("knnEngine is marked non-null but is null");
        }
        if (spaceType == null) {
            throw new NullPointerException("spaceType is marked non-null but is null");
        }
        if (methodComponentContext == null) {
            throw new NullPointerException("methodComponentContext is marked non-null but is null");
        }
        this.knnEngine = knnEngine;
        this.spaceType = spaceType;
        this.methodComponentContext = methodComponentContext;
    }

    @NonNull
    @Generated
    public KNNEngine getKnnEngine() {
        return this.knnEngine;
    }

    @NonNull
    @Generated
    public SpaceType getSpaceType() {
        return this.spaceType;
    }

    @NonNull
    @Generated
    public MethodComponentContext getMethodComponentContext() {
        return this.methodComponentContext;
    }

    @Generated
    public void setSpaceType(@NonNull SpaceType spaceType) {
        if (spaceType == null) {
            throw new NullPointerException("spaceType is marked non-null but is null");
        }
        this.spaceType = spaceType;
    }
}

