/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.FutureUtils;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.exception.WorkflowStepException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.ml.common.MLTask;
import org.opensearch.threadpool.ThreadPool;

public abstract class AbstractRetryableWorkflowStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(AbstractRetryableWorkflowStep.class);
    private TimeValue retryDuration;
    private final MachineLearningNodeClient mlClient;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    private ThreadPool threadPool;

    protected AbstractRetryableWorkflowStep(ThreadPool threadPool, MachineLearningNodeClient mlClient, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, FlowFrameworkSettings flowFrameworkSettings) {
        this.threadPool = threadPool;
        this.retryDuration = flowFrameworkSettings.getRetryDuration();
        this.mlClient = mlClient;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
    }

    protected void retryableGetMlTask(String workflowId, String nodeId, PlainActionFuture<WorkflowData> future, String taskId, String workflowStep, ActionListener<MLTask> mlTaskListener) {
        CompletableFuture.runAsync(() -> {
            do {
                this.mlClient.getTask(taskId, ActionListener.wrap(response -> {
                    String resourceName = WorkflowResources.getResourceByWorkflowStep(this.getName());
                    String id = this.getResourceId((MLTask)response);
                    switch (response.getState()) {
                        case COMPLETED: {
                            try {
                                logger.info("{} successful for {} and {} {}", (Object)workflowStep, (Object)workflowId, (Object)resourceName, (Object)id);
                                this.flowFrameworkIndicesHandler.updateResourceInStateIndex(workflowId, nodeId, this.getName(), id, (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> {
                                    logger.info("successfully updated resources created in state index: {}", (Object)updateResponse.getIndex());
                                    mlTaskListener.onResponse(response);
                                }, exception -> {
                                    String errorMessage = "Failed to update new created " + nodeId + " resource " + this.getName() + " id " + id;
                                    logger.error(errorMessage, (Throwable)exception);
                                    mlTaskListener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                                }));
                            }
                            catch (Exception e) {
                                String errorMessage = "Failed to parse and update new created resource " + resourceName + " id " + id;
                                logger.error(errorMessage, (Throwable)e);
                                mlTaskListener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
                            }
                            break;
                        }
                        case FAILED: 
                        case COMPLETED_WITH_ERROR: {
                            String errorMessage = workflowStep + " failed with error : " + response.getError();
                            logger.error(errorMessage);
                            mlTaskListener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST)));
                            break;
                        }
                        case CANCELLED: {
                            String errorMessage = workflowStep + " task was cancelled.";
                            logger.error(errorMessage);
                            mlTaskListener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.REQUEST_TIMEOUT)));
                            break;
                        }
                    }
                }, exception -> {
                    String errorMessage = workflowStep + " failed";
                    logger.error(errorMessage, (Throwable)exception);
                    mlTaskListener.onFailure((Exception)((Object)new WorkflowStepException(errorMessage, RestStatus.BAD_REQUEST)));
                }));
                try {
                    Thread.sleep(this.retryDuration.getMillis());
                }
                catch (InterruptedException e) {
                    FutureUtils.cancel((Future)future);
                    Thread.currentThread().interrupt();
                }
            } while (!future.isDone());
        }, this.threadPool.executor("opensearch_workflow"));
    }

    protected abstract String getResourceId(MLTask var1);
}

