/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.transport.DeprovisionWorkflowAction;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;

public class RestDeprovisionWorkflowAction
extends BaseRestHandler {
    private static final String DEPROVISION_WORKFLOW_ACTION = "deprovision_workflow";
    private static final Logger logger = LogManager.getLogger(RestDeprovisionWorkflowAction.class);
    private final FlowFrameworkSettings flowFrameworkFeatureEnabledSetting;

    public RestDeprovisionWorkflowAction(FlowFrameworkSettings flowFrameworkFeatureEnabledSetting) {
        this.flowFrameworkFeatureEnabledSetting = flowFrameworkFeatureEnabledSetting;
    }

    public String getName() {
        return DEPROVISION_WORKFLOW_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String workflowId = request.param("workflow_id");
        String allowDelete = request.param("allow_delete");
        try {
            if (!this.flowFrameworkFeatureEnabledSetting.isFlowFrameworkEnabled()) {
                throw new FlowFrameworkException("This API is disabled. To enable it, update the setting [" + FlowFrameworkSettings.FLOW_FRAMEWORK_ENABLED.getKey() + "] to true.", RestStatus.FORBIDDEN);
            }
            request.content();
            if (workflowId == null) {
                throw new FlowFrameworkException("workflow_id cannot be null", RestStatus.BAD_REQUEST);
            }
            WorkflowRequest workflowRequest = new WorkflowRequest(workflowId, null, allowDelete == null ? Collections.emptyMap() : Map.of("allow_delete", allowDelete));
            return channel -> client.execute((ActionType)DeprovisionWorkflowAction.INSTANCE, (ActionRequest)workflowRequest, ActionListener.wrap(response -> {
                XContentBuilder builder = response.toXContent(channel.newBuilder(), ToXContent.EMPTY_PARAMS);
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
            }, exception -> {
                try {
                    FlowFrameworkException ex = exception instanceof FlowFrameworkException ? (FlowFrameworkException)((Object)((Object)((Object)exception))) : new FlowFrameworkException("Failed to get workflow.", ExceptionsHelper.status((Throwable)exception));
                    XContentBuilder exceptionBuilder = ex.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS);
                    channel.sendResponse((RestResponse)new BytesRestResponse(ex.getRestStatus(), exceptionBuilder));
                }
                catch (IOException e) {
                    String errorMessage = "IOException: Failed to send back deprovision workflow exception";
                    logger.error(errorMessage, (Throwable)e);
                    channel.sendResponse((RestResponse)new BytesRestResponse(ExceptionsHelper.status((Throwable)e), errorMessage));
                }
            }));
        }
        catch (FlowFrameworkException ex) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(ex.getRestStatus(), ex.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS)));
        }
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_flow_framework/workflow", "workflow_id", "_deprovision")));
    }
}

