/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.datetime;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprDatetimeValue;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.datetime.CalendarLookup;
import org.opensearch.sql.expression.datetime.DateTimeFormatterUtil;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.DefaultFunctionResolver;
import org.opensearch.sql.expression.function.FunctionDSL;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.function.SerializableFunction;
import org.opensearch.sql.expression.function.SerializableTriFunction;
import org.opensearch.sql.utils.DateTimeFormatters;
import org.opensearch.sql.utils.DateTimeUtils;

public final class DateTimeFunction {
    public static final long SECONDS_PER_DAY = 86400L;
    private static final Long DAYS_0000_TO_1970 = 719528L;
    private static final Double MYSQL_MAX_TIMESTAMP = 3.25367712E10;
    private static final ExprIntegerValue DEFAULT_WEEK_OF_YEAR_MODE = new ExprIntegerValue(0);
    private static final Map<String, String> extract_formats = ImmutableMap.builder().put((Object)"MICROSECOND", (Object)"SSSSSS").put((Object)"SECOND", (Object)"ss").put((Object)"MINUTE", (Object)"mm").put((Object)"HOUR", (Object)"HH").put((Object)"DAY", (Object)"dd").put((Object)"WEEK", (Object)"w").put((Object)"MONTH", (Object)"MM").put((Object)"YEAR", (Object)"yyyy").put((Object)"SECOND_MICROSECOND", (Object)"ssSSSSSS").put((Object)"MINUTE_MICROSECOND", (Object)"mmssSSSSSS").put((Object)"MINUTE_SECOND", (Object)"mmss").put((Object)"HOUR_MICROSECOND", (Object)"HHmmssSSSSSS").put((Object)"HOUR_SECOND", (Object)"HHmmss").put((Object)"HOUR_MINUTE", (Object)"HHmm").put((Object)"DAY_MICROSECOND", (Object)"ddHHmmssSSSSSS").put((Object)"DAY_SECOND", (Object)"ddHHmmss").put((Object)"DAY_MINUTE", (Object)"ddHHmm").put((Object)"DAY_HOUR", (Object)"ddHH").put((Object)"YEAR_MONTH", (Object)"yyyyMM").put((Object)"QUARTER", (Object)"Q").build();
    private static final Table<String, String, String> formats = ImmutableTable.builder().put((Object)"date", (Object)"usa", (Object)"%m.%d.%Y").put((Object)"date", (Object)"jis", (Object)"%Y-%m-%d").put((Object)"date", (Object)"iso", (Object)"%Y-%m-%d").put((Object)"date", (Object)"eur", (Object)"%d.%m.%Y").put((Object)"date", (Object)"internal", (Object)"%Y%m%d").put((Object)"datetime", (Object)"usa", (Object)"%Y-%m-%d %H.%i.%s").put((Object)"datetime", (Object)"jis", (Object)"%Y-%m-%d %H:%i:%s").put((Object)"datetime", (Object)"iso", (Object)"%Y-%m-%d %H:%i:%s").put((Object)"datetime", (Object)"eur", (Object)"%Y-%m-%d %H.%i.%s").put((Object)"datetime", (Object)"internal", (Object)"%Y%m%d%H%i%s").put((Object)"time", (Object)"usa", (Object)"%h:%i:%s %p").put((Object)"time", (Object)"jis", (Object)"%H:%i:%s").put((Object)"time", (Object)"iso", (Object)"%H:%i:%s").put((Object)"time", (Object)"eur", (Object)"%H.%i.%s").put((Object)"time", (Object)"internal", (Object)"%H%i%s").put((Object)"timestamp", (Object)"usa", (Object)"%Y-%m-%d %H.%i.%s").put((Object)"timestamp", (Object)"jis", (Object)"%Y-%m-%d %H:%i:%s").put((Object)"timestamp", (Object)"iso", (Object)"%Y-%m-%d %H:%i:%s").put((Object)"timestamp", (Object)"eur", (Object)"%Y-%m-%d %H.%i.%s").put((Object)"timestamp", (Object)"internal", (Object)"%Y%m%d%H%i%s").build();

    public static void register(BuiltinFunctionRepository repository) {
        repository.register(DateTimeFunction.adddate());
        repository.register(DateTimeFunction.addtime());
        repository.register(DateTimeFunction.convert_tz());
        repository.register(DateTimeFunction.curtime());
        repository.register(DateTimeFunction.curdate());
        repository.register(DateTimeFunction.current_date());
        repository.register(DateTimeFunction.current_time());
        repository.register(DateTimeFunction.current_timestamp());
        repository.register(DateTimeFunction.date());
        repository.register(DateTimeFunction.datediff());
        repository.register(DateTimeFunction.datetime());
        repository.register(DateTimeFunction.date_add());
        repository.register(DateTimeFunction.date_format());
        repository.register(DateTimeFunction.date_sub());
        repository.register(DateTimeFunction.day());
        repository.register(DateTimeFunction.dayName());
        repository.register(DateTimeFunction.dayOfMonth(BuiltinFunctionName.DAYOFMONTH));
        repository.register(DateTimeFunction.dayOfMonth(BuiltinFunctionName.DAY_OF_MONTH));
        repository.register(DateTimeFunction.dayOfWeek(BuiltinFunctionName.DAYOFWEEK.getName()));
        repository.register(DateTimeFunction.dayOfWeek(BuiltinFunctionName.DAY_OF_WEEK.getName()));
        repository.register(DateTimeFunction.dayOfYear(BuiltinFunctionName.DAYOFYEAR));
        repository.register(DateTimeFunction.dayOfYear(BuiltinFunctionName.DAY_OF_YEAR));
        repository.register(DateTimeFunction.extract());
        repository.register(DateTimeFunction.from_days());
        repository.register(DateTimeFunction.from_unixtime());
        repository.register(DateTimeFunction.get_format());
        repository.register(DateTimeFunction.hour(BuiltinFunctionName.HOUR));
        repository.register(DateTimeFunction.hour(BuiltinFunctionName.HOUR_OF_DAY));
        repository.register(DateTimeFunction.last_day());
        repository.register(DateTimeFunction.localtime());
        repository.register(DateTimeFunction.localtimestamp());
        repository.register(DateTimeFunction.makedate());
        repository.register(DateTimeFunction.maketime());
        repository.register(DateTimeFunction.microsecond());
        repository.register(DateTimeFunction.minute(BuiltinFunctionName.MINUTE));
        repository.register(DateTimeFunction.minute_of_day());
        repository.register(DateTimeFunction.minute(BuiltinFunctionName.MINUTE_OF_HOUR));
        repository.register(DateTimeFunction.month(BuiltinFunctionName.MONTH));
        repository.register(DateTimeFunction.month(BuiltinFunctionName.MONTH_OF_YEAR));
        repository.register(DateTimeFunction.monthName());
        repository.register(DateTimeFunction.now());
        repository.register(DateTimeFunction.period_add());
        repository.register(DateTimeFunction.period_diff());
        repository.register(DateTimeFunction.quarter());
        repository.register(DateTimeFunction.sec_to_time());
        repository.register(DateTimeFunction.second(BuiltinFunctionName.SECOND));
        repository.register(DateTimeFunction.second(BuiltinFunctionName.SECOND_OF_MINUTE));
        repository.register(DateTimeFunction.subdate());
        repository.register(DateTimeFunction.subtime());
        repository.register(DateTimeFunction.str_to_date());
        repository.register(DateTimeFunction.sysdate());
        repository.register(DateTimeFunction.time());
        repository.register(DateTimeFunction.time_format());
        repository.register(DateTimeFunction.time_to_sec());
        repository.register(DateTimeFunction.timediff());
        repository.register(DateTimeFunction.timestamp());
        repository.register(DateTimeFunction.timestampadd());
        repository.register(DateTimeFunction.timestampdiff());
        repository.register(DateTimeFunction.to_days());
        repository.register(DateTimeFunction.to_seconds());
        repository.register(DateTimeFunction.unix_timestamp());
        repository.register(DateTimeFunction.utc_date());
        repository.register(DateTimeFunction.utc_time());
        repository.register(DateTimeFunction.utc_timestamp());
        repository.register(DateTimeFunction.week(BuiltinFunctionName.WEEK));
        repository.register(DateTimeFunction.week(BuiltinFunctionName.WEEKOFYEAR));
        repository.register(DateTimeFunction.week(BuiltinFunctionName.WEEK_OF_YEAR));
        repository.register(DateTimeFunction.weekday());
        repository.register(DateTimeFunction.year());
        repository.register(DateTimeFunction.yearweek());
    }

    private static FunctionResolver now(FunctionName functionName) {
        return FunctionDSL.define(functionName, FunctionDSL.implWithProperties(functionProperties -> new ExprDatetimeValue(DateTimeFunction.formatNow(functionProperties.getQueryStartClock())), ExprCoreType.DATETIME));
    }

    private static FunctionResolver now() {
        return DateTimeFunction.now(BuiltinFunctionName.NOW.getName());
    }

    private static FunctionResolver current_timestamp() {
        return DateTimeFunction.now(BuiltinFunctionName.CURRENT_TIMESTAMP.getName());
    }

    private static FunctionResolver localtimestamp() {
        return DateTimeFunction.now(BuiltinFunctionName.LOCALTIMESTAMP.getName());
    }

    private static FunctionResolver localtime() {
        return DateTimeFunction.now(BuiltinFunctionName.LOCALTIME.getName());
    }

    private static FunctionResolver sysdate() {
        return FunctionDSL.define(BuiltinFunctionName.SYSDATE.getName(), FunctionDSL.implWithProperties(functionProperties -> new ExprDatetimeValue(DateTimeFunction.formatNow(Clock.systemDefaultZone())), ExprCoreType.DATETIME), FunctionDSL.implWithProperties((functionProperties, v) -> new ExprDatetimeValue(DateTimeFunction.formatNow(Clock.systemDefaultZone(), v.integerValue())), ExprCoreType.DATETIME, ExprCoreType.INTEGER));
    }

    private static FunctionResolver curtime(FunctionName functionName) {
        return FunctionDSL.define(functionName, FunctionDSL.implWithProperties(functionProperties -> new ExprTimeValue(DateTimeFunction.formatNow(functionProperties.getQueryStartClock()).toLocalTime()), ExprCoreType.TIME));
    }

    private static FunctionResolver curtime() {
        return DateTimeFunction.curtime(BuiltinFunctionName.CURTIME.getName());
    }

    private static FunctionResolver current_time() {
        return DateTimeFunction.curtime(BuiltinFunctionName.CURRENT_TIME.getName());
    }

    private static FunctionResolver curdate(FunctionName functionName) {
        return FunctionDSL.define(functionName, FunctionDSL.implWithProperties(functionProperties -> new ExprDateValue(DateTimeFunction.formatNow(functionProperties.getQueryStartClock()).toLocalDate()), ExprCoreType.DATE));
    }

    private static FunctionResolver curdate() {
        return DateTimeFunction.curdate(BuiltinFunctionName.CURDATE.getName());
    }

    private static FunctionResolver current_date() {
        return DateTimeFunction.curdate(BuiltinFunctionName.CURRENT_DATE.getName());
    }

    private static Stream<SerializableFunction<?, ?>> get_date_add_date_sub_signatures(SerializableTriFunction<FunctionProperties, ExprValue, ExprValue, ExprValue> function) {
        return Stream.of(FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(function), ExprCoreType.DATETIME, ExprCoreType.DATE, ExprCoreType.INTERVAL), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(function), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.INTERVAL), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(function), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.INTERVAL), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(function), ExprCoreType.DATETIME, ExprCoreType.TIME, ExprCoreType.INTERVAL));
    }

    private static Stream<SerializableFunction<?, ?>> get_adddate_subdate_signatures(SerializableTriFunction<FunctionProperties, ExprValue, ExprValue, ExprValue> function) {
        return Stream.of(FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(function), ExprCoreType.DATE, ExprCoreType.DATE, ExprCoreType.LONG), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(function), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.LONG), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(function), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.LONG), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(function), ExprCoreType.DATETIME, ExprCoreType.TIME, ExprCoreType.LONG));
    }

    private static DefaultFunctionResolver adddate() {
        return FunctionDSL.define(BuiltinFunctionName.ADDDATE.getName(), (SerializableFunction[])Stream.concat(DateTimeFunction.get_date_add_date_sub_signatures(DateTimeFunction::exprAddDateInterval), DateTimeFunction.get_adddate_subdate_signatures(DateTimeFunction::exprAddDateDays)).toArray(SerializableFunction[]::new));
    }

    private static DefaultFunctionResolver addtime() {
        return FunctionDSL.define(BuiltinFunctionName.ADDTIME.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprAddTime), ExprCoreType.TIME, ExprCoreType.TIME, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprAddTime), ExprCoreType.TIME, ExprCoreType.TIME, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprAddTime), ExprCoreType.TIME, ExprCoreType.TIME, ExprCoreType.DATETIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprAddTime), ExprCoreType.TIME, ExprCoreType.TIME, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprAddTime), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprAddTime), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprAddTime), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.DATETIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprAddTime), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprAddTime), ExprCoreType.DATETIME, ExprCoreType.DATE, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprAddTime), ExprCoreType.DATETIME, ExprCoreType.DATE, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprAddTime), ExprCoreType.DATETIME, ExprCoreType.DATE, ExprCoreType.DATETIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprAddTime), ExprCoreType.DATETIME, ExprCoreType.DATE, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprAddTime), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprAddTime), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprAddTime), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.DATETIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprAddTime), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver convert_tz() {
        return FunctionDSL.define(BuiltinFunctionName.CONVERT_TZ.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprConvertTZ), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprConvertTZ), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver date() {
        return FunctionDSL.define(BuiltinFunctionName.DATE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDate), ExprCoreType.DATE, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDate), ExprCoreType.DATE, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDate), ExprCoreType.DATE, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDate), ExprCoreType.DATE, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver datediff() {
        return FunctionDSL.define(BuiltinFunctionName.DATEDIFF.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprDateDiff), ExprCoreType.LONG, ExprCoreType.DATE, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprDateDiff), ExprCoreType.LONG, ExprCoreType.DATETIME, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprDateDiff), ExprCoreType.LONG, ExprCoreType.DATE, ExprCoreType.DATETIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprDateDiff), ExprCoreType.LONG, ExprCoreType.DATETIME, ExprCoreType.DATETIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprDateDiff), ExprCoreType.LONG, ExprCoreType.DATE, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprDateDiff), ExprCoreType.LONG, ExprCoreType.TIME, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprDateDiff), ExprCoreType.LONG, ExprCoreType.TIME, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprDateDiff), ExprCoreType.LONG, ExprCoreType.TIMESTAMP, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprDateDiff), ExprCoreType.LONG, ExprCoreType.DATE, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprDateDiff), ExprCoreType.LONG, ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprDateDiff), ExprCoreType.LONG, ExprCoreType.TIMESTAMP, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprDateDiff), ExprCoreType.LONG, ExprCoreType.TIME, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprDateDiff), ExprCoreType.LONG, ExprCoreType.TIMESTAMP, ExprCoreType.DATETIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprDateDiff), ExprCoreType.LONG, ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprDateDiff), ExprCoreType.LONG, ExprCoreType.TIME, ExprCoreType.DATETIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprDateDiff), ExprCoreType.LONG, ExprCoreType.DATETIME, ExprCoreType.TIME));
    }

    private static FunctionResolver datetime() {
        return FunctionDSL.define(BuiltinFunctionName.DATETIME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDateTime), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDateTimeNoTimezone), ExprCoreType.DATETIME, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver date_add() {
        return FunctionDSL.define(BuiltinFunctionName.DATE_ADD.getName(), (SerializableFunction[])DateTimeFunction.get_date_add_date_sub_signatures(DateTimeFunction::exprAddDateInterval).toArray(SerializableFunction[]::new));
    }

    private static DefaultFunctionResolver date_sub() {
        return FunctionDSL.define(BuiltinFunctionName.DATE_SUB.getName(), (SerializableFunction[])DateTimeFunction.get_date_add_date_sub_signatures(DateTimeFunction::exprSubDateInterval).toArray(SerializableFunction[]::new));
    }

    private static DefaultFunctionResolver day() {
        return FunctionDSL.define(BuiltinFunctionName.DAY.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver dayName() {
        return FunctionDSL.define(BuiltinFunctionName.DAYNAME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayName), ExprCoreType.STRING, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayName), ExprCoreType.STRING, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayName), ExprCoreType.STRING, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayName), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver dayOfMonth(BuiltinFunctionName name) {
        return FunctionDSL.define(name.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg) -> DateTimeFunction.dayOfMonthToday(functionProperties.getQueryStartClock())), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfMonth), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver dayOfWeek(FunctionName name) {
        return FunctionDSL.define(name, FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg) -> DateTimeFunction.dayOfWeekToday(functionProperties.getQueryStartClock())), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfWeek), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfWeek), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfWeek), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfWeek), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver dayOfYear(BuiltinFunctionName dayOfYear) {
        return FunctionDSL.define(dayOfYear.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg) -> DateTimeFunction.dayOfYearToday(functionProperties.getQueryStartClock())), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfYear), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfYear), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfYear), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprDayOfYear), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver extract() {
        return FunctionDSL.define(BuiltinFunctionName.EXTRACT.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprExtractForTime), ExprCoreType.LONG, ExprCoreType.STRING, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprExtract), ExprCoreType.LONG, ExprCoreType.STRING, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprExtract), ExprCoreType.LONG, ExprCoreType.STRING, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprExtract), ExprCoreType.LONG, ExprCoreType.STRING, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprExtract), ExprCoreType.LONG, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver from_days() {
        return FunctionDSL.define(BuiltinFunctionName.FROM_DAYS.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprFromDays), ExprCoreType.DATE, ExprCoreType.LONG));
    }

    private static FunctionResolver from_unixtime() {
        return FunctionDSL.define(BuiltinFunctionName.FROM_UNIXTIME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprFromUnixTime), ExprCoreType.DATETIME, ExprCoreType.DOUBLE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprFromUnixTimeFormat), ExprCoreType.STRING, ExprCoreType.DOUBLE, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver get_format() {
        return FunctionDSL.define(BuiltinFunctionName.GET_FORMAT.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprGetFormat), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver hour(BuiltinFunctionName name) {
        return FunctionDSL.define(name.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprHour), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprHour), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprHour), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprHour), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprHour), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver last_day() {
        return FunctionDSL.define(BuiltinFunctionName.LAST_DAY.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprLastDay), ExprCoreType.DATE, ExprCoreType.STRING), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg) -> DateTimeFunction.exprLastDayToday(functionProperties.getQueryStartClock())), ExprCoreType.DATE, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprLastDay), ExprCoreType.DATE, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprLastDay), ExprCoreType.DATE, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprLastDay), ExprCoreType.DATE, ExprCoreType.TIMESTAMP));
    }

    private static FunctionResolver makedate() {
        return FunctionDSL.define(BuiltinFunctionName.MAKEDATE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMakeDate), ExprCoreType.DATE, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    private static FunctionResolver maketime() {
        return FunctionDSL.define(BuiltinFunctionName.MAKETIME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMakeTime), ExprCoreType.TIME, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver microsecond() {
        return FunctionDSL.define(BuiltinFunctionName.MICROSECOND.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMicrosecond), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMicrosecond), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMicrosecond), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMicrosecond), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver minute(BuiltinFunctionName name) {
        return FunctionDSL.define(name.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinute), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinute), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinute), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinute), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinute), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver minute_of_day() {
        return FunctionDSL.define(BuiltinFunctionName.MINUTE_OF_DAY.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinuteOfDay), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinuteOfDay), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinuteOfDay), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinuteOfDay), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMinuteOfDay), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver month(BuiltinFunctionName month) {
        return FunctionDSL.define(month.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg) -> DateTimeFunction.monthOfYearToday(functionProperties.getQueryStartClock())), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonth), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonth), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonth), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonth), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver monthName() {
        return FunctionDSL.define(BuiltinFunctionName.MONTHNAME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonthName), ExprCoreType.STRING, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonthName), ExprCoreType.STRING, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonthName), ExprCoreType.STRING, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprMonthName), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver period_add() {
        return FunctionDSL.define(BuiltinFunctionName.PERIOD_ADD.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprPeriodAdd), ExprCoreType.INTEGER, ExprCoreType.INTEGER, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver period_diff() {
        return FunctionDSL.define(BuiltinFunctionName.PERIOD_DIFF.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprPeriodDiff), ExprCoreType.INTEGER, ExprCoreType.INTEGER, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver quarter() {
        return FunctionDSL.define(BuiltinFunctionName.QUARTER.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprQuarter), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprQuarter), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprQuarter), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprQuarter), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver sec_to_time() {
        return FunctionDSL.define(BuiltinFunctionName.SEC_TO_TIME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecToTime), ExprCoreType.TIME, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecToTime), ExprCoreType.TIME, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecToTimeWithNanos), ExprCoreType.TIME, ExprCoreType.DOUBLE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecToTimeWithNanos), ExprCoreType.TIME, ExprCoreType.FLOAT));
    }

    private static DefaultFunctionResolver second(BuiltinFunctionName name) {
        return FunctionDSL.define(name.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecond), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecond), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecond), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecond), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprSecond), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver subdate() {
        return FunctionDSL.define(BuiltinFunctionName.SUBDATE.getName(), (SerializableFunction[])Stream.concat(DateTimeFunction.get_date_add_date_sub_signatures(DateTimeFunction::exprSubDateInterval), DateTimeFunction.get_adddate_subdate_signatures(DateTimeFunction::exprSubDateDays)).toArray(SerializableFunction[]::new));
    }

    private static DefaultFunctionResolver subtime() {
        return FunctionDSL.define(BuiltinFunctionName.SUBTIME.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprSubTime), ExprCoreType.TIME, ExprCoreType.TIME, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprSubTime), ExprCoreType.TIME, ExprCoreType.TIME, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprSubTime), ExprCoreType.TIME, ExprCoreType.TIME, ExprCoreType.DATETIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprSubTime), ExprCoreType.TIME, ExprCoreType.TIME, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprSubTime), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprSubTime), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprSubTime), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.DATETIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprSubTime), ExprCoreType.DATETIME, ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprSubTime), ExprCoreType.DATETIME, ExprCoreType.DATE, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprSubTime), ExprCoreType.DATETIME, ExprCoreType.DATE, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprSubTime), ExprCoreType.DATETIME, ExprCoreType.DATE, ExprCoreType.DATETIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprSubTime), ExprCoreType.DATETIME, ExprCoreType.DATE, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprSubTime), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.TIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprSubTime), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprSubTime), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.DATETIME), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties(DateTimeFunction::exprSubTime), ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver str_to_date() {
        return FunctionDSL.define(BuiltinFunctionName.STR_TO_DATE.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg, format) -> DateTimeFunction.exprStrToDate(functionProperties, arg, format)), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver time() {
        return FunctionDSL.define(BuiltinFunctionName.TIME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTime), ExprCoreType.TIME, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTime), ExprCoreType.TIME, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTime), ExprCoreType.TIME, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTime), ExprCoreType.TIME, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTime), ExprCoreType.TIME, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver timediff() {
        return FunctionDSL.define(BuiltinFunctionName.TIMEDIFF.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimeDiff), ExprCoreType.TIME, ExprCoreType.TIME, ExprCoreType.TIME));
    }

    private static DefaultFunctionResolver time_to_sec() {
        return FunctionDSL.define(BuiltinFunctionName.TIME_TO_SEC.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimeToSec), ExprCoreType.LONG, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimeToSec), ExprCoreType.LONG, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimeToSec), ExprCoreType.LONG, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimeToSec), ExprCoreType.LONG, ExprCoreType.DATETIME));
    }

    private static DefaultFunctionResolver timestamp() {
        return FunctionDSL.define(BuiltinFunctionName.TIMESTAMP.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v), ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> DateTimeFunction.exprAddTime(FunctionProperties.None, v1, v2)), ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP));
    }

    private static DefaultFunctionResolver timestampadd() {
        return FunctionDSL.define(BuiltinFunctionName.TIMESTAMPADD.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimestampAdd), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimestampAdd), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, part, amount, time) -> DateTimeFunction.exprTimestampAddForTimeType(functionProperties.getQueryStartClock(), part, amount, time)), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.INTEGER, ExprCoreType.TIME));
    }

    private static DefaultFunctionResolver timestampdiff() {
        return FunctionDSL.define(BuiltinFunctionName.TIMESTAMPDIFF.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimestampDiff), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.DATETIME, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimestampDiff), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.DATETIME, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimestampDiff), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.TIMESTAMP, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprTimestampDiff), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, part, startTime, endTime) -> DateTimeFunction.exprTimestampDiffForTimeType(functionProperties, part, startTime, endTime)), ExprCoreType.DATETIME, ExprCoreType.STRING, ExprCoreType.TIME, ExprCoreType.TIME));
    }

    private static DefaultFunctionResolver to_days() {
        return FunctionDSL.define(BuiltinFunctionName.TO_DAYS.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprToDays), ExprCoreType.LONG, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprToDays), ExprCoreType.LONG, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprToDays), ExprCoreType.LONG, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprToDays), ExprCoreType.LONG, ExprCoreType.DATETIME));
    }

    private static DefaultFunctionResolver to_seconds() {
        return FunctionDSL.define(BuiltinFunctionName.TO_SECONDS.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprToSeconds), ExprCoreType.LONG, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprToSecondsForIntType), ExprCoreType.LONG, ExprCoreType.LONG));
    }

    private static FunctionResolver unix_timestamp() {
        return FunctionDSL.define(BuiltinFunctionName.UNIX_TIMESTAMP.getName(), FunctionDSL.implWithProperties(functionProperties -> DateTimeFunction.unixTimeStamp(functionProperties.getQueryStartClock()), ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::unixTimeStampOf), ExprCoreType.DOUBLE, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::unixTimeStampOf), ExprCoreType.DOUBLE, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::unixTimeStampOf), ExprCoreType.DOUBLE, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::unixTimeStampOf), ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver utc_date() {
        return FunctionDSL.define(BuiltinFunctionName.UTC_DATE.getName(), FunctionDSL.implWithProperties(functionProperties -> DateTimeFunction.exprUtcDate(functionProperties), ExprCoreType.DATE));
    }

    private static DefaultFunctionResolver utc_time() {
        return FunctionDSL.define(BuiltinFunctionName.UTC_TIME.getName(), FunctionDSL.implWithProperties(functionProperties -> DateTimeFunction.exprUtcTime(functionProperties), ExprCoreType.TIME));
    }

    private static DefaultFunctionResolver utc_timestamp() {
        return FunctionDSL.define(BuiltinFunctionName.UTC_TIMESTAMP.getName(), FunctionDSL.implWithProperties(functionProperties -> DateTimeFunction.exprUtcTimeStamp(functionProperties), ExprCoreType.DATETIME));
    }

    private static DefaultFunctionResolver week(BuiltinFunctionName week) {
        return FunctionDSL.define(week.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg) -> DateTimeFunction.weekOfYearToday(DEFAULT_WEEK_OF_YEAR_MODE, functionProperties.getQueryStartClock())), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, time, modeArg) -> DateTimeFunction.weekOfYearToday(modeArg, functionProperties.getQueryStartClock())), ExprCoreType.INTEGER, ExprCoreType.TIME, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeek), ExprCoreType.INTEGER, ExprCoreType.DATE, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeek), ExprCoreType.INTEGER, ExprCoreType.DATETIME, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeek), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeek), ExprCoreType.INTEGER, ExprCoreType.STRING, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver weekday() {
        return FunctionDSL.define(BuiltinFunctionName.WEEKDAY.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg) -> new ExprIntegerValue(DateTimeFunction.formatNow(functionProperties.getQueryStartClock()).getDayOfWeek().getValue() - 1)), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeekday), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeekday), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeekday), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprWeekday), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver year() {
        return FunctionDSL.define(BuiltinFunctionName.YEAR.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYear), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYear), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYear), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYear), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver yearweek() {
        return FunctionDSL.define(BuiltinFunctionName.YEARWEEK.getName(), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, arg) -> DateTimeFunction.yearweekToday(DEFAULT_WEEK_OF_YEAR_MODE, functionProperties.getQueryStartClock())), ExprCoreType.INTEGER, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYearweekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.DATE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYearweekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.DATETIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYearweekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYearweekWithoutMode), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, time, modeArg) -> DateTimeFunction.yearweekToday(modeArg, functionProperties.getQueryStartClock())), ExprCoreType.INTEGER, ExprCoreType.TIME, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYearweek), ExprCoreType.INTEGER, ExprCoreType.DATE, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYearweek), ExprCoreType.INTEGER, ExprCoreType.DATETIME, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYearweek), ExprCoreType.INTEGER, ExprCoreType.TIMESTAMP, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFunction::exprYearweek), ExprCoreType.INTEGER, ExprCoreType.STRING, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver date_format() {
        return FunctionDSL.define(BuiltinFunctionName.DATE_FORMAT.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedDate), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedDate), ExprCoreType.STRING, ExprCoreType.DATE, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedDate), ExprCoreType.STRING, ExprCoreType.DATETIME, ExprCoreType.STRING), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((functionProperties, time, formatString) -> DateTimeFormatterUtil.getFormattedDateOfToday(formatString, time, functionProperties.getQueryStartClock())), ExprCoreType.STRING, ExprCoreType.TIME, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedDate), ExprCoreType.STRING, ExprCoreType.TIMESTAMP, ExprCoreType.STRING));
    }

    private static ExprValue dayOfMonthToday(Clock clock) {
        return new ExprIntegerValue(LocalDateTime.now(clock).getDayOfMonth());
    }

    private static ExprValue dayOfYearToday(Clock clock) {
        return new ExprIntegerValue(LocalDateTime.now(clock).getDayOfYear());
    }

    private static ExprValue weekOfYearToday(ExprValue mode, Clock clock) {
        return new ExprIntegerValue(CalendarLookup.getWeekNumber(mode.integerValue(), LocalDateTime.now(clock).toLocalDate()));
    }

    private static ExprValue dayOfWeekToday(Clock clock) {
        return new ExprIntegerValue(DateTimeFunction.formatNow(clock).getDayOfWeek().getValue() % 7 + 1);
    }

    private static ExprValue exprAddDateInterval(FunctionProperties functionProperties, ExprValue datetime, ExprValue interval) {
        return DateTimeFunction.exprDateApplyInterval(functionProperties, datetime, interval.intervalValue(), true);
    }

    private static ExprValue exprDateApplyInterval(FunctionProperties functionProperties, ExprValue datetime, TemporalAmount interval, Boolean isAdd) {
        LocalDateTime dt = DateTimeUtils.extractDateTime(datetime, functionProperties);
        return new ExprDatetimeValue(isAdd != false ? dt.plus(interval) : dt.minus(interval));
    }

    private static DefaultFunctionResolver time_format() {
        return FunctionDSL.define(BuiltinFunctionName.TIME_FORMAT.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedTime), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedTime), ExprCoreType.STRING, ExprCoreType.DATE, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedTime), ExprCoreType.STRING, ExprCoreType.DATETIME, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedTime), ExprCoreType.STRING, ExprCoreType.TIME, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(DateTimeFormatterUtil::getFormattedTime), ExprCoreType.STRING, ExprCoreType.TIMESTAMP, ExprCoreType.STRING));
    }

    private static ExprValue exprAddDateDays(FunctionProperties functionProperties, ExprValue datetime, ExprValue days) {
        return DateTimeFunction.exprDateApplyDays(functionProperties, datetime, days.longValue(), true);
    }

    private static ExprValue exprDateApplyDays(FunctionProperties functionProperties, ExprValue datetime, Long days, Boolean isAdd) {
        if (datetime.type() == ExprCoreType.DATE) {
            return new ExprDateValue(isAdd != false ? datetime.dateValue().plusDays(days) : datetime.dateValue().minusDays(days));
        }
        LocalDateTime dt = DateTimeUtils.extractDateTime(datetime, functionProperties);
        return new ExprDatetimeValue(isAdd != false ? dt.plusDays(days) : dt.minusDays(days));
    }

    private static ExprValue exprApplyTime(FunctionProperties functionProperties, ExprValue temporal, ExprValue temporalDelta, Boolean isAdd) {
        Duration interval = Duration.between(LocalTime.MIN, temporalDelta.timeValue());
        LocalDateTime result = isAdd != false ? DateTimeUtils.extractDateTime(temporal, functionProperties).plus(interval) : DateTimeUtils.extractDateTime(temporal, functionProperties).minus(interval);
        return temporal.type() == ExprCoreType.TIME ? new ExprTimeValue(result.toLocalTime()) : new ExprDatetimeValue(result);
    }

    private static ExprValue exprAddTime(FunctionProperties functionProperties, ExprValue temporal, ExprValue temporalDelta) {
        return DateTimeFunction.exprApplyTime(functionProperties, temporal, temporalDelta, true);
    }

    private static ExprValue exprConvertTZ(ExprValue startingDateTime, ExprValue fromTz, ExprValue toTz) {
        if (startingDateTime.type() == ExprCoreType.STRING) {
            startingDateTime = DateTimeFunction.exprDateTimeNoTimezone(startingDateTime);
        }
        try {
            ZoneId convertedFromTz = ZoneId.of(fromTz.stringValue());
            ZoneId convertedToTz = ZoneId.of(toTz.stringValue());
            if (!DateTimeUtils.isValidMySqlTimeZoneId(convertedFromTz).booleanValue() || !DateTimeUtils.isValidMySqlTimeZoneId(convertedToTz).booleanValue()) {
                return ExprNullValue.of();
            }
            ZonedDateTime zonedDateTime = startingDateTime.datetimeValue().atZone(convertedFromTz);
            return new ExprDatetimeValue(zonedDateTime.withZoneSameInstant(convertedToTz).toLocalDateTime());
        }
        catch (DateTimeException | ExpressionEvaluationException e) {
            return ExprNullValue.of();
        }
    }

    private static ExprValue exprDate(ExprValue exprValue) {
        if (exprValue instanceof ExprStringValue) {
            return new ExprDateValue(exprValue.stringValue());
        }
        return new ExprDateValue(exprValue.dateValue());
    }

    private static ExprValue exprDateDiff(FunctionProperties functionProperties, ExprValue first, ExprValue second) {
        return new ExprLongValue(ChronoUnit.DAYS.between(DateTimeUtils.extractDate(second, functionProperties), DateTimeUtils.extractDate(first, functionProperties)));
    }

    private static ExprValue exprDateTime(ExprValue dateTime, ExprValue timeZone) {
        String toTz;
        ExprDatetimeValue ldt;
        String defaultTimeZone = TimeZone.getDefault().getID();
        try {
            LocalDateTime ldtFormatted = LocalDateTime.parse(dateTime.stringValue(), DateTimeFormatters.DATE_TIME_FORMATTER_STRICT_WITH_TZ);
            if (timeZone.isNull()) {
                return new ExprDatetimeValue(ldtFormatted);
            }
        }
        catch (DateTimeParseException e) {
            return ExprNullValue.of();
        }
        try {
            ZonedDateTime zdtWithZoneOffset = ZonedDateTime.parse(dateTime.stringValue(), DateTimeFormatters.DATE_TIME_FORMATTER_STRICT_WITH_TZ);
            ZoneId fromTZ = zdtWithZoneOffset.getZone();
            ldt = new ExprDatetimeValue(zdtWithZoneOffset.toLocalDateTime());
            toTz = String.valueOf(fromTZ);
        }
        catch (DateTimeParseException e) {
            ldt = new ExprDatetimeValue(dateTime.stringValue());
            toTz = defaultTimeZone;
        }
        ExprValue convertTZResult = DateTimeFunction.exprConvertTZ(ldt, new ExprStringValue(toTz), timeZone);
        return convertTZResult;
    }

    private static ExprValue exprDateTimeNoTimezone(ExprValue dateTime) {
        return DateTimeFunction.exprDateTime(dateTime, ExprNullValue.of());
    }

    private static ExprValue exprDayName(ExprValue date) {
        return new ExprStringValue(date.dateValue().getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.getDefault()));
    }

    private static ExprValue exprDayOfMonth(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getDayOfMonth());
    }

    private static ExprValue exprDayOfWeek(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getDayOfWeek().getValue() % 7 + 1);
    }

    private static ExprValue exprDayOfYear(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getDayOfYear());
    }

    public static ExprLongValue formatExtractFunction(ExprValue part, ExprValue datetime) {
        String partName = part.stringValue().toUpperCase();
        LocalDateTime arg = datetime.datetimeValue();
        String text = arg.format(DateTimeFormatter.ofPattern(extract_formats.get(partName), Locale.ENGLISH));
        return new ExprLongValue(Long.parseLong(text));
    }

    private static ExprValue exprExtract(ExprValue part, ExprValue datetime) {
        return DateTimeFunction.formatExtractFunction(part, datetime);
    }

    private static ExprValue exprExtractForTime(FunctionProperties functionProperties, ExprValue part, ExprValue time) {
        return DateTimeFunction.formatExtractFunction(part, new ExprDatetimeValue(DateTimeUtils.extractDateTime(time, functionProperties)));
    }

    private static ExprValue exprFromDays(ExprValue exprValue) {
        return new ExprDateValue(LocalDate.ofEpochDay(exprValue.longValue() - DAYS_0000_TO_1970));
    }

    private static ExprValue exprFromUnixTime(ExprValue time) {
        if (0.0 > time.doubleValue()) {
            return ExprNullValue.of();
        }
        if (MYSQL_MAX_TIMESTAMP <= time.doubleValue()) {
            return ExprNullValue.of();
        }
        return new ExprDatetimeValue(DateTimeFunction.exprFromUnixTimeImpl(time));
    }

    private static LocalDateTime exprFromUnixTimeImpl(ExprValue time) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond((long)Math.floor(time.doubleValue())), DateTimeUtils.UTC_ZONE_ID).withNano((int)(time.doubleValue() % 1.0 * 1.0E9));
    }

    private static ExprValue exprFromUnixTimeFormat(ExprValue time, ExprValue format) {
        ExprValue value = DateTimeFunction.exprFromUnixTime(time);
        if (value.equals(ExprNullValue.of())) {
            return ExprNullValue.of();
        }
        return DateTimeFormatterUtil.getFormattedDate(value, format);
    }

    private static ExprValue exprGetFormat(ExprValue type, ExprValue format) {
        if (formats.contains((Object)type.stringValue().toLowerCase(), (Object)format.stringValue().toLowerCase())) {
            return new ExprStringValue((String)formats.get((Object)type.stringValue().toLowerCase(), (Object)format.stringValue().toLowerCase()));
        }
        return ExprNullValue.of();
    }

    private static ExprValue exprHour(ExprValue time) {
        return new ExprIntegerValue(ChronoUnit.HOURS.between(LocalTime.MIN, time.timeValue()));
    }

    private static LocalDate getLastDay(LocalDate today) {
        return LocalDate.of(today.getYear(), today.getMonth(), today.getMonth().length(today.isLeapYear()));
    }

    private static ExprValue exprLastDay(ExprValue datetime) {
        return new ExprDateValue(DateTimeFunction.getLastDay(datetime.dateValue()));
    }

    private static ExprValue exprLastDayToday(Clock clock) {
        return new ExprDateValue(DateTimeFunction.getLastDay(DateTimeFunction.formatNow(clock).toLocalDate()));
    }

    private static ExprValue exprMakeDate(ExprValue yearExpr, ExprValue dayOfYearExp) {
        long year = Math.round(yearExpr.doubleValue());
        long dayOfYear = Math.round(dayOfYearExp.doubleValue());
        if (0L >= dayOfYear || 0L > year) {
            return ExprNullValue.of();
        }
        if (0L == year) {
            year = 2000L;
        }
        return new ExprDateValue(LocalDate.ofYearDay((int)year, 1).plusDays(dayOfYear - 1L));
    }

    private static ExprValue exprMakeTime(ExprValue hourExpr, ExprValue minuteExpr, ExprValue secondExpr) {
        long hour = Math.round(hourExpr.doubleValue());
        long minute = Math.round(minuteExpr.doubleValue());
        Double second = secondExpr.doubleValue();
        if (0L > hour || 0L > minute || 0.0 > second) {
            return ExprNullValue.of();
        }
        return new ExprTimeValue(LocalTime.parse(String.format("%02d:%02d:%012.9f", hour, minute, second), DateTimeFormatter.ISO_TIME));
    }

    private static ExprValue exprMicrosecond(ExprValue time) {
        return new ExprIntegerValue(TimeUnit.MICROSECONDS.convert(time.timeValue().getNano(), TimeUnit.NANOSECONDS));
    }

    private static ExprValue exprMinute(ExprValue time) {
        return new ExprIntegerValue(ChronoUnit.MINUTES.between(LocalTime.MIN, time.timeValue()) % 60L);
    }

    private static ExprValue exprMinuteOfDay(ExprValue time) {
        return new ExprIntegerValue(ChronoUnit.MINUTES.between(LocalTime.MIN, time.timeValue()));
    }

    private static ExprValue exprMonth(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getMonthValue());
    }

    private static ExprValue exprMonthName(ExprValue date) {
        return new ExprStringValue(date.dateValue().getMonth().getDisplayName(TextStyle.FULL, Locale.getDefault()));
    }

    private static LocalDate parseDatePeriod(Integer period) {
        String input = period.toString();
        if (input.length() <= 5) {
            input = String.format("200%05d", period);
        }
        try {
            return LocalDate.parse(input, DateTimeFormatters.DATE_FORMATTER_SHORT_YEAR);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return LocalDate.parse(input, DateTimeFormatters.DATE_FORMATTER_LONG_YEAR);
            }
            catch (DateTimeParseException ignored) {
                return null;
            }
        }
    }

    private static ExprValue exprPeriodAdd(ExprValue period, ExprValue months) {
        int input = period.integerValue() * 100 + 1;
        LocalDate parsedDate = DateTimeFunction.parseDatePeriod(input);
        if (parsedDate == null) {
            return ExprNullValue.of();
        }
        String res = DateTimeFormatters.DATE_FORMATTER_LONG_YEAR.format(parsedDate.plusMonths(months.integerValue().intValue()));
        return new ExprIntegerValue(Integer.parseInt(res.substring(0, res.length() - 2)));
    }

    private static ExprValue exprPeriodDiff(ExprValue period1, ExprValue period2) {
        LocalDate parsedDate1 = DateTimeFunction.parseDatePeriod(period1.integerValue() * 100 + 1);
        LocalDate parsedDate2 = DateTimeFunction.parseDatePeriod(period2.integerValue() * 100 + 1);
        if (parsedDate1 == null || parsedDate2 == null) {
            return ExprNullValue.of();
        }
        return new ExprIntegerValue(ChronoUnit.MONTHS.between(parsedDate2, parsedDate1));
    }

    private static ExprValue exprQuarter(ExprValue date) {
        int month = date.dateValue().getMonthValue();
        return new ExprIntegerValue(month / 3 + (month % 3 == 0 ? 0 : 1));
    }

    private static ExprValue exprSecToTime(ExprValue totalSeconds) {
        return new ExprTimeValue(LocalTime.MIN.plus(Duration.ofSeconds(totalSeconds.longValue())));
    }

    private static long formatNanos(ExprValue seconds) {
        BigDecimal formattedNanos = BigDecimal.valueOf(seconds.doubleValue());
        formattedNanos = formattedNanos.subtract(BigDecimal.valueOf(formattedNanos.intValue()));
        return formattedNanos.scaleByPowerOfTen(9).longValue();
    }

    private static ExprValue exprSecToTimeWithNanos(ExprValue totalSeconds) {
        long nanos = DateTimeFunction.formatNanos(totalSeconds);
        return new ExprTimeValue(LocalTime.MIN.plus(Duration.ofSeconds(totalSeconds.longValue(), nanos)));
    }

    private static ExprValue exprSecond(ExprValue time) {
        return new ExprIntegerValue(ChronoUnit.SECONDS.between(LocalTime.MIN, time.timeValue()) % 60L);
    }

    private static ExprValue exprSubDateDays(FunctionProperties functionProperties, ExprValue date, ExprValue days) {
        return DateTimeFunction.exprDateApplyDays(functionProperties, date, days.longValue(), false);
    }

    private static ExprValue exprSubDateInterval(FunctionProperties functionProperties, ExprValue datetime, ExprValue expr) {
        return DateTimeFunction.exprDateApplyInterval(functionProperties, datetime, expr.intervalValue(), false);
    }

    private static ExprValue exprSubTime(FunctionProperties functionProperties, ExprValue temporal, ExprValue temporalDelta) {
        return DateTimeFunction.exprApplyTime(functionProperties, temporal, temporalDelta, false);
    }

    private static ExprValue exprStrToDate(FunctionProperties fp, ExprValue dateTimeExpr, ExprValue formatStringExp) {
        return DateTimeFormatterUtil.parseStringWithDateOrTime(fp, dateTimeExpr, formatStringExp);
    }

    private static ExprValue exprTime(ExprValue exprValue) {
        if (exprValue instanceof ExprStringValue) {
            return new ExprTimeValue(exprValue.stringValue());
        }
        return new ExprTimeValue(exprValue.timeValue());
    }

    private static ExprValue exprTimeDiff(ExprValue first, ExprValue second) {
        return new ExprTimeValue(LocalTime.MIN.plus(Duration.between(second.timeValue(), first.timeValue())));
    }

    private static ExprValue exprTimeToSec(ExprValue time) {
        return new ExprLongValue(time.timeValue().toSecondOfDay());
    }

    private static ExprValue exprTimestampAdd(ExprValue partExpr, ExprValue amountExpr, ExprValue datetimeExpr) {
        ChronoUnit temporalUnit;
        String part = partExpr.stringValue();
        int amount = amountExpr.integerValue();
        LocalDateTime datetime = datetimeExpr.datetimeValue();
        switch (part) {
            case "MICROSECOND": {
                temporalUnit = ChronoUnit.MICROS;
                break;
            }
            case "SECOND": {
                temporalUnit = ChronoUnit.SECONDS;
                break;
            }
            case "MINUTE": {
                temporalUnit = ChronoUnit.MINUTES;
                break;
            }
            case "HOUR": {
                temporalUnit = ChronoUnit.HOURS;
                break;
            }
            case "DAY": {
                temporalUnit = ChronoUnit.DAYS;
                break;
            }
            case "WEEK": {
                temporalUnit = ChronoUnit.WEEKS;
                break;
            }
            case "MONTH": {
                temporalUnit = ChronoUnit.MONTHS;
                break;
            }
            case "QUARTER": {
                temporalUnit = ChronoUnit.MONTHS;
                amount *= 3;
                break;
            }
            case "YEAR": {
                temporalUnit = ChronoUnit.YEARS;
                break;
            }
            default: {
                return ExprNullValue.of();
            }
        }
        return new ExprDatetimeValue(datetime.plus(amount, temporalUnit));
    }

    private static ExprValue exprTimestampAddForTimeType(Clock clock, ExprValue partExpr, ExprValue amountExpr, ExprValue timeExpr) {
        LocalDateTime datetime = LocalDateTime.of(DateTimeFunction.formatNow(clock).toLocalDate(), timeExpr.timeValue());
        return DateTimeFunction.exprTimestampAdd(partExpr, amountExpr, new ExprDatetimeValue(datetime));
    }

    private static ExprValue getTimeDifference(String part, LocalDateTime startTime, LocalDateTime endTime) {
        long returnVal;
        switch (part) {
            case "MICROSECOND": {
                returnVal = ChronoUnit.MICROS.between(startTime, endTime);
                break;
            }
            case "SECOND": {
                returnVal = ChronoUnit.SECONDS.between(startTime, endTime);
                break;
            }
            case "MINUTE": {
                returnVal = ChronoUnit.MINUTES.between(startTime, endTime);
                break;
            }
            case "HOUR": {
                returnVal = ChronoUnit.HOURS.between(startTime, endTime);
                break;
            }
            case "DAY": {
                returnVal = ChronoUnit.DAYS.between(startTime, endTime);
                break;
            }
            case "WEEK": {
                returnVal = ChronoUnit.WEEKS.between(startTime, endTime);
                break;
            }
            case "MONTH": {
                returnVal = ChronoUnit.MONTHS.between(startTime, endTime);
                break;
            }
            case "QUARTER": {
                returnVal = ChronoUnit.MONTHS.between(startTime, endTime) / 3L;
                break;
            }
            case "YEAR": {
                returnVal = ChronoUnit.YEARS.between(startTime, endTime);
                break;
            }
            default: {
                return ExprNullValue.of();
            }
        }
        return new ExprLongValue(returnVal);
    }

    private static ExprValue exprTimestampDiff(ExprValue partExpr, ExprValue startTimeExpr, ExprValue endTimeExpr) {
        return DateTimeFunction.getTimeDifference(partExpr.stringValue(), startTimeExpr.datetimeValue(), endTimeExpr.datetimeValue());
    }

    private static ExprValue exprTimestampDiffForTimeType(FunctionProperties fp, ExprValue partExpr, ExprValue startTimeExpr, ExprValue endTimeExpr) {
        return DateTimeFunction.getTimeDifference(partExpr.stringValue(), DateTimeUtils.extractDateTime(startTimeExpr, fp), DateTimeUtils.extractDateTime(endTimeExpr, fp));
    }

    private static ExprValue exprUtcDate(FunctionProperties functionProperties) {
        return new ExprDateValue(DateTimeFunction.exprUtcTimeStamp(functionProperties).dateValue());
    }

    private static ExprValue exprUtcTime(FunctionProperties functionProperties) {
        return new ExprTimeValue(DateTimeFunction.exprUtcTimeStamp(functionProperties).timeValue());
    }

    private static ExprValue exprUtcTimeStamp(FunctionProperties functionProperties) {
        ZonedDateTime zdt = ZonedDateTime.now(functionProperties.getQueryStartClock()).withZoneSameInstant(DateTimeUtils.UTC_ZONE_ID);
        return new ExprDatetimeValue(zdt.toLocalDateTime());
    }

    private static ExprValue exprToDays(ExprValue date) {
        return new ExprLongValue(date.dateValue().toEpochDay() + DAYS_0000_TO_1970);
    }

    private static ExprValue exprToSeconds(ExprValue date) {
        return new ExprLongValue(date.datetimeValue().toEpochSecond(ZoneOffset.UTC) + DAYS_0000_TO_1970 * 86400L);
    }

    private static DateTimeFormatter getFormatter(int dateAsInt) {
        int length = String.format("%d", dateAsInt).length();
        if (length > 8) {
            throw new DateTimeException("Integer argument was out of range");
        }
        switch (length) {
            case 8: {
                return DateTimeFormatters.DATE_FORMATTER_LONG_YEAR;
            }
            case 6: {
                return DateTimeFormatters.DATE_FORMATTER_SHORT_YEAR;
            }
            case 5: {
                return DateTimeFormatters.DATE_FORMATTER_SINGLE_DIGIT_YEAR;
            }
            case 4: {
                return DateTimeFormatters.DATE_FORMATTER_NO_YEAR;
            }
            case 3: {
                return DateTimeFormatters.DATE_FORMATTER_SINGLE_DIGIT_MONTH;
            }
        }
        throw new DateTimeException("No Matching Format");
    }

    private static ExprValue exprToSecondsForIntType(ExprValue dateExpr) {
        try {
            LocalDate date = LocalDate.parse(String.valueOf(dateExpr.integerValue()), DateTimeFunction.getFormatter(dateExpr.integerValue()));
            return new ExprLongValue(date.toEpochSecond(LocalTime.MIN, ZoneOffset.UTC) + DAYS_0000_TO_1970 * 86400L);
        }
        catch (DateTimeException ignored) {
            return ExprNullValue.of();
        }
    }

    private static ExprValue exprWeek(ExprValue date, ExprValue mode) {
        return new ExprIntegerValue(CalendarLookup.getWeekNumber(mode.integerValue(), date.dateValue()));
    }

    private static ExprValue exprWeekday(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getDayOfWeek().getValue() - 1);
    }

    private static ExprValue unixTimeStamp(Clock clock) {
        return new ExprLongValue(Instant.now(clock).getEpochSecond());
    }

    private static ExprValue unixTimeStampOf(ExprValue value) {
        Double res = DateTimeFunction.unixTimeStampOfImpl(value);
        if (res == null) {
            return ExprNullValue.of();
        }
        if (res < 0.0) {
            return new ExprDoubleValue(0);
        }
        if (res >= MYSQL_MAX_TIMESTAMP) {
            return new ExprDoubleValue(0);
        }
        return new ExprDoubleValue(res);
    }

    private static Double unixTimeStampOfImpl(ExprValue value) {
        switch ((ExprCoreType)value.type()) {
            case DATE: {
                return (double)value.dateValue().toEpochSecond(LocalTime.MIN, ZoneOffset.UTC) + 0.0;
            }
            case DATETIME: {
                return (double)value.datetimeValue().toEpochSecond(ZoneOffset.UTC) + (double)value.datetimeValue().getNano() / 1.0E9;
            }
            case TIMESTAMP: {
                return (double)value.timestampValue().getEpochSecond() + (double)value.timestampValue().getNano() / 1.0E9;
            }
        }
        DecimalFormat format = new DecimalFormat("0.#");
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(6);
        String input = format.format(value.doubleValue());
        double fraction = 0.0;
        if (input.contains(".")) {
            fraction = value.doubleValue() - (double)Math.round(Math.ceil(value.doubleValue()));
            input = input.substring(0, input.indexOf(46));
        }
        try {
            LocalDateTime res = LocalDateTime.parse(input, DateTimeFormatters.DATE_TIME_FORMATTER_SHORT_YEAR);
            return (double)res.toEpochSecond(ZoneOffset.UTC) + fraction;
        }
        catch (DateTimeParseException res) {
            try {
                LocalDateTime res2 = LocalDateTime.parse(input, DateTimeFormatters.DATE_TIME_FORMATTER_LONG_YEAR);
                return (double)res2.toEpochSecond(ZoneOffset.UTC) + fraction;
            }
            catch (DateTimeParseException res2) {
                try {
                    LocalDate res3 = LocalDate.parse(input, DateTimeFormatters.DATE_FORMATTER_SHORT_YEAR);
                    return (double)res3.toEpochSecond(LocalTime.MIN, ZoneOffset.UTC) + 0.0;
                }
                catch (DateTimeParseException res3) {
                    try {
                        LocalDate res4 = LocalDate.parse(input, DateTimeFormatters.DATE_FORMATTER_LONG_YEAR);
                        return (double)res4.toEpochSecond(LocalTime.MIN, ZoneOffset.UTC) + 0.0;
                    }
                    catch (DateTimeParseException ignored) {
                        return null;
                    }
                }
            }
        }
    }

    private static ExprValue exprWeekWithoutMode(ExprValue date) {
        return DateTimeFunction.exprWeek(date, DEFAULT_WEEK_OF_YEAR_MODE);
    }

    private static ExprValue exprYear(ExprValue date) {
        return new ExprIntegerValue(date.dateValue().getYear());
    }

    private static ExprIntegerValue extractYearweek(LocalDate date, int mode) {
        int modeJava = CalendarLookup.getWeekNumber(mode, date) != 0 ? mode : (mode <= 4 ? 2 : 7);
        int formatted = CalendarLookup.getYearNumber(modeJava, date) * 100 + CalendarLookup.getWeekNumber(modeJava, date);
        return new ExprIntegerValue(formatted);
    }

    private static ExprValue exprYearweek(ExprValue date, ExprValue mode) {
        return DateTimeFunction.extractYearweek(date.dateValue(), mode.integerValue());
    }

    private static ExprValue exprYearweekWithoutMode(ExprValue date) {
        return DateTimeFunction.exprYearweek(date, new ExprIntegerValue(0));
    }

    private static ExprValue yearweekToday(ExprValue mode, Clock clock) {
        return DateTimeFunction.extractYearweek(LocalDateTime.now(clock).toLocalDate(), mode.integerValue());
    }

    private static ExprValue monthOfYearToday(Clock clock) {
        return new ExprIntegerValue(LocalDateTime.now(clock).getMonthValue());
    }

    private static LocalDateTime formatNow(Clock clock) {
        return DateTimeFunction.formatNow(clock, 0);
    }

    private static LocalDateTime formatNow(Clock clock, Integer fsp) {
        LocalDateTime res = LocalDateTime.now(clock);
        int defaultPrecision = 9;
        if (fsp < 0 || fsp > 6) {
            throw new IllegalArgumentException(String.format("Invalid `fsp` value: %d, allowed 0 to 6", fsp));
        }
        int nano = new BigDecimal(res.getNano()).setScale(fsp - defaultPrecision, RoundingMode.DOWN).intValue();
        return res.withNano(nano);
    }

    @Generated
    private DateTimeFunction() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

