/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure.trackers;

import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import org.opensearch.common.util.Streak;
import org.opensearch.search.ResourceType;

public class NodeDuressTrackers {
    private final Map<ResourceType, NodeDuressTracker> duressTrackers;

    public NodeDuressTrackers(Map<ResourceType, NodeDuressTracker> duressTrackers) {
        this.duressTrackers = duressTrackers;
    }

    public boolean isResourceInDuress(ResourceType resourceType) {
        return this.duressTrackers.get((Object)resourceType).test();
    }

    public boolean isNodeInDuress() {
        for (ResourceType resourceType : ResourceType.values()) {
            if (!this.isResourceInDuress(resourceType)) continue;
            return true;
        }
        return false;
    }

    public static class NodeDuressTracker {
        private final Streak breaches = new Streak();
        private final BooleanSupplier isNodeInDuress;
        private final IntSupplier maxBreachAllowedSupplier;

        public NodeDuressTracker(BooleanSupplier isNodeInDuress, IntSupplier maxBreachAllowedSupplier) {
            this.isNodeInDuress = isNodeInDuress;
            this.maxBreachAllowedSupplier = maxBreachAllowedSupplier;
        }

        public boolean test() {
            return this.breaches.record(this.isNodeInDuress.getAsBoolean()) >= this.maxBreachAllowedSupplier.getAsInt();
        }
    }
}

