/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.NumericUtils;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.Rounding;
import org.opensearch.common.lucene.search.function.FunctionScoreQuery;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.index.mapper.NumericPointEncoder;
import org.opensearch.index.query.DateRangeIncludingNowQuery;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregator;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.opensearch.search.aggregations.bucket.composite.RoundingValuesSource;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.aggregations.bucket.range.RangeAggregator;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

public final class FastFilterRewriteHelper {
    private static final Logger logger = LogManager.getLogger(FastFilterRewriteHelper.class);
    private static final Map<Class<?>, Function<Query, Query>> queryWrappers = new HashMap();

    private FastFilterRewriteHelper() {
    }

    private static Query unwrapIntoConcreteQuery(Query query) {
        while (queryWrappers.containsKey(query.getClass())) {
            query = queryWrappers.get(query.getClass()).apply(query);
        }
        return query;
    }

    private static long[] getShardBounds(SearchContext context, String fieldName) throws IOException {
        List leaves = context.searcher().getIndexReader().leaves();
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (LeafReaderContext leaf : leaves) {
            PointValues values = leaf.reader().getPointValues(fieldName);
            if (values == null) continue;
            min = Math.min(min, NumericUtils.sortableBytesToLong((byte[])values.getMinPackedValue(), (int)0));
            max = Math.max(max, NumericUtils.sortableBytesToLong((byte[])values.getMaxPackedValue(), (int)0));
        }
        if (min == Long.MAX_VALUE || max == Long.MIN_VALUE) {
            return null;
        }
        return new long[]{min, max};
    }

    private static long[] getSegmentBounds(LeafReaderContext context, String fieldName) throws IOException {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        PointValues values = context.reader().getPointValues(fieldName);
        if (values != null) {
            min = Math.min(min, NumericUtils.sortableBytesToLong((byte[])values.getMinPackedValue(), (int)0));
            max = Math.max(max, NumericUtils.sortableBytesToLong((byte[])values.getMaxPackedValue(), (int)0));
        }
        if (min == Long.MAX_VALUE || max == Long.MIN_VALUE) {
            return null;
        }
        return new long[]{min, max};
    }

    public static long[] getDateHistoAggBounds(SearchContext context, String fieldName) throws IOException {
        Query cq = FastFilterRewriteHelper.unwrapIntoConcreteQuery(context.query());
        if (cq instanceof PointRangeQuery) {
            PointRangeQuery prq = (PointRangeQuery)cq;
            long[] indexBounds = FastFilterRewriteHelper.getShardBounds(context, fieldName);
            if (indexBounds == null) {
                return null;
            }
            return FastFilterRewriteHelper.getBoundsWithRangeQuery(prq, fieldName, indexBounds);
        }
        if (cq instanceof MatchAllDocsQuery) {
            return FastFilterRewriteHelper.getShardBounds(context, fieldName);
        }
        if (cq instanceof FieldExistsQuery && ((FieldExistsQuery)cq).getField().equals(fieldName)) {
            return FastFilterRewriteHelper.getShardBounds(context, fieldName);
        }
        return null;
    }

    private static long[] getBoundsWithRangeQuery(PointRangeQuery prq, String fieldName, long[] indexBounds) {
        if (prq.getField().equals(fieldName)) {
            long upper;
            long lower = Math.max(NumericUtils.sortableBytesToLong((byte[])prq.getLowerPoint(), (int)0), indexBounds[0]);
            if (lower > (upper = Math.min(NumericUtils.sortableBytesToLong((byte[])prq.getUpperPoint(), (int)0), indexBounds[1]))) {
                return null;
            }
            return new long[]{lower, upper};
        }
        return null;
    }

    public static boolean isCompositeAggRewriteable(CompositeValuesSourceConfig[] sourceConfigs) {
        return sourceConfigs.length == 1 && sourceConfigs[0].valuesSource() instanceof RoundingValuesSource;
    }

    private static boolean segmentMatchAll(SearchContext ctx, LeafReaderContext leafCtx) throws IOException {
        Weight weight = ctx.searcher().createWeight(ctx.query(), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        return weight != null && weight.count(leafCtx) == leafCtx.reader().numDocs();
    }

    private static Ranges createRangesFromAgg(SearchContext context, DateFieldMapper.DateFieldType fieldType, long interval, Rounding.Prepared preparedRounding, long low, long high) {
        long roundedLow;
        long prevRounded = roundedLow = preparedRounding.round(fieldType.convertNanosToMillis(low));
        int bucketCount = 0;
        while (roundedLow <= fieldType.convertNanosToMillis(high)) {
            int maxNumFilterBuckets = context.maxAggRewriteFilters();
            if (++bucketCount > maxNumFilterBuckets) {
                logger.debug("Max number of filters reached [{}], skip the fast filter optimization", (Object)maxNumFilterBuckets);
                return null;
            }
            if (prevRounded == (roundedLow = preparedRounding.round(roundedLow + interval))) break;
            prevRounded = roundedLow;
        }
        long[][] ranges = new long[bucketCount][2];
        if (bucketCount > 0) {
            roundedLow = preparedRounding.round(fieldType.convertNanosToMillis(low));
            for (int i = 0; i < bucketCount; ++i) {
                long lower = i == 0 ? low : fieldType.convertRoundedMillisToNanos(roundedLow);
                roundedLow = preparedRounding.round(roundedLow + interval);
                long upper = i + 1 == bucketCount ? high + 1L : fieldType.convertRoundedMillisToNanos(roundedLow);
                ranges[i][0] = lower;
                ranges[i][1] = upper;
            }
        }
        byte[][] lowers = new byte[ranges.length][];
        byte[][] uppers = new byte[ranges.length][];
        for (int i = 0; i < ranges.length; ++i) {
            byte[] lower = NumberFieldMapper.NumberType.LONG.encodePoint(ranges[i][0]);
            byte[] max = NumberFieldMapper.NumberType.LONG.encodePoint(ranges[i][1]);
            lowers[i] = lower;
            uppers[i] = max;
        }
        return new Ranges(lowers, uppers);
    }

    private static DebugInfo multiRangesTraverse(PointValues.PointTree tree, Ranges ranges, BiConsumer<Integer, Integer> incrementDocCount, int maxNumNonZeroRanges) throws IOException {
        DebugInfo debugInfo = new DebugInfo();
        int activeIndex = ranges.firstRangeIndex(tree.getMinPackedValue(), tree.getMaxPackedValue());
        if (activeIndex < 0) {
            logger.debug("No ranges match the query, skip the fast filter optimization");
            return debugInfo;
        }
        RangeCollectorForPointTree collector = new RangeCollectorForPointTree(incrementDocCount, maxNumNonZeroRanges, ranges, activeIndex);
        PointValues.IntersectVisitor visitor = FastFilterRewriteHelper.getIntersectVisitor(collector);
        try {
            FastFilterRewriteHelper.intersectWithRanges(visitor, tree, collector, debugInfo);
        }
        catch (CollectionTerminatedException e) {
            logger.debug("Early terminate since no more range to collect");
        }
        collector.finalizePreviousRange();
        return debugInfo;
    }

    private static void intersectWithRanges(PointValues.IntersectVisitor visitor, PointValues.PointTree pointTree, RangeCollectorForPointTree collector, DebugInfo debug) throws IOException {
        PointValues.Relation r = visitor.compare(pointTree.getMinPackedValue(), pointTree.getMaxPackedValue());
        switch (r) {
            case CELL_INSIDE_QUERY: {
                collector.countNode((int)pointTree.size());
                debug.visitInner();
                break;
            }
            case CELL_CROSSES_QUERY: {
                if (pointTree.moveToChild()) {
                    do {
                        FastFilterRewriteHelper.intersectWithRanges(visitor, pointTree, collector, debug);
                    } while (pointTree.moveToSibling());
                    pointTree.moveToParent();
                    break;
                }
                pointTree.visitDocValues(visitor);
                debug.visitLeaf();
                break;
            }
        }
    }

    private static PointValues.IntersectVisitor getIntersectVisitor(final RangeCollectorForPointTree collector) {
        return new PointValues.IntersectVisitor(){

            public void visit(int docID) throws IOException {
                throw new UnsupportedOperationException("This IntersectVisitor does not perform any actions on a docID=" + docID + " node being visited");
            }

            public void visit(int docID, byte[] packedValue) throws IOException {
                this.visitPoints(packedValue, (CheckedRunnable<IOException>)((CheckedRunnable)() -> collector.count()));
            }

            public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
                this.visitPoints(packedValue, (CheckedRunnable<IOException>)((CheckedRunnable)() -> {
                    int doc = iterator.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        collector.count();
                        doc = iterator.nextDoc();
                    }
                }));
            }

            private void visitPoints(byte[] packedValue, CheckedRunnable<IOException> collect) throws IOException {
                if (!collector.withinUpperBound(packedValue)) {
                    collector.finalizePreviousRange();
                    if (collector.iterateRangeEnd(packedValue)) {
                        throw new CollectionTerminatedException();
                    }
                }
                if (collector.withinRange(packedValue)) {
                    collect.run();
                }
            }

            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                if (!collector.withinUpperBound(minPackedValue)) {
                    collector.finalizePreviousRange();
                    if (collector.iterateRangeEnd(minPackedValue)) {
                        throw new CollectionTerminatedException();
                    }
                }
                if (!collector.withinLowerBound(maxPackedValue)) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                if (collector.withinRange(minPackedValue) && collector.withinRange(maxPackedValue)) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
        };
    }

    static {
        queryWrappers.put(ConstantScoreQuery.class, q -> ((ConstantScoreQuery)q).getQuery());
        queryWrappers.put(FunctionScoreQuery.class, q -> ((FunctionScoreQuery)((Object)q)).getSubQuery());
        queryWrappers.put(DateRangeIncludingNowQuery.class, q -> ((DateRangeIncludingNowQuery)((Object)q)).getQuery());
        queryWrappers.put(IndexOrDocValuesQuery.class, q -> ((IndexOrDocValuesQuery)q).getIndexQuery());
    }

    private static class Ranges {
        byte[][] lowers;
        byte[][] uppers;
        int size;
        int byteLen;
        static ArrayUtil.ByteArrayComparator comparator;

        Ranges(byte[][] lowers, byte[][] uppers) {
            this.lowers = lowers;
            this.uppers = uppers;
            assert (lowers.length == uppers.length);
            this.size = lowers.length;
            this.byteLen = lowers[0].length;
            comparator = ArrayUtil.getUnsignedComparator((int)this.byteLen);
        }

        public int firstRangeIndex(byte[] globalMin, byte[] globalMax) {
            if (Ranges.compareByteValue(this.lowers[0], globalMax) > 0) {
                return -1;
            }
            int i = 0;
            while (Ranges.compareByteValue(this.uppers[i], globalMin) <= 0) {
                if (++i < this.size) continue;
                return -1;
            }
            return i;
        }

        public static int compareByteValue(byte[] value1, byte[] value2) {
            return comparator.compare(value1, 0, value2, 0);
        }

        public static boolean withinLowerBound(byte[] value, byte[] lowerBound) {
            return Ranges.compareByteValue(value, lowerBound) >= 0;
        }

        public static boolean withinUpperBound(byte[] value, byte[] upperBound) {
            return Ranges.compareByteValue(value, upperBound) < 0;
        }
    }

    private static class DebugInfo {
        private int leaf = 0;
        private int inner = 0;

        private DebugInfo() {
        }

        private void visitLeaf() {
            ++this.leaf;
        }

        private void visitInner() {
            ++this.inner;
        }
    }

    private static class RangeCollectorForPointTree {
        private final BiConsumer<Integer, Integer> incrementRangeDocCount;
        private int counter = 0;
        private final Ranges ranges;
        private int activeIndex;
        private int visitedRange = 0;
        private final int maxNumNonZeroRange;

        public RangeCollectorForPointTree(BiConsumer<Integer, Integer> incrementRangeDocCount, int maxNumNonZeroRange, Ranges ranges, int activeIndex) {
            this.incrementRangeDocCount = incrementRangeDocCount;
            this.maxNumNonZeroRange = maxNumNonZeroRange;
            this.ranges = ranges;
            this.activeIndex = activeIndex;
        }

        private void count() {
            ++this.counter;
        }

        private void countNode(int count) {
            this.counter += count;
        }

        private void finalizePreviousRange() {
            if (this.counter > 0) {
                this.incrementRangeDocCount.accept(this.activeIndex, this.counter);
                this.counter = 0;
            }
        }

        private boolean iterateRangeEnd(byte[] value) {
            while (!this.withinUpperBound(value)) {
                if (++this.activeIndex < this.ranges.size) continue;
                return true;
            }
            ++this.visitedRange;
            return this.visitedRange > this.maxNumNonZeroRange;
        }

        private boolean withinLowerBound(byte[] value) {
            return Ranges.withinLowerBound(value, this.ranges.lowers[this.activeIndex]);
        }

        private boolean withinUpperBound(byte[] value) {
            return Ranges.withinUpperBound(value, this.ranges.uppers[this.activeIndex]);
        }

        private boolean withinRange(byte[] value) {
            return this.withinLowerBound(value) && this.withinUpperBound(value);
        }
    }

    public static class RangeAggregationType
    implements AggregationType {
        private final ValuesSourceConfig config;
        private final RangeAggregator.Range[] ranges;

        public RangeAggregationType(ValuesSourceConfig config, RangeAggregator.Range[] ranges) {
            this.config = config;
            this.ranges = ranges;
        }

        @Override
        public boolean isRewriteable(Object parent, int subAggLength) {
            if (this.config.fieldType() == null) {
                return false;
            }
            MappedFieldType fieldType = this.config.fieldType();
            if (!fieldType.isSearchable() || !(fieldType instanceof NumericPointEncoder)) {
                return false;
            }
            if (parent == null && subAggLength == 0 && this.config.script() == null && this.config.missing() == null && this.config.getValuesSource() instanceof ValuesSource.Numeric.FieldData) {
                double prevTo = this.ranges[0].getTo();
                for (int i = 1; i < this.ranges.length; ++i) {
                    if (prevTo > this.ranges[i].getFrom()) {
                        return false;
                    }
                    prevTo = this.ranges[i].getTo();
                }
                return true;
            }
            return false;
        }

        @Override
        public Ranges buildRanges(SearchContext context, MappedFieldType fieldType) {
            assert (fieldType instanceof NumericPointEncoder);
            NumericPointEncoder numericPointEncoder = (NumericPointEncoder)((Object)fieldType);
            byte[][] lowers = new byte[this.ranges.length][];
            byte[][] uppers = new byte[this.ranges.length][];
            for (int i = 0; i < this.ranges.length; ++i) {
                double rangeMin = this.ranges[i].getFrom();
                double rangeMax = this.ranges[i].getTo();
                byte[] lower = numericPointEncoder.encodePoint(rangeMin);
                byte[] upper = numericPointEncoder.encodePoint(rangeMax);
                lowers[i] = lower;
                uppers[i] = upper;
            }
            return new Ranges(lowers, uppers);
        }

        @Override
        public Ranges buildRanges(LeafReaderContext leaf, SearchContext ctx, MappedFieldType fieldType) {
            throw new UnsupportedOperationException("Range aggregation should not build ranges at segment level");
        }

        @Override
        public DebugInfo tryFastFilterAggregation(PointValues values, Ranges ranges, BiConsumer<Long, Long> incrementDocCount, Function<Object, Long> bucketOrd) throws IOException {
            int size = Integer.MAX_VALUE;
            BiConsumer<Integer, Integer> incrementFunc = (activeIndex, docCount) -> {
                long ord = (Long)bucketOrd.apply(activeIndex);
                incrementDocCount.accept(ord, Long.valueOf(docCount.intValue()));
            };
            return FastFilterRewriteHelper.multiRangesTraverse(values.getPointTree(), ranges, incrementFunc, size);
        }
    }

    public static abstract class AbstractDateHistogramAggregationType
    implements AggregationType {
        private final MappedFieldType fieldType;
        private final boolean missing;
        private final boolean hasScript;
        private LongBounds hardBounds;

        public AbstractDateHistogramAggregationType(MappedFieldType fieldType, boolean missing, boolean hasScript) {
            this.fieldType = fieldType;
            this.missing = missing;
            this.hasScript = hasScript;
        }

        public AbstractDateHistogramAggregationType(MappedFieldType fieldType, boolean missing, boolean hasScript, LongBounds hardBounds) {
            this(fieldType, missing, hasScript);
            this.hardBounds = hardBounds;
        }

        @Override
        public boolean isRewriteable(Object parent, int subAggLength) {
            if (parent == null && subAggLength == 0 && !this.missing && !this.hasScript && this.fieldType != null && this.fieldType instanceof DateFieldMapper.DateFieldType) {
                return this.fieldType.isSearchable();
            }
            return false;
        }

        @Override
        public Ranges buildRanges(SearchContext context, MappedFieldType fieldType) throws IOException {
            long[] bounds = FastFilterRewriteHelper.getDateHistoAggBounds(context, fieldType.name());
            logger.debug("Bounds are {} for shard {}", (Object)bounds, (Object)context.indexShard().shardId());
            return this.buildRanges(context, bounds);
        }

        @Override
        public Ranges buildRanges(LeafReaderContext leaf, SearchContext context, MappedFieldType fieldType) throws IOException {
            long[] bounds = FastFilterRewriteHelper.getSegmentBounds(leaf, fieldType.name());
            logger.debug("Bounds are {} for shard {} segment {}", (Object)bounds, (Object)context.indexShard().shardId(), (Object)leaf.ord);
            return this.buildRanges(context, bounds);
        }

        private Ranges buildRanges(SearchContext context, long[] bounds) throws IOException {
            if ((bounds = this.processHardBounds(bounds)) == null) {
                return null;
            }
            assert (bounds[0] <= bounds[1]) : "Low bound should be less than high bound";
            Rounding rounding = this.getRounding(bounds[0], bounds[1]);
            OptionalLong intervalOpt = Rounding.getInterval(rounding);
            if (intervalOpt.isEmpty()) {
                return null;
            }
            long interval = intervalOpt.getAsLong();
            this.processAfterKey(bounds, interval);
            return FastFilterRewriteHelper.createRangesFromAgg(context, (DateFieldMapper.DateFieldType)this.fieldType, interval, this.getRoundingPrepared(), bounds[0], bounds[1]);
        }

        protected abstract Rounding getRounding(long var1, long var3);

        protected abstract Rounding.Prepared getRoundingPrepared();

        protected void processAfterKey(long[] bound, long interval) {
        }

        protected long[] processHardBounds(long[] bounds) {
            if (bounds != null && this.hardBounds != null) {
                if (this.hardBounds.getMin() > bounds[0]) {
                    bounds[0] = this.hardBounds.getMin();
                }
                if (this.hardBounds.getMax() - 1L < bounds[1]) {
                    bounds[1] = this.hardBounds.getMax() - 1L;
                }
                if (bounds[0] > bounds[1]) {
                    return null;
                }
            }
            return bounds;
        }

        public DateFieldMapper.DateFieldType getFieldType() {
            assert (this.fieldType instanceof DateFieldMapper.DateFieldType);
            return (DateFieldMapper.DateFieldType)this.fieldType;
        }

        @Override
        public DebugInfo tryFastFilterAggregation(PointValues values, Ranges ranges, BiConsumer<Long, Long> incrementDocCount, Function<Object, Long> bucketOrd) throws IOException {
            int size = Integer.MAX_VALUE;
            if (this instanceof CompositeAggregator.CompositeAggregationType) {
                size = ((CompositeAggregator.CompositeAggregationType)this).getSize();
            }
            DateFieldMapper.DateFieldType fieldType = this.getFieldType();
            BiConsumer<Integer, Integer> incrementFunc = (activeIndex, docCount) -> {
                long rangeStart = LongPoint.decodeDimension((byte[])ranges.lowers[activeIndex], (int)0);
                rangeStart = fieldType.convertNanosToMillis(rangeStart);
                long ord = AbstractDateHistogramAggregationType.getBucketOrd((Long)bucketOrd.apply(rangeStart));
                incrementDocCount.accept(ord, Long.valueOf(docCount.intValue()));
            };
            return FastFilterRewriteHelper.multiRangesTraverse(values.getPointTree(), ranges, incrementFunc, size);
        }

        private static long getBucketOrd(long bucketOrd) {
            if (bucketOrd < 0L) {
                bucketOrd = -1L - bucketOrd;
            }
            return bucketOrd;
        }
    }

    static interface AggregationType {
        public boolean isRewriteable(Object var1, int var2);

        public Ranges buildRanges(SearchContext var1, MappedFieldType var2) throws IOException;

        public Ranges buildRanges(LeafReaderContext var1, SearchContext var2, MappedFieldType var3) throws IOException;

        public DebugInfo tryFastFilterAggregation(PointValues var1, Ranges var2, BiConsumer<Long, Long> var3, Function<Object, Long> var4) throws IOException;
    }

    public static class FastFilterContext {
        private boolean rewriteable = false;
        private boolean rangesBuiltAtShardLevel = false;
        private AggregationType aggregationType;
        private final SearchContext context;
        private MappedFieldType fieldType;
        private Ranges ranges;
        public int leaf;
        public int inner;
        public int segments;
        public int optimizedSegments;

        public FastFilterContext(SearchContext context) {
            this.context = context;
        }

        public FastFilterContext(SearchContext context, AggregationType aggregationType) {
            this.context = context;
            this.aggregationType = aggregationType;
        }

        public AggregationType getAggregationType() {
            return this.aggregationType;
        }

        public void setAggregationType(AggregationType aggregationType) {
            this.aggregationType = aggregationType;
        }

        public boolean isRewriteable(Object parent, int subAggLength) {
            if (this.context.maxAggRewriteFilters() == 0) {
                return false;
            }
            boolean rewriteable = this.aggregationType.isRewriteable(parent, subAggLength);
            logger.debug("Fast filter rewriteable: {} for shard {}", (Object)rewriteable, (Object)this.context.indexShard().shardId());
            this.rewriteable = rewriteable;
            return rewriteable;
        }

        public void buildRanges(MappedFieldType fieldType) throws IOException {
            assert (this.ranges == null) : "Ranges should only be built once at shard level, but they are already built";
            this.fieldType = fieldType;
            this.ranges = this.aggregationType.buildRanges(this.context, fieldType);
            if (this.ranges != null) {
                logger.debug("Ranges built for shard {}", (Object)this.context.indexShard().shardId());
                this.rangesBuiltAtShardLevel = true;
            }
        }

        private Ranges buildRanges(LeafReaderContext leaf) throws IOException {
            Ranges ranges = this.aggregationType.buildRanges(leaf, this.context, this.fieldType);
            if (ranges != null) {
                logger.debug("Ranges built for shard {} segment {}", (Object)this.context.indexShard().shardId(), (Object)leaf.ord);
            }
            return ranges;
        }

        public boolean tryFastFilterAggregation(LeafReaderContext ctx, BiConsumer<Long, Long> incrementDocCount, Function<Object, Long> bucketOrd) throws IOException {
            ++this.segments;
            if (!this.rewriteable) {
                return false;
            }
            if (ctx.reader().hasDeletions()) {
                return false;
            }
            PointValues values = ctx.reader().getPointValues(this.fieldType.name());
            if (values == null) {
                return false;
            }
            if ((long)values.getDocCount() != values.size()) {
                return false;
            }
            NumericDocValues docCountValues = DocValues.getNumeric((LeafReader)ctx.reader(), (String)"_doc_count");
            if (docCountValues.nextDoc() != Integer.MAX_VALUE) {
                logger.debug("Shard {} segment {} has at least one document with _doc_count field, skip fast filter optimization", (Object)this.context.indexShard().shardId(), (Object)ctx.ord);
                return false;
            }
            if (!this.rangesBuiltAtShardLevel && !FastFilterRewriteHelper.segmentMatchAll(this.context, ctx)) {
                return false;
            }
            Ranges ranges = this.ranges;
            if (ranges == null) {
                logger.debug("Shard {} segment {} functionally match all documents. Build the fast filter", (Object)this.context.indexShard().shardId(), (Object)ctx.ord);
                ranges = this.buildRanges(ctx);
                if (ranges == null) {
                    return false;
                }
            }
            DebugInfo debugInfo = this.aggregationType.tryFastFilterAggregation(values, ranges, incrementDocCount, bucketOrd);
            this.consumeDebugInfo(debugInfo);
            ++this.optimizedSegments;
            logger.debug("Fast filter optimization applied to shard {} segment {}", (Object)this.context.indexShard().shardId(), (Object)ctx.ord);
            logger.debug("crossed leaf nodes: {}, inner nodes: {}", (Object)this.leaf, (Object)this.inner);
            return true;
        }

        private void consumeDebugInfo(DebugInfo debug) {
            this.leaf += debug.leaf;
            this.inner += debug.inner;
        }
    }
}

