/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.admin.cluster.decommission.awareness.put.DecommissionRequest;
import org.opensearch.action.admin.cluster.decommission.awareness.put.DecommissionResponse;
import org.opensearch.client.Requests;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.decommission.DecommissionAttribute;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestDecommissionAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/_cluster/decommission/awareness/{awareness_attribute_name}/{awareness_attribute_value}"));
    }

    @Override
    public String getName() {
        return "decommission_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        DecommissionRequest decommissionRequest = this.createRequest(request);
        return channel -> client.admin().cluster().decommission(decommissionRequest, new RestToXContentListener<DecommissionResponse>((RestChannel)channel));
    }

    DecommissionRequest createRequest(RestRequest request) throws IOException {
        DecommissionRequest decommissionRequest = Requests.decommissionRequest();
        String attributeName = request.param("awareness_attribute_name");
        String attributeValue = request.param("awareness_attribute_value");
        boolean noDelay = request.paramAsBoolean("no_delay", false);
        decommissionRequest.setNoDelay(noDelay);
        if (request.hasParam("delay_timeout")) {
            TimeValue delayTimeout = request.paramAsTime("delay_timeout", DecommissionRequest.DEFAULT_NODE_DRAINING_TIMEOUT);
            decommissionRequest.setDelayTimeout(delayTimeout);
        }
        return decommissionRequest.setDecommissionAttribute(new DecommissionAttribute(attributeName, attributeValue));
    }
}

