/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;

@FunctionalInterface
@PublicApi(since="1.0.0")
public interface RestHandler {
    public void handleRequest(RestRequest var1, RestChannel var2, NodeClient var3) throws Exception;

    default public boolean canTripCircuitBreaker() {
        return true;
    }

    default public boolean supportsContentStream() {
        return false;
    }

    default public boolean supportsStreaming() {
        return false;
    }

    default public boolean allowsUnsafeBuffers() {
        return false;
    }

    default public List<Route> routes() {
        return Collections.emptyList();
    }

    default public List<DeprecatedRoute> deprecatedRoutes() {
        return Collections.emptyList();
    }

    default public List<ReplacedRoute> replacedRoutes() {
        return Collections.emptyList();
    }

    default public boolean allowSystemIndexAccessByDefault() {
        return false;
    }

    public static RestHandler wrapper(RestHandler delegate) {
        return new Wrapper(delegate);
    }

    public static List<ReplacedRoute> replaceRoutes(List<Route> routes, String prefix, String deprecatedPrefix) {
        return routes.stream().map(route -> new ReplacedRoute((Route)route, prefix, deprecatedPrefix)).collect(Collectors.toList());
    }

    public static class Wrapper
    implements RestHandler {
        private final RestHandler delegate;

        public Wrapper(RestHandler delegate) {
            this.delegate = Objects.requireNonNull(delegate, "RestHandler delegate can not be null");
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
            this.delegate.handleRequest(request, channel, client);
        }

        @Override
        public boolean canTripCircuitBreaker() {
            return this.delegate.canTripCircuitBreaker();
        }

        @Override
        public boolean supportsContentStream() {
            return this.delegate.supportsContentStream();
        }

        @Override
        public boolean allowsUnsafeBuffers() {
            return this.delegate.allowsUnsafeBuffers();
        }

        @Override
        public List<Route> routes() {
            return this.delegate.routes();
        }

        @Override
        public List<DeprecatedRoute> deprecatedRoutes() {
            return this.delegate.deprecatedRoutes();
        }

        @Override
        public List<ReplacedRoute> replacedRoutes() {
            return this.delegate.replacedRoutes();
        }

        @Override
        public boolean allowSystemIndexAccessByDefault() {
            return this.delegate.allowSystemIndexAccessByDefault();
        }
    }

    @PublicApi(since="1.0.0")
    public static class ReplacedRoute
    extends Route {
        private final String deprecatedPath;
        private final RestRequest.Method deprecatedMethod;

        public ReplacedRoute(RestRequest.Method method, String path, RestRequest.Method deprecatedMethod, String deprecatedPath) {
            super(method, path);
            this.deprecatedMethod = deprecatedMethod;
            this.deprecatedPath = deprecatedPath;
        }

        public ReplacedRoute(RestRequest.Method method, String path, String deprecatedPath) {
            this(method, path, method, deprecatedPath);
        }

        public ReplacedRoute(Route route, String prefix, String deprecatedPrefix) {
            this(route.getMethod(), prefix + route.getPath(), deprecatedPrefix + route.getPath());
        }

        public String getDeprecatedPath() {
            return this.deprecatedPath;
        }

        public RestRequest.Method getDeprecatedMethod() {
            return this.deprecatedMethod;
        }
    }

    @PublicApi(since="1.0.0")
    public static class Route {
        protected final String path;
        protected final RestRequest.Method method;

        public Route(RestRequest.Method method, String path) {
            this.path = path;
            this.method = method;
        }

        public String getPath() {
            return this.path;
        }

        public String getPathWithPathParamsReplaced() {
            return this.path.replaceAll("(?<=\\{).*?(?=\\})", "path_param");
        }

        public RestRequest.Method getMethod() {
            return this.method;
        }

        public int hashCode() {
            String routeStr = "Route [method=" + String.valueOf((Object)this.method) + ", path=" + this.getPathWithPathParamsReplaced() + "]";
            return routeStr.hashCode();
        }

        public String toString() {
            return "Route [method=" + String.valueOf((Object)this.method) + ", path=" + this.path + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Route that = (Route)o;
            return Objects.equals((Object)this.method, (Object)that.method) && Objects.equals(this.getPathWithPathParamsReplaced(), that.getPathWithPathParamsReplaced());
        }
    }

    @PublicApi(since="1.0.0")
    public static class DeprecatedRoute
    extends Route {
        private final String deprecationMessage;

        public DeprecatedRoute(RestRequest.Method method, String path, String deprecationMessage) {
            super(method, path);
            this.deprecationMessage = deprecationMessage;
        }

        public String getDeprecationMessage() {
            return this.deprecationMessage;
        }
    }
}

