/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.template.put;

import java.io.IOException;
import org.opensearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportPutComposableIndexTemplateAction
extends TransportClusterManagerNodeAction<PutComposableIndexTemplateAction.Request, AcknowledgedResponse> {
    private final MetadataIndexTemplateService indexTemplateService;

    @Inject
    public TransportPutComposableIndexTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/index_template/put", transportService, clusterService, threadPool, actionFilters, PutComposableIndexTemplateAction.Request::new, indexNameExpressionResolver);
        this.indexTemplateService = indexTemplateService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(PutComposableIndexTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void clusterManagerOperation(PutComposableIndexTemplateAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        ComposableIndexTemplate indexTemplate = request.indexTemplate();
        this.indexTemplateService.putIndexTemplateV2(request.cause(), request.create(), request.name(), request.clusterManagerNodeTimeout(), indexTemplate, listener);
    }
}

