/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.permission;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.Client;
import org.opensearch.commons.authuser.User;

public class AccessController {
    @Generated
    private static final Logger log = LogManager.getLogger(AccessController.class);

    public static String getUserStr(Client client) {
        return (String)client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
    }

    public static User getUserContext(Client client) {
        return User.parse((String)AccessController.getUserStr(client));
    }

    public static boolean checkUserPermissions(User requestedUser, User resourceUser, String modelId) {
        if (requestedUser == null || resourceUser == null) {
            return true;
        }
        if (resourceUser.getBackendRoles() == null || requestedUser.getBackendRoles() == null) {
            return false;
        }
        for (String backendRole : requestedUser.getBackendRoles()) {
            if (!resourceUser.getBackendRoles().contains(backendRole)) continue;
            log.debug("User: " + requestedUser.getName() + " has backend role: " + backendRole + " permissions to access model: " + modelId);
            return true;
        }
        return false;
    }
}

