/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.stats;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.stats.MLAlgoStats;
import org.opensearch.ml.stats.MLModelStats;
import org.opensearch.ml.stats.MLNodeLevelStat;

public class MLStatsNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    private Map<MLNodeLevelStat, Object> nodeStats;
    private Map<FunctionName, MLAlgoStats> algorithmStats;
    private Map<String, MLModelStats> modelStats;

    public MLStatsNodeResponse(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.nodeStats = in.readMap(stream -> (MLNodeLevelStat)stream.readEnum(MLNodeLevelStat.class), StreamInput::readGenericValue);
        }
        if (in.readBoolean()) {
            this.algorithmStats = in.readMap(stream -> (FunctionName)stream.readEnum(FunctionName.class), MLAlgoStats::new);
        }
        if (in.readBoolean()) {
            this.modelStats = in.readMap(stream -> stream.readOptionalString(), MLModelStats::new);
        }
    }

    public MLStatsNodeResponse(DiscoveryNode node, Map<MLNodeLevelStat, Object> nodeStats) {
        super(node);
        this.nodeStats = nodeStats;
    }

    public MLStatsNodeResponse(DiscoveryNode node, Map<MLNodeLevelStat, Object> nodeStats, Map<FunctionName, MLAlgoStats> algorithmStats, Map<String, MLModelStats> modelStats) {
        super(node);
        this.nodeStats = nodeStats;
        this.algorithmStats = algorithmStats;
        this.modelStats = modelStats;
    }

    public boolean isEmpty() {
        return this.getNodeLevelStatSize() == 0 && this.getAlgorithmStatSize() == 0 && this.getModelStatSize() == 0;
    }

    public static MLStatsNodeResponse readStats(StreamInput in) throws IOException {
        return new MLStatsNodeResponse(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.nodeStats != null) {
            out.writeBoolean(true);
            out.writeMap(this.nodeStats, (stream, v) -> stream.writeEnum((Enum)v), StreamOutput::writeGenericValue);
        } else {
            out.writeBoolean(false);
        }
        if (this.algorithmStats != null) {
            out.writeBoolean(true);
            out.writeMap(this.algorithmStats, (stream, v) -> stream.writeEnum((Enum)v), (stream, stats) -> stats.writeTo(stream));
        } else {
            out.writeBoolean(false);
        }
        if (this.modelStats != null) {
            out.writeBoolean(true);
            out.writeMap(this.modelStats, (stream, v) -> stream.writeOptionalString(v), (stream, stats) -> stats.writeTo(stream));
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.nodeStats != null) {
            for (Map.Entry<MLNodeLevelStat, Object> entry : this.nodeStats.entrySet()) {
                builder.field(entry.getKey().name().toLowerCase(Locale.ROOT), entry.getValue());
            }
        }
        if (this.algorithmStats != null) {
            builder.startObject("algorithms");
            for (Map.Entry<Object, Object> entry : this.algorithmStats.entrySet()) {
                builder.startObject(((FunctionName)entry.getKey()).name().toLowerCase(Locale.ROOT));
                ((MLAlgoStats)entry.getValue()).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        if (this.modelStats != null) {
            builder.startObject("models");
            for (Map.Entry<Object, Object> entry : this.modelStats.entrySet()) {
                builder.startObject((String)entry.getKey());
                ((MLModelStats)entry.getValue()).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    public Object getNodeLevelStat(MLNodeLevelStat nodeLevelStat) {
        return this.nodeStats == null ? null : this.nodeStats.get((Object)nodeLevelStat);
    }

    public int getNodeLevelStatSize() {
        return this.nodeStats == null ? 0 : this.nodeStats.size();
    }

    public int getAlgorithmStatSize() {
        return this.algorithmStats == null ? 0 : this.algorithmStats.size();
    }

    public int getModelStatSize() {
        return this.modelStats == null ? 0 : this.modelStats.size();
    }

    public boolean hasAlgorithmStats(FunctionName algorithm) {
        return this.algorithmStats != null && this.algorithmStats.containsKey(algorithm);
    }

    public boolean hasModelStats(String modelId) {
        return this.modelStats != null && this.modelStats.containsKey(modelId);
    }

    public MLAlgoStats getAlgorithmStats(FunctionName algorithm) {
        return this.algorithmStats == null ? null : this.algorithmStats.get(algorithm);
    }

    public MLModelStats getModelStats(String modelId) {
        return this.modelStats == null ? null : this.modelStats.get(modelId);
    }

    public void removeAlgorithmStats(FunctionName algorithm) {
        if (this.algorithmStats != null) {
            this.algorithmStats.remove(algorithm);
        }
    }

    public void removeModelStats(String modelId) {
        if (this.modelStats != null) {
            this.modelStats.remove(modelId);
        }
    }
}

