/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.model_group;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.ml.common.exception.MLValidationException;
import org.opensearch.ml.common.transport.model_group.MLModelGroupDeleteRequest;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteModelGroupTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteModelGroupTransportAction.class);
    private Client client;
    private NamedXContentRegistry xContentRegistry;
    private ClusterService clusterService;
    private ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public DeleteModelGroupTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper) {
        super("cluster:admin/opensearch/ml/model_groups/delete", transportService, actionFilters, MLModelGroupDeleteRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLModelGroupDeleteRequest mlModelGroupDeleteRequest = MLModelGroupDeleteRequest.fromActionRequest((ActionRequest)request);
        String modelGroupId = mlModelGroupDeleteRequest.getModelGroupId();
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".plugins-ml-model-group", modelGroupId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> context.restore());
            this.modelAccessControlHelper.validateModelGroupAccess(user, modelGroupId, this.client, (ActionListener<Boolean>)ActionListener.wrap(access -> {
                if (!access.booleanValue()) {
                    wrappedListener.onFailure((Exception)new MLValidationException("User doesn't have privilege to delete this model group"));
                } else {
                    BoolQueryBuilder query = new BoolQueryBuilder();
                    query.filter((QueryBuilder)new TermQueryBuilder("model_group_id", modelGroupId));
                    SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)query);
                    SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-ml-model"}).source(searchSourceBuilder);
                    this.client.search(searchRequest, ActionListener.wrap(mlModels -> {
                        if (mlModels != null && mlModels.getHits().getTotalHits() != null && mlModels.getHits().getTotalHits().value != 0L) {
                            throw new MLValidationException("Cannot delete the model group when it has associated model versions");
                        }
                        this.deleteModelGroup(deleteRequest, modelGroupId, (ActionListener<DeleteResponse>)wrappedListener);
                    }, e -> {
                        if (e instanceof IndexNotFoundException) {
                            this.deleteModelGroup(deleteRequest, modelGroupId, (ActionListener<DeleteResponse>)wrappedListener);
                        } else {
                            log.error("Failed to search models with the specified Model Group Id " + modelGroupId, (Throwable)e);
                            wrappedListener.onFailure(e);
                        }
                    }));
                }
            }, e -> {
                log.error("Failed to validate Access for Model Group " + modelGroupId, (Throwable)e);
                wrappedListener.onFailure(e);
            }));
        }
    }

    private void deleteModelGroup(DeleteRequest deleteRequest, final String modelGroupId, final ActionListener<DeleteResponse> actionListener) {
        this.client.delete(deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse deleteResponse) {
                log.debug("Completed Delete Model Group Request, task id:{} deleted", (Object)modelGroupId);
                actionListener.onResponse((Object)deleteResponse);
            }

            public void onFailure(Exception e) {
                log.error("Failed to delete ML Model Group " + modelGroupId, (Throwable)e);
                actionListener.onFailure(e);
            }
        });
    }
}

