/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.Mergeable;

public class SuggestConfigParamResponse
extends ActionResponse
implements ToXContentObject,
Mergeable {
    public static final String INTERVAL_FIELD = "interval";
    public static final String HORIZON_FIELD = "horizon";
    public static final String HISTORY_FIELD = "history";
    private IntervalTimeConfiguration interval;
    private Integer horizon;
    private Integer history;

    public IntervalTimeConfiguration getInterval() {
        return this.interval;
    }

    public Integer getHorizon() {
        return this.horizon;
    }

    public Integer getHistory() {
        return this.history;
    }

    public SuggestConfigParamResponse(IntervalTimeConfiguration interval, Integer horizon, Integer history) {
        this.interval = interval;
        this.horizon = horizon;
        this.history = history;
    }

    public SuggestConfigParamResponse(StreamInput in) throws IOException {
        super(in);
        this.interval = in.readBoolean() ? IntervalTimeConfiguration.readFrom(in) : null;
        this.horizon = in.readOptionalInt();
        this.history = in.readOptionalInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.interval != null) {
            out.writeBoolean(true);
            this.interval.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInt(this.horizon);
        out.writeOptionalInt(this.history);
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        return this.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        if (this.interval != null) {
            xContentBuilder.field(INTERVAL_FIELD, (ToXContent)this.interval);
        }
        if (this.horizon != null) {
            xContentBuilder.field(HORIZON_FIELD, this.horizon);
        }
        if (this.history != null) {
            xContentBuilder.field(HISTORY_FIELD, this.history);
        }
        return xContentBuilder.endObject();
    }

    @Override
    public void merge(Mergeable other) {
        if (this == other || other == null || this.getClass() != other.getClass()) {
            return;
        }
        SuggestConfigParamResponse otherProfile = (SuggestConfigParamResponse)other;
        if (otherProfile.getInterval() != null) {
            this.interval = otherProfile.getInterval();
        }
        if (otherProfile.getHorizon() != null) {
            this.horizon = otherProfile.getHorizon();
        }
        if (otherProfile.getHistory() != null) {
            this.history = otherProfile.getHistory();
        }
    }

    public static class Builder {
        protected IntervalTimeConfiguration interval = null;
        protected Integer horizon = null;
        protected Integer history = null;

        public Builder interval(IntervalTimeConfiguration interval) {
            this.interval = interval;
            return this;
        }

        public Builder horizon(Integer horizon) {
            this.horizon = horizon;
            return this;
        }

        public Builder history(Integer history) {
            this.history = history;
            return this;
        }

        public SuggestConfigParamResponse build() {
            return new SuggestConfigParamResponse(this.interval, this.horizon, this.history);
        }
    }
}

