/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.ratelimit;

import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.breaker.CircuitBreakerService;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.ml.CheckpointDao;
import org.opensearch.timeseries.ml.ModelState;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.ratelimit.BatchWorker;
import org.opensearch.timeseries.ratelimit.CheckpointWriteRequest;
import org.opensearch.timeseries.ratelimit.RequestPriority;
import org.opensearch.timeseries.util.ExceptionUtil;

public abstract class CheckpointWriteWorker<RCFModelType, IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>, CheckpointDaoType extends CheckpointDao<RCFModelType, IndexType, IndexManagementType>>
extends BatchWorker<CheckpointWriteRequest, BulkRequest, BulkResponse> {
    private static final Logger LOG = LogManager.getLogger(CheckpointWriteWorker.class);
    protected final CheckpointDaoType checkpoint;
    protected final String indexName;
    protected final Duration checkpointInterval;

    public CheckpointWriteWorker(String queueName, long heapSize, int singleRequestSize, Setting<Float> maxHeapPercentForQueueSetting, ClusterService clusterService, Random random, CircuitBreakerService circuitBreakerService, ThreadPool threadPool, String threadPoolName, Settings settings, float maxQueuedTaskRatio, Clock clock, float mediumSegmentPruneRatio, float lowSegmentPruneRatio, int maintenanceFreqConstant, Setting<Integer> concurrencySetting, Duration executionTtl, Setting<Integer> batchSizeSetting, Duration stateTtl, NodeStateManager timeSeriesNodeStateManager, CheckpointDaoType checkpoint, String indexName, Duration checkpointInterval, AnalysisType context) {
        super(queueName, heapSize, singleRequestSize, maxHeapPercentForQueueSetting, clusterService, random, circuitBreakerService, threadPool, threadPoolName, settings, maxQueuedTaskRatio, clock, mediumSegmentPruneRatio, lowSegmentPruneRatio, maintenanceFreqConstant, concurrencySetting, executionTtl, batchSizeSetting, stateTtl, timeSeriesNodeStateManager, context);
        this.checkpoint = checkpoint;
        this.indexName = indexName;
        this.checkpointInterval = checkpointInterval;
    }

    @Override
    protected void executeBatchRequest(BulkRequest request, ActionListener<BulkResponse> listener) {
        ((CheckpointDao)this.checkpoint).batchWrite(request, listener);
    }

    @Override
    protected BulkRequest toBatchRequest(List<CheckpointWriteRequest> toProcess) {
        BulkRequest bulkRequest = new BulkRequest();
        for (CheckpointWriteRequest request : toProcess) {
            bulkRequest.add(request.getUpdateRequest());
        }
        return bulkRequest;
    }

    @Override
    protected ActionListener<BulkResponse> getResponseListener(List<CheckpointWriteRequest> toProcess, BulkRequest batchRequest) {
        return ActionListener.wrap(response -> {
            for (BulkItemResponse r : response.getItems()) {
                if (r.getFailureMessage() == null) continue;
                LOG.error(r.getFailureMessage());
            }
        }, exception -> {
            if (ExceptionUtil.isOverloaded(exception)) {
                LOG.error("too many get AD model checkpoint requests or shard not avialble");
                this.setCoolDownStart();
            }
            for (CheckpointWriteRequest request : toProcess) {
                this.nodeStateManager.setException(request.getConfigId(), (Exception)exception);
            }
            LOG.error("Fail to save models", (Throwable)exception);
        });
    }

    public void write(ModelState<RCFModelType> modelState, boolean forceWrite, RequestPriority priority) {
        if (((CheckpointDao)this.checkpoint).shouldSave(modelState, forceWrite, this.checkpointInterval, this.clock)) {
            String configId = modelState.getConfigId();
            String modelId = modelState.getModelId();
            if (modelId == null || configId == null) {
                return;
            }
            this.nodeStateManager.getConfig(configId, this.context, this.onGetConfig(configId, modelId, modelState, priority));
        }
    }

    private ActionListener<Optional<? extends Config>> onGetConfig(String configId, String modelId, ModelState<RCFModelType> modelState, RequestPriority priority) {
        return ActionListener.wrap(configOptional -> {
            if (!configOptional.isPresent()) {
                LOG.warn((Message)new ParameterizedMessage("Config [{}] is not available.", (Object)configId));
                return;
            }
            Config config = (Config)configOptional.get();
            try {
                Map<String, Object> source = ((CheckpointDao)this.checkpoint).toIndexSource(modelState);
                if (source == null || source.isEmpty()) {
                    return;
                }
                modelState.setLastCheckpointTime(this.clock.instant());
                CheckpointWriteRequest request = new CheckpointWriteRequest(System.currentTimeMillis() + config.getIntervalInMilliseconds(), configId, priority, new UpdateRequest(this.indexName, modelId).docAsUpsert(true).doc(source));
                this.put(request);
            }
            catch (Exception e) {
                LOG.error((Message)new ParameterizedMessage("Exception while serializing models for [{}]", (Object)modelId), (Throwable)e);
            }
        }, exception -> LOG.error((Message)new ParameterizedMessage("fail to get config [{}]", (Object)configId), (Throwable)exception));
    }

    public void writeAll(List<ModelState<RCFModelType>> modelStates, String configId, boolean forceWrite, RequestPriority priority) {
        ActionListener onGetForAll = ActionListener.wrap(configOptional -> {
            if (!configOptional.isPresent()) {
                LOG.warn((Message)new ParameterizedMessage("Config [{}] is not available.", (Object)configId));
                return;
            }
            Config config = (Config)configOptional.get();
            try {
                ArrayList<CheckpointWriteRequest> allRequests = new ArrayList<CheckpointWriteRequest>();
                for (ModelState state : modelStates) {
                    if (!((CheckpointDao)this.checkpoint).shouldSave(state, forceWrite, this.checkpointInterval, this.clock)) continue;
                    Map<String, Object> source = ((CheckpointDao)this.checkpoint).toIndexSource(state);
                    String modelId = state.getModelId();
                    if (source == null || source.isEmpty() || Strings.isEmpty((CharSequence)modelId)) continue;
                    state.setLastCheckpointTime(this.clock.instant());
                    allRequests.add(new CheckpointWriteRequest(System.currentTimeMillis() + config.getIntervalInMilliseconds(), configId, priority, new UpdateRequest(this.indexName, modelId).docAsUpsert(true).doc(source)));
                }
                this.putAll(allRequests);
            }
            catch (Exception e) {
                LOG.info((Message)new ParameterizedMessage("Exception while serializing models for [{}]", (Object)configId), (Throwable)e);
            }
        }, exception -> LOG.error((Message)new ParameterizedMessage("fail to get config [{}]", (Object)configId), (Throwable)exception));
        this.nodeStateManager.getConfig(configId, this.context, (ActionListener<Optional<? extends Config>>)onGetForAll);
    }
}

