/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.ml;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.time.Clock;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.core.action.ActionListener;
import org.opensearch.timeseries.MemoryTracker;
import org.opensearch.timeseries.feature.FeatureManager;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.ml.CheckpointDao;
import org.opensearch.timeseries.ml.IntermediateResult;
import org.opensearch.timeseries.ml.ModelColdStart;
import org.opensearch.timeseries.ml.ModelState;
import org.opensearch.timeseries.ml.Sample;
import org.opensearch.timeseries.ml.SingleStreamModelIdMapper;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.ratelimit.CheckpointWriteWorker;

public abstract class ModelManager<RCFModelType extends ThresholdedRandomCutForest, IndexableResultType extends IndexableResult, IntermediateResultType extends IntermediateResult<IndexableResultType>, IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>, CheckpointDaoType extends CheckpointDao<RCFModelType, IndexType, IndexManagementType>, CheckpointWriteWorkerType extends CheckpointWriteWorker<RCFModelType, IndexType, IndexManagementType, CheckpointDaoType>, ColdStarterType extends ModelColdStart<RCFModelType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriteWorkerType>> {
    private static final Logger LOG = LogManager.getLogger(ModelManager.class);
    protected final int rcfNumTrees;
    protected final int rcfNumSamplesInTree;
    protected final int rcfNumMinSamples;
    protected ColdStarterType coldStarter;
    protected MemoryTracker memoryTracker;
    protected final Clock clock;
    protected FeatureManager featureManager;
    protected final CheckpointDaoType checkpointDao;

    public ModelManager(int rcfNumTrees, int rcfNumSamplesInTree, int rcfNumMinSamples, ColdStarterType coldStarter, MemoryTracker memoryTracker, Clock clock, FeatureManager featureManager, CheckpointDaoType checkpointDao) {
        this.rcfNumTrees = rcfNumTrees;
        this.rcfNumSamplesInTree = rcfNumSamplesInTree;
        this.rcfNumMinSamples = rcfNumMinSamples;
        this.coldStarter = coldStarter;
        this.memoryTracker = memoryTracker;
        this.clock = clock;
        this.featureManager = featureManager;
        this.checkpointDao = checkpointDao;
    }

    public IntermediateResultType getResult(Sample sample, ModelState<RCFModelType> modelState, String modelId, Config config, String taskId) {
        IntermediateResultType result = this.createEmptyResult();
        if (modelState != null) {
            Optional<RCFModelType> entityModel = modelState.getModel();
            if (entityModel.isEmpty()) {
                ((ModelColdStart)this.coldStarter).trainModelFromExistingSamples(modelState, config, taskId);
            }
            if (modelState.getModel().isPresent()) {
                result = this.score(sample, modelId, modelState, config);
            } else {
                modelState.addSample(sample);
            }
        }
        return result;
    }

    public void clearModels(String detectorId, Map<String, ?> models, ActionListener<Void> listener) {
        Iterator<String> id = models.keySet().iterator();
        this.clearModelForIterator(detectorId, models, id, listener);
    }

    protected void clearModelForIterator(String detectorId, Map<String, ?> models, Iterator<String> idIter, ActionListener<Void> listener) {
        if (idIter.hasNext()) {
            String modelId = idIter.next();
            if (SingleStreamModelIdMapper.getConfigIdForModelId(modelId).equals(detectorId)) {
                models.remove(modelId);
                ((CheckpointDao)this.checkpointDao).deleteModelCheckpoint(modelId, (ActionListener<Void>)ActionListener.wrap(r -> this.clearModelForIterator(detectorId, models, idIter, listener), arg_0 -> listener.onFailure(arg_0)));
            } else {
                this.clearModelForIterator(detectorId, models, idIter, listener);
            }
        } else {
            listener.onResponse(null);
        }
    }

    public <RCFDescriptor extends AnomalyDescriptor> IntermediateResultType score(Sample sample, String modelId, ModelState<RCFModelType> modelState, Config config) {
        IntermediateResultType result = this.createEmptyResult();
        Optional<RCFModelType> model = modelState.getModel();
        try {
            if (model != null && model.isPresent()) {
                AnomalyDescriptor lastResult;
                ThresholdedRandomCutForest rcfModel = (ThresholdedRandomCutForest)model.get();
                if (!modelState.getSamples().isEmpty()) {
                    for (Sample unProcessedSample : modelState.getSamples()) {
                        rcfModel.process(unProcessedSample.getValueList(), unProcessedSample.getDataEndTime().getEpochSecond());
                    }
                    modelState.clearSamples();
                }
                if ((lastResult = rcfModel.process(sample.getValueList(), sample.getDataEndTime().getEpochSecond())) != null) {
                    result = this.toResult(rcfModel.getForest(), lastResult);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Message)new ParameterizedMessage("Fail to score for [{}]: model Id [{}], feature [{}]", new Object[]{modelState.getEntity().isEmpty() ? modelState.getConfigId() : modelState.getEntity().get(), modelId, Arrays.toString(sample.getValueList())}), (Throwable)e);
            throw e;
        }
        finally {
            modelState.setLastUsedTime(this.clock.instant());
        }
        return result;
    }

    protected abstract IntermediateResultType createEmptyResult();

    protected abstract <RCFDescriptor extends AnomalyDescriptor> IntermediateResultType toResult(RandomCutForest var1, RCFDescriptor var2);

    public static enum ModelType {
        RCF("rcf"),
        THRESHOLD("threshold"),
        TRCF("trcf"),
        RCFCASTER("rcf_caster");

        private String name;

        private ModelType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

