/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement.api.transport.delete;

import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.snapshotmanagement.SMUtilsKt;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.BaseTransportAction;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.delete.DeleteSMPolicyRequest;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.delete.TransportDeleteSMPolicyAction;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMPolicy;
import org.opensearch.indexmanagement.snapshotmanagement.settings.SnapshotManagementSettings;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001 B/\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ+\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0016\u0010\u0015\u001a\n \u0013*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/delete/TransportDeleteSMPolicyAction;", "Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/BaseTransportAction;", "Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/delete/DeleteSMPolicyRequest;", "Lorg/opensearch/action/delete/DeleteResponse;", "client", "Lorg/opensearch/client/Client;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "(Lorg/opensearch/client/Client;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;)V", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "log", "Lorg/apache/logging/log4j/Logger;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "executeRequest", "request", "user", "Lorg/opensearch/commons/authuser/User;", "threadContext", "Lorg/opensearch/common/util/concurrent/ThreadContext$StoredContext;", "(Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/delete/DeleteSMPolicyRequest;Lorg/opensearch/commons/authuser/User;Lorg/opensearch/common/util/concurrent/ThreadContext$StoredContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "opensearch-index-management"})
public final class TransportDeleteSMPolicyAction
extends BaseTransportAction<DeleteSMPolicyRequest, DeleteResponse> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    private final Logger log;
    private volatile Boolean filterByEnabled;
    @NotNull
    private static final String conflictExceptionMessage = "Failed while trying to delete SM Policy due to a concurrent update, please try again";

    @Inject
    public TransportDeleteSMPolicyAction(@NotNull Client client, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull ClusterService clusterService, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super("cluster:admin/opensearch/snapshot_management/policy/delete", transportService, client, actionFilters, DeleteSMPolicyRequest::new);
        this.clusterService = clusterService;
        this.settings = settings;
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.filterByEnabled = (Boolean)SnapshotManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SnapshotManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportDeleteSMPolicyAction._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object executeRequest(@NotNull DeleteSMPolicyRequest var1_1, @Nullable User var2_2, @NotNull ThreadContext.StoredContext var3_3, @NotNull Continuation<? super DeleteResponse> var4_4) {
        if (!(var4_4 instanceof executeRequest.1)) ** GOTO lbl-1000
        var9_5 = var4_4;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ TransportDeleteSMPolicyAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.executeRequest((DeleteSMPolicyRequest)null, (User)null, (ThreadContext.StoredContext)null, (Continuation<? super DeleteResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getClient();
                v1 = request.id();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"request.id()");
                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.L$2 = user;
                $continuation.label = 1;
                v2 = SMUtilsKt.getSMPolicy(v0, v1, (Continuation<? super SMPolicy>)$continuation);
                if (v2 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl29
            }
            case 1: {
                user = (User)$continuation.L$2;
                request = (DeleteSMPolicyRequest)$continuation.L$1;
                this = (TransportDeleteSMPolicyAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl29:
                // 2 sources

                smPolicy = (SMPolicy)v2;
                v3 = smPolicy.getUser();
                var6_9 = this.filterByEnabled;
                Intrinsics.checkNotNullExpressionValue((Object)var6_9, (String)"filterByEnabled");
                SecurityUtils.Companion.verifyUserHasPermissionForResource(user, v3, var6_9, "snapshot management policy", smPolicy.getPolicyName());
                deleteReq = (DeleteRequest)request.index(".opendistro-ism-config");
                $continuation.L$0 = this;
                $continuation.L$1 = deleteReq;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v4 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.getClient(), (Function2)new Function2<Client, ActionListener<DeleteResponse>, Unit>(deleteReq){
                    final /* synthetic */ DeleteRequest $deleteReq;
                    {
                        this.$deleteReq = $deleteReq;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<DeleteResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.delete(this.$deleteReq, it);
                    }
                }, $continuation);
                ** if (v4 != var10_7) goto lbl44
lbl43:
                // 1 sources

                return var10_7;
lbl44:
                // 1 sources

                ** GOTO lbl52
            }
            case 2: {
                deleteReq = (DeleteRequest)$continuation.L$1;
                this = (TransportDeleteSMPolicyAction)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl52:
                    // 2 sources

                    return v4;
                }
                catch (VersionConflictEngineException e) {
                    this.log.error("VersionConflictEngineException while trying to delete snapshot management policy id [" + deleteReq.id() + "]: " + e);
                    throw new OpenSearchStatusException("Failed while trying to delete SM Policy due to a concurrent update, please try again", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                }
                catch (Exception e) {
                    this.log.error("Failed trying to delete snapshot management policy id [" + deleteReq.id() + "]: " + e);
                    throw new OpenSearchStatusException("Failed while trying to delete SM Policy", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void _init_$lambda$0(TransportDeleteSMPolicyAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterByEnabled = it;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/delete/TransportDeleteSMPolicyAction$Companion;", "", "()V", "conflictExceptionMessage", "", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

