/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.rest.action;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.jobscheduler.rest.action.VisibleForTesting;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.utils.LockService;
import org.opensearch.jobscheduler.transport.AcquireLockRequest;
import org.opensearch.jobscheduler.transport.AcquireLockResponse;
import org.opensearch.jobscheduler.utils.JobDetailsService;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;

public class RestGetLockAction
extends BaseRestHandler {
    private final Logger logger = LogManager.getLogger(RestGetLockAction.class);
    public LockService lockService;

    public RestGetLockAction(LockService lockService) {
        this.lockService = lockService;
    }

    public String getName() {
        return "get_lock_action";
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/%s", "/_plugins/_job_scheduler", "_lock")));
    }

    @VisibleForTesting
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        XContentParser parser = restRequest.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        AcquireLockRequest acquireLockRequest = AcquireLockRequest.parse(parser);
        String jobId = acquireLockRequest.getJobId();
        String jobIndexName = acquireLockRequest.getJobIndexName();
        long lockDurationSeconds = acquireLockRequest.getLockDurationSeconds();
        CompletableFuture inProgressFuture = new CompletableFuture();
        this.lockService.acquireLockWithId(jobIndexName, Long.valueOf(lockDurationSeconds), jobId, ActionListener.wrap(lockModel -> inProgressFuture.complete(lockModel), exception -> {
            this.logger.error("Could not acquire lock with ID : " + jobId, (Throwable)exception);
            inProgressFuture.completeExceptionally((Throwable)exception);
        }));
        try {
            inProgressFuture.orTimeout(JobDetailsService.TIME_OUT_FOR_REQUEST, TimeUnit.SECONDS);
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof TimeoutException) {
                this.logger.error("Acquiring lock timed out ", (Throwable)e);
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        return channel -> {
            LockModel lockModelResponseHolder = null;
            try {
                lockModelResponseHolder = (LockModel)inProgressFuture.get();
            }
            catch (Exception e) {
                this.logger.error("Exception occured in acquiring lock ", (Throwable)e);
            }
            try (XContentBuilder builder = channel.newBuilder();){
                String restResponseString;
                RestStatus restStatus = RestStatus.OK;
                String string = restResponseString = lockModelResponseHolder != null ? "success" : "failed";
                if (restResponseString.equals("success")) {
                    AcquireLockResponse acquireLockResponse = new AcquireLockResponse(lockModelResponseHolder, LockModel.generateLockId((String)jobIndexName, (String)jobId), lockModelResponseHolder.getSeqNo(), lockModelResponseHolder.getPrimaryTerm());
                    acquireLockResponse.toXContent(builder, ToXContent.EMPTY_PARAMS);
                } else {
                    restStatus = RestStatus.INTERNAL_SERVER_ERROR;
                }
                BytesRestResponse bytesRestResponse = new BytesRestResponse(restStatus, builder);
                channel.sendResponse((RestResponse)bytesRestResponse);
            }
        };
    }
}

