/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.spring.mvc;

import com.alibaba.druid.filter.stat.StatFilterContext;
import com.alibaba.druid.support.http.AbstractWebStatImpl;
import com.alibaba.druid.support.http.stat.WebAppStat;
import com.alibaba.druid.support.http.stat.WebAppStatManager;
import com.alibaba.druid.support.http.stat.WebRequestStat;
import com.alibaba.druid.support.http.stat.WebSessionStat;
import com.alibaba.druid.support.http.stat.WebURIStat;
import com.alibaba.druid.support.profile.ProfileEntryKey;
import com.alibaba.druid.support.profile.ProfileEntryReqStat;
import com.alibaba.druid.support.profile.Profiler;
import com.alibaba.druid.util.DruidWebUtils;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;

public class StatHandlerInterceptor
extends AbstractWebStatImpl
implements HandlerInterceptor,
InitializingBean,
DisposableBean {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        int index;
        WebAppStat webAppStat = this.getWebAppStat(request);
        String requestURI = this.getRequestURI(request);
        long startNano = System.nanoTime();
        long startMillis = System.currentTimeMillis();
        WebRequestStat requestStat = new WebRequestStat(startNano, startMillis);
        WebRequestStat.set(requestStat);
        WebSessionStat sessionStat = this.getSessionStat(request);
        webAppStat.beforeInvoke();
        WebURIStat uriStat = webAppStat.getURIStat(requestURI, false);
        if (uriStat == null && (index = requestURI.indexOf(";jsessionid=")) != -1) {
            requestURI = requestURI.substring(0, index);
            uriStat = webAppStat.getURIStat(requestURI, false);
        }
        if (this.isProfileEnable()) {
            Profiler.initLocal();
            Profiler.enter(requestURI, "WEB");
        }
        if (uriStat != null) {
            uriStat.beforeInvoke();
        }
        if (sessionStat != null) {
            sessionStat.beforeInvoke();
        }
        return true;
    }

    public WebAppStat getWebAppStat(HttpServletRequest request) {
        if (this.webAppStat != null) {
            return this.webAppStat;
        }
        ServletContext context = request.getSession().getServletContext();
        String contextPath = DruidWebUtils.getContextPath(context);
        this.webAppStat = WebAppStatManager.getInstance().getWebAppStat(contextPath);
        return this.webAppStat;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception error) throws Exception {
        WebRequestStat requestStat = WebRequestStat.current();
        long endNano = System.nanoTime();
        requestStat.setEndNano(endNano);
        WebSessionStat sessionStat = this.getSessionStat(request);
        WebURIStat uriStat = WebURIStat.current();
        long nanos = endNano - requestStat.getStartNano();
        this.webAppStat.afterInvoke(null, nanos);
        if (sessionStat == null && (sessionStat = this.getSessionStat(request)) != null) {
            sessionStat.beforeInvoke();
        }
        if (sessionStat != null) {
            sessionStat.afterInvoke(error, nanos);
            sessionStat.setPrincipal(this.getPrincipal(request));
        }
        if (uriStat != null) {
            uriStat.afterInvoke(error, nanos);
        }
        WebRequestStat.set(null);
        if (this.isProfileEnable()) {
            Profiler.release(nanos);
            Map<ProfileEntryKey, ProfileEntryReqStat> requestStatsMap = Profiler.getStatsMap();
            if (uriStat != null) {
                uriStat.getProfiletat().record(requestStatsMap);
            }
            Profiler.removeLocal();
        }
    }

    @Override
    public String getRequestURI(HttpServletRequest request) {
        return (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
    }

    public void afterPropertiesSet() throws Exception {
        StatFilterContext.getInstance().addContextListener(this.statFilterContextListener);
    }

    public void destroy() throws Exception {
        StatFilterContext.getInstance().removeContextListener(this.statFilterContextListener);
    }
}

