/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api.ssl;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.opensearch.OpenSearchException;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.security.dlic.rest.api.ssl.CertificatesInfo;

public class CertificatesNodesResponse
extends BaseNodesResponse<CertificatesNodeResponse>
implements ToXContentFragment {
    public CertificatesNodesResponse(StreamInput in) throws IOException {
        super(in);
    }

    public CertificatesNodesResponse(ClusterName clusterName, List<CertificatesNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    protected List<CertificatesNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(CertificatesNodeResponse::new);
    }

    protected void writeNodesTo(StreamOutput out, List<CertificatesNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("nodes");
        for (CertificatesNodeResponse node : this.getNodes()) {
            builder.startObject(node.getNode().getId());
            builder.field("name", node.getNode().getName());
            if (node.exception() != null) {
                builder.startObject("load_exception");
                OpenSearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)node.exception);
                builder.endObject();
            }
            if (node.certificates() != null) {
                node.certificates.toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static class CertificatesNodeResponse
    extends BaseNodeResponse {
        private final Exception exception;
        private final CertificatesInfo certificates;

        public CertificatesNodeResponse(DiscoveryNode node, Exception exception) {
            super(node);
            this.exception = exception;
            this.certificates = null;
        }

        public CertificatesNodeResponse(DiscoveryNode node, CertificatesInfo certificates) {
            super(node);
            this.exception = null;
            this.certificates = certificates;
        }

        public CertificatesNodeResponse(StreamInput in) throws IOException {
            super(in);
            if (in.readBoolean()) {
                this.exception = in.readException();
                this.certificates = null;
            } else {
                this.exception = null;
                this.certificates = (CertificatesInfo)in.readOptionalWriteable(CertificatesInfo::new);
            }
        }

        public CertificatesInfo certificates() {
            return this.certificates;
        }

        public Exception exception() {
            return this.exception;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (this.exception != null) {
                out.writeBoolean(true);
                out.writeException((Throwable)this.exception);
            }
            if (this.certificates != null) {
                out.writeBoolean(false);
                out.writeOptionalWriteable((Writeable)this.certificates);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            CertificatesNodeResponse that = (CertificatesNodeResponse)((Object)o);
            return Objects.equals(this.exception, that.exception) && Objects.equals(this.certificates, that.certificates);
        }

        public int hashCode() {
            return Objects.hash(this.exception, this.certificates);
        }
    }
}

